<?php
/**
 * Theme Post excerpt Template
 * @package payone
 * @since 1.0.0
 */

$payone = payone();
$post_meta = Payone_Group_Fields_Value::post_meta('blog_post');
$excerpt_length = !empty($post_meta['excerpt_length']) ? $post_meta['excerpt_length'] : 55;
$readmore_text = !empty($post_meta['readmore_btn_text']) ? $post_meta['readmore_btn_text'] : esc_html__('Read More','payone');


Payone_Excerpt($excerpt_length);
?>
<div class="blog-bottom mt-3">
	<?php
	if($post_meta['readmore_btn']){
		printf('<a href="%1$s" class="fw-semibold tw-text-4 text-dark-600 px-5 tw-py-3 bg-neutral-10 tw-rounded-xl text-center hover-bg-base-two-600 hover-text-white tw-duration-500">%2$s <i class="ti ti-arrow-up-right"></i> </a>',esc_url(get_the_permalink()),esc_html($readmore_text));
	}
	?>
</div>