<?php
/**
 * Template part for displaying single team post
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package payone
 */

$payone = payone();
$payone_meta = get_post_meta(get_the_ID(), 'payone_team_options', true);
$img_id = get_post_thumbnail_id(get_the_ID()) ? get_post_thumbnail_id(get_the_ID()) : false;
$img_url_val = $img_id ? wp_get_attachment_image_src($img_id, 'full', false) : '';
$img_url = is_array($img_url_val) && !empty($img_url_val) ? $img_url_val[0] : '';
$img_alt = $img_id ? get_post_meta($img_id, '_wp_attachment_image_alt', true) : '';
$designation = isset($payone_meta['designation']) && !empty($payone_meta['designation']) ? $payone_meta['designation'] : '';
$description = isset($payone_meta['description']) && !empty($payone_meta['description']) ? $payone_meta['description'] : '';
$description_2 = isset($payone_meta['description_2']) && !empty($payone_meta['description_2']) ? $payone_meta['description_2'] : '';
$team_info = isset($payone_meta['team-info']) && !empty($payone_meta['team-info']) ? $payone_meta['team-info'] : '';

?>

<article id="post-<?php the_ID(); ?>" <?php post_class('payone-details-content-area team-details-section'); ?>>
    <div class="entry-content">
        <?php
        the_content();
        $payone->link_pages();
        ?>
    </div>
</article><!-- #post-<?php the_ID(); ?> -->