<?php
/**
 * Theme functions & definitations
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package payone
 */

/**
 * Define Theme Folder Path & URL Constant
 * @package payone
 * @since 1.0.0
 */

define('PAYONE_THEME_ROOT', get_template_directory());
define('PAYONE_THEME_ROOT_URL', get_template_directory_uri());
define('PAYONE_INC', PAYONE_THEME_ROOT . '/inc');
define('PAYONE_THEME_SETTINGS', PAYONE_INC . '/theme-settings');
define('PAYONE_THEME_SETTINGS_IMAGES', PAYONE_THEME_ROOT_URL . '/inc/theme-settings/images');
define('PAYONE_TGMA', PAYONE_INC . '/plugins/tgma');
define('PAYONE_DYNAMIC_STYLESHEETS', PAYONE_INC . '/theme-stylesheets');
define('PAYONE_CSS', PAYONE_THEME_ROOT_URL . '/assets/css');
define('PAYONE_JS', PAYONE_THEME_ROOT_URL . '/assets/js');
define('PAYONE_ASSETS', PAYONE_THEME_ROOT_URL . '/assets');
define('PAYONE_DEV', true);


/**
 * Theme Initial File
 * @package payone
 * @since 1.0.0
 */
if (file_exists(PAYONE_INC . '/theme-init.php')) {
    require_once PAYONE_INC . '/theme-init.php';
}


/**
 * Codester Framework Functions
 * @package payone
 * @since 1.0.0
 */
if (file_exists(PAYONE_INC . '/theme-cs-function.php')) {
    require_once PAYONE_INC . '/theme-cs-function.php';
}


/**
 * Theme Helpers Functions
 * @package payone
 * @since 1.0.0
 */
if (file_exists(PAYONE_INC . '/theme-helper-functions.php')) {

    require_once PAYONE_INC . '/theme-helper-functions.php';
    if (!function_exists('payone')) {
        function payone()
        {
            return class_exists('Payone_Helper_Functions') ? new Payone_Helper_Functions() : false;
        }
    }
}

/**
 * Nav menu fallback function
 * @since 1.0.0
 */
if (is_user_logged_in()) {
    function payone_theme_fallback_menu()
    {
        get_template_part('template-parts/default', 'menu');
    }
}