<?php
/**
 * Footer Style 03
 * @package payone
 * @since 1.0.0
 */
$copyright_one_text = !empty(cs_get_option('copyright_one_text')) ? cs_get_option('copyright_one_text') : esc_html__('Copyright © 2025 Payone All Rights Reserved.', 'payone');
$copyright_one_text = str_replace('{copy}', '&copy;', $copyright_one_text);
$copyright_one_text = str_replace('{year}', date('Y'), $copyright_one_text);

$footer_three_subscribe_enable = cs_get_option('footer_three_subscribe_enable');
$footer_three_subscribe_bg = cs_get_option('footer_three_subscribe_bg');
$footer_three_subscribe_title = cs_get_option('footer_three_subscribe_title');
$footer_three_subscribe_content = cs_get_option('footer_three_subscribe_content');
$footer_three_subscribe_shortcode = cs_get_option('footer_three_subscribe_shortcode');
$footer_three_bg_image = cs_get_option('footer_three_bg_image');

$footer_three_subscribe_img_url = '';
if(!empty($footer_three_subscribe_bg['url'])){
    $footer_three_subscribe_img_url = $footer_three_subscribe_bg['url'];
}

$footer_three_bg_img_url = '';
if(!empty($footer_three_bg_image['url'])){
    $footer_three_bg_img_url = $footer_three_bg_image['url'];
}

$footer_shortcode_class = '';
if(!empty($footer_shortcode)) {
    $footer_shortcode_class = 'footer-top-space';
};
?>

<?php if (payone()->is_payone_core_active()) : ?>    
<div class="footer-area footer-three footer-three-alternate pt-120 bg-cover footer-active-class <?php echo esc_attr($footer_shortcode_class); ?>" style="background-image: url('<?php echo esc_attr($footer_three_bg_img_url); ?>')"> 
<?php else : ?>     
<div class="footer-area footer-three footer-three-alternate bg-cover <?php echo esc_attr($footer_shortcode_class); ?>"> 
<?php endif; ?>
    <div class="container">
        <?php if($footer_three_subscribe_enable == true) : ?>
            <div class="row align-items-center gutter-24">
                <div class="col-12 col-lg-7 col-xxl-6">
                    <div class="footer__newsletter-content">
                        <?php if($footer_three_subscribe_title) : ?>
                            <h4 class="title-animation neutral-top fw-6 mb-5 pb-2"><?php echo esc_html($footer_three_subscribe_title); ?></h2>
                        <?php endif; ?>
                        <?php if($footer_three_subscribe_content) : ?>
                            <p class="p-0 m-0"><?php echo esc_html($footer_three_subscribe_content); ?></p>
                        <?php endif; ?>
                    </div>
                </div>
                <?php if(!empty($footer_three_subscribe_shortcode)) : ?>
                    <div class="col-12 col-lg-5 col-xxl-5 offset-xxl-1">
                        <?php echo do_shortcode($footer_three_subscribe_shortcode);?>
                    </div>
                <?php endif; ?>
            </div>
            <div class="row">
                <div class="col-12">
                    <hr class="divider">
                </div>
            </div>
        <?php endif; ?>
        <div class="footer-wraps position-relative z-1">
            <?php get_template_part('template-parts/content/footer-widget'); ?>
        </div>
        <div class="copyright-wrap pt-20 pb-20">
            <div class="row">
                <div class="col-lg-6 align-self-center">
                    <div class="copyright-content">
                        <div class="copyright-text text-white pt-3 pb-3">
                            <?php
                                echo wp_kses($copyright_one_text, payone()->kses_allowed_html(array('a')));
                            ?>
                        </div>
                    </div>
                </div>
                <?php if (has_nav_menu('footer-menu')) { ?>
                    <div class="col-lg-6 mt-lg-0 mt-2 text-lg-end align-self-center">
                        <?php wp_nav_menu(array(
                            'theme_location' => 'footer-menu',
                        )); ?>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
</div>