<?php
/**
 * Template part for displaying single post
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package payone
 */

$payone = payone();
$post_meta = get_post_meta(get_the_ID(), 'payone_post_gallery_options', true);
$post_meta_gallery = isset($post_meta['gallery_images']) && !empty($post_meta['gallery_images']) ? $post_meta['gallery_images'] : '';
$post_single_meta = Payone_Group_Fields_Value::post_meta('blog_single_post');
?>

<article id="post-<?php the_ID(); ?>" <?php post_class('blog-single-content-wrap'); ?>>
    <?php
    if (has_post_thumbnail() || !empty($post_meta_gallery)):
        $get_post_format = get_post_format();
        if ('video' == $get_post_format || 'gallery' == $get_post_format) {
            get_template_part('template-parts/content/thumbnail', $get_post_format);
        } else {
            get_template_part('template-parts/content/thumbnail');
        }
    endif;
    ?>
    <div class="p-0">
        <div class="entry-content">
            <?php if ('post' == get_post_type()): ?>
                <ul class="post-meta">
                    <?php if ($post_single_meta['posted_by']): ?>
                        <li class="text-neutral-500 text-lg">
                            <?php $payone->posted_by(); ?>
                            <span class="line-bar line-bar-2"></span>
                        </li>
                    <?php endif; ?>
                    <li class="text-neutral-500 text-lg">
                        <?php the_category(', ', '') ?>
                        <span class="line-bar line-bar-2"></span>
                    </li>
                    <li class="fw-500 text-lg">
                        <?php $payone->comment_count(); ?>
                    </li>
                </ul>
            <?php endif;
            the_content();
            $payone->link_pages();
            ?>
        </div>
        <?php if ('post' == get_post_type() && ((has_tag() && $post_single_meta['posted_tag']) || (shortcode_exists('payone_post_share') && $post_single_meta['posted_share']))): ?>
            <div class="blog-details-footer">
                <?php if (has_tag() && $post_single_meta['posted_tag']): ?>
                    <div class="left">
                        <h5 class="title"><?php echo esc_html__('Tags:', 'payone') ?></h5>
                        <?php $payone->posted_tag(); ?>
                    </div>
                <?php endif; ?>
                <?php if (shortcode_exists('payone_post_share') && $post_single_meta['posted_share']) : ?>
                    <div class="right">
                        <h5 class="title mb-2 cursor-big"><?php echo esc_html__('Social Share:', 'payone') ?></h5>
                        <?php
                        if (shortcode_exists('payone_post_share') && $post_single_meta['posted_share']) {
                            echo do_shortcode('[payone_post_share]');
                        }
                        ?>
                    </div>
                <?php endif; ?>
            </div>
        <?php endif;
        if ($post_single_meta['next_post_nav_btn'] && $payone->is_payone_core_active()) {
            echo wp_kses($payone->post_navigation(), $payone->kses_allowed_html('all'));
        }
        if ($payone->is_payone_core_active()) {
            if ($post_single_meta['get_related_post']) {
                $payone->get_related_post([
                    'post_type' => 'post',
                    'taxonomy' => 'category',
                    'exclude_id' => get_the_ID(),
                    'posts_per_page' => 2
                ]);
            }
        }
        ?>
    </div>

</article><!-- #post-<?php the_ID(); ?> -->
