<?php

/**
 * Theme Options
 * @package payone
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
    exit(); // exit if access directly
}
// Control core classes for avoid errors
if (class_exists('CSF')) {

    $allowed_html = payone()->kses_allowed_html(array('mark'));
    $prefix = 'payone';
    // Create options
    CSF::createOptions($prefix . '_theme_options', array(
        'menu_title' => esc_html__('Theme Options', 'payone'),
        'menu_slug' => 'payone_theme_options',
        'menu_parent' => 'payone_theme_options',
        'menu_type' => 'submenu',
        'footer_credit' => ' ',
        'menu_icon' => 'fa fa-filter',
        'show_footer' => false,
        'enqueue_webfont' => false,
        'show_search' => true,
        'show_reset_all' => true,
        'show_reset_section' => true,
        'show_all_options' => false,
        'theme' => 'dark',
        'framework_title' => payone()->get_theme_info('name')
    ));

    /*-------------------------------------------------------
        ** General  Options
    --------------------------------------------------------*/
    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('General', 'payone'),
        'id' => 'general_options',
        'icon' => 'fas fa-cogs',
    ));
    /* Preloader */
    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('Preloader & SVG Enable', 'payone'),
        'id' => 'theme_general_preloader_options',
        'icon' => 'fa fa-spinner',
        'parent' => 'general_options',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Preloader Options', 'payone') . '</h3>'
            ),
            array(
                'id' => 'preloader_enable',
                'title' => esc_html__('Preloader', 'payone'),
                'type' => 'switcher',
                'desc' => wp_kses(__('you can set <mark>Yes / No</mark> to enable/disable preloader', 'payone'), $allowed_html),
                'default' => false,
            ),
            array(
                'id' => 'preloader_img1',
                'type' => 'media',
                'title' => esc_html__('Preloader Image 1', 'payone'),
                'dependency' => array('preloader_enable', '==', 'true')
            ),
            array(
                'id' => 'preloader_img2',
                'type' => 'media',
                'title' => esc_html__('Preloader Image 2', 'payone'),
                'dependency' => array('preloader_enable', '==', 'true')
            ),
            array(
                'id' => 'preloader_bg_color',
                'title' => esc_html__('Background Color', 'payone'),
                'type' => 'color',
                'default' => '#ffffff',
                'desc' => wp_kses(__('you can set <mark>overlay color</mark> for preloader background image', 'payone'), $allowed_html),
                'dependency' => array('preloader_enable', '==', 'true')
            ),
            array(
                'id' => 'enable_svg_upload',
                'type' => 'switcher',
                'title' => esc_html__('Enable Svg Upload ?', 'payone'),
                'desc' => esc_html__('If you want to enable or disable svg upload you can set ( YES / NO )', 'payone'),
                'default' => false,
            ),
        )
    ));

    /*-------------------------------------------------------
           ** Typography  Options
    --------------------------------------------------------*/
    CSF::createSection($prefix . '_theme_options', array(
        'id' => 'typography',
        'title' => esc_html__('Typography', 'payone'),
        'icon' => 'fas fa-text-height',
        'parent' => 'general_options',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Body Font Options', 'payone') . '</h3>',
            ),
            array(
                'type' => 'typography',
                'title' => esc_html__('Typography', 'payone'),
                'id' => '_body_font',
                'default' => array(
                    'font-family' => 'Inter',
                    'font-size' => '16',
                    'line-height' => '26',
                    'unit' => 'px',
                    'type' => 'google',
                ),
                'color' => false,
                'subset' => false,
                'text_align' => false,
                'text_transform' => false,
                'letter_spacing' => false,
                'line_height' => false,
                'desc' => wp_kses(__('you can set <mark>font</mark> for all html tags (if not use different heading font)', 'payone'), $allowed_html),
            ),
            array(
                'id' => 'body_font_variant',
                'type' => 'select',
                'title' => esc_html__('Load Font Variant', 'payone'),
                'multiple' => true,
                'chosen' => true,
                'options' => array(
                    '300' => esc_html__('Light 300', 'payone'),
                    '400' => esc_html__('Regular 400', 'payone'),
                    '500' => esc_html__('Medium 500', 'payone'),
                    '600' => esc_html__('Semi Bold 600', 'payone'),
                    '700' => esc_html__('Bold 700', 'payone'),
                    '800' => esc_html__('Extra Bold 800', 'payone'),
                ),
                'default' => array('400', '500', '600', '700')
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Heading Font Options', 'payone') . '</h3>',
            ),
            array(
                'type' => 'switcher',
                'id' => 'heading_font_enable',
                'title' => esc_html__('Heading Font', 'payone'),
                'desc' => wp_kses(__('you can set <mark>yes</mark> to select different heading font', 'payone'), $allowed_html),
                'default' => true
            ),
            array(
                'type' => 'typography',
                'title' => esc_html__('Typography', 'payone'),
                'id' => 'heading_font',
                'default' => array(
                    'font-family' => 'Wendy One',
                    'type' => 'google',
                ),
                'color' => false,
                'subset' => false,
                'text_align' => false,
                'text_transform' => false,
                'letter_spacing' => false,
                'font_size' => false,
                'line_height' => false,
                'desc' => wp_kses(__('you can set <mark>font</mark> for  for heading tag .eg: h1,h2,h3,h4,h5,h6', 'payone'), $allowed_html),
                'dependency' => array('heading_font_enable', '==', 'true')
            ),
            array(
                'id' => 'heading_font_variant',
                'type' => 'select',
                'title' => esc_html__('Load Font Variant', 'payone'),
                'multiple' => true,
                'chosen' => true,
                'options' => array(
                    '300' => esc_html__('Light 300', 'payone'),
                    '400' => esc_html__('Regular 400', 'payone'),
                    '500' => esc_html__('Medium 500', 'payone'),
                    '600' => esc_html__('Semi Bold 600', 'payone'),
                    '700' => esc_html__('Bold 700', 'payone'),
                    '800' => esc_html__('Extra Bold 800', 'payone'),
                ),
                'default' => array('400', '500', '600', '700'),
                'dependency' => array('heading_font_enable', '==', 'true')
            ),
        )
    ));

    /* Preloader */
    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('Back To Top', 'payone'),
        'id' => 'theme_general_back_top_options',
        'icon' => 'fa fa-arrow-up',
        'parent' => 'general_options',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Back Top Options', 'payone') . '</h3>'
            ),
            array(
                'id' => 'back_top_enable',
                'title' => esc_html__('Back Top', 'payone'),
                'type' => 'switcher',
                'desc' => wp_kses(__('you can set <mark>Yes / No</mark> to show/hide back to top', 'payone'), $allowed_html),
                'default' => true,
            ),
            array(
                'id' => 'back_top_icon',
                'title' => esc_html__('Back Top Icon', 'payone'),
                'type' => 'icon',
                'default' => 'fa fa-angle-up',
                'desc' => wp_kses(__('you can set <mark>icon</mark> for back to top.', 'payone'), $allowed_html),
                'dependency' => array('back_top_enable', '==', 'true')
            ),
        )
    ));

    /* Preloader */
    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('sitebar', 'payone'),
        'id' => 'theme_general_sitebar_options',
        'icon' => 'fa fa-arrow-up',
        'parent' => 'general_options',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Sitebar Option', 'payone') . '</h3>'
            ),
            array(
                'id' => 'sitebar_logo',
                'type' => 'media',
                'title' => esc_html__('Sitebar Logo', 'payone'),
                'library' => 'image',
                'desc' => wp_kses(__('you can upload <mark> logo</mark> here it will overwrite customizer uploaded logo', 'payone'), $allowed_html),
            ),
            array(
                'id' => 'sitebar_address',
                'type' => 'text',
                'title' => esc_html__('Sitebar Address', 'payone'),
                'default' => esc_html__('Lavaca Street, Suite 2000', 'payone'),
            ),
            array(
                'id' => 'sitebar_phone',
                'type' => 'text',
                'title' => esc_html__('Sitebar phone', 'payone'),
                'default' => esc_html__('(+880) 172570051', 'payone'),
            ),
            array(
                'id' => 'sitebar_phone_2',
                'type' => 'text',
                'title' => esc_html__('Sitebar phone 2', 'payone'),
                'default' => esc_html__('(+880) 172570051', 'payone'),
            ),
            array(
                'id' => 'sitebar_email',
                'type' => 'text',
                'title' => esc_html__('Sitebar email', 'payone'),
                'default' => esc_html__('email@evha.com', 'payone'),
            ),
            array(
                'id' => 'sitebar_email_2',
                'type' => 'text',
                'title' => esc_html__('Sitebar email 2', 'payone'),
                'default' => esc_html__('email@evha.com', 'payone'),
            ),
            array(
                'id' => 'gmap_address',
                'type' => 'text',
                'title' => esc_html__('iframe google map Address', 'payone'),
            ),
            array(
                'id' => 'sitebar_facebook',
                'type' => 'text',
                'title' => esc_html__('Sitebar facebook url', 'payone'),
                'default' => esc_html__('#', 'payone'),
            ),
            array(
                'id' => 'sitebar_twitter',
                'type' => 'text',
                'title' => esc_html__('Sitebar twitter url', 'payone'),
                'default' => esc_html__('#', 'payone'),
            ),
            array(
                'id' => 'sitebar_instagram',
                'type' => 'text',
                'title' => esc_html__('Sitebar instagram', 'payone'),
                'default' => esc_html__('#', 'payone'),
            ),
            array(
                'id' => 'sitebar_linkedin',
                'type' => 'text',
                'title' => esc_html__('Sitebar linkedin', 'payone'),
                'default' => esc_html__('#', 'payone'),
            ),
            array(
                'id' => 'map_enable',
                'title' => esc_html__('map Enable', 'payone'),
                'type' => 'switcher',
                'desc' => wp_kses(__('you can set <mark>Yes / No</mark> to enable/disable preloader', 'payone'), $allowed_html),
                'default' => true,
            ),
        )
    ));

    /*----------------------------------
        Header & Footer Style
    -----------------------------------*/
    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('Set Header & Footer Type', 'payone'),
        'id' => 'header_footer_style_options',
        'icon' => 'eicon-banner',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => esc_html__('Global Header Style', 'payone'),
            ),
            array(
                'id' => 'navbar_type',
                'title' => esc_html__('Navbar Type', 'payone'),
                'type' => 'image_select',
                'options' => array(
                    '' => PAYONE_THEME_SETTINGS_IMAGES . '/header/01.png'
                ),
                'default' => '',
                'desc' => wp_kses(__('you can set <mark>navbar type</mark> it will show in every page except you select specific navbar type form page settings.', 'payone'), $allowed_html),
            ),
            array(
                'type' => 'subheading',
                'content' => esc_html__('Global Footer Style', 'payone'),
            ),
            array(
                'id' => 'footer_type',
                'title' => esc_html__('Footer Type', 'payone'),
                'type' => 'image_select',
                'options' => array(
                    '' => PAYONE_THEME_SETTINGS_IMAGES . '/footer/01.png'
                ),
                'default' => '',
                'desc' => wp_kses(__('you can set <mark>footer type</mark> it will show in every page except you select specific navbar type form page settings.', 'payone'), $allowed_html),
            ),
        )
    ));

    /* Breadcrumb */
    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('Breadcrumb', 'payone'),
        'id' => 'breadcrumb_options',
        'icon' => ' eicon-product-breadcrumbs',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Breadcrumb Options', 'payone') . '</h3>'
            ),
            array(
                'id' => 'breadcrumb_enable',
                'title' => esc_html__('Breadcrumb', 'payone'),
                'type' => 'switcher',
                'desc' => wp_kses(__('you can set <mark>Yes / No</mark> to show/hide breadcrumb', 'payone'), $allowed_html),
                'default' => true,
            ),
            array(
                'id' => 'breadcrumb_bg',
                'title' => esc_html__('Background Image', 'payone'),
                'type' => 'background',
                'desc' => wp_kses(__('you can set <mark>background</mark> for breadcrumb', 'payone'), $allowed_html),
                'default' => array(
                    'background-size' => '',
                    'background-position' => 'center bottom',
                    'background-repeat' => 'no-repeat',
                ),
                'background_color' => false,
                'dependency' => array('breadcrumb_enable', '==', 'true')
            ),
            array(
                'id' => 'breadcrumb_bg_color',
                'title' => esc_html__('Breadcrumb Background Color', 'payone'),
                'type' => 'color',
                'default' => 'rgba(232,0,0, 0.6);',
                'desc' => wp_kses(__('you can set <mark>overlay color</mark> for Breadcrumb background image', 'payone'), $allowed_html),
                'dependency' => array('breadcrumb_enable', '==', 'true')
            ),
        )
    ));


    /*-------------------------------------------------------
       ** Entire Site Header  Options
   --------------------------------------------------------*/
    CSF::createSection($prefix . '_theme_options', array(
        'id' => 'headers_settings',
        'title' => esc_html__('Headers', 'payone'),
        'icon' => 'fa fa-home'
    ));

    /* Header Style 01 */
    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('Header One', 'payone'),
        'id' => 'theme_header_one_options',
        'icon' => 'fa fa-image',
        'parent' => 'headers_settings',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Header Options', 'payone') . '</h3>'
            ),
            array(
                'id' => 'header_one_logo',
                'type' => 'media',
                'title' => esc_html__('Logo', 'payone'),
                'library' => 'image',
                'desc' => wp_kses(__('you can upload <mark> logo</mark> here it will overwrite customizer uploaded logo', 'payone'), $allowed_html),
            ),
        )
    ));

    /* Header Style 02 */
    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('Header Two', 'payone'),
        'id' => 'theme_header_two_options',
        'icon' => 'fa fa-image',
        'parent' => 'headers_settings',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Navbar Options', 'payone') . '</h3>'
            ),
            array(
                'id' => 'header_two_logo',
                'type' => 'media',
                'title' => esc_html__('Logo', 'payone'),
                'library' => 'image',
                'desc' => wp_kses(__('you can upload <mark> logo</mark> here it will overwrite customizer uploaded logo', 'payone'), $allowed_html),
            ),
            array(
                'id' => 'category_enable',
                'title' => esc_html__('Category Enable', 'payone'),
                'type' => 'switcher',
                'desc' => wp_kses(__('you can set <mark>Yes / No</mark> to enable/disable Category', 'payone'), $allowed_html),
                'default' => true,
            ),
            array(
                'id' => 'search_enable',
                'title' => esc_html__('search Enable', 'payone'),
                'type' => 'switcher',
                'desc' => wp_kses(__('you can set <mark>Yes / No</mark> to enable/disable search', 'payone'), $allowed_html),
                'default' => true,
            ),
            array(
                'id' => 'login_btn_enable',
                'title' => esc_html__('login btn Enable', 'payone'),
                'type' => 'switcher',
                'desc' => wp_kses(__('you can set <mark>Yes / No</mark> to enable/disable login btn', 'payone'), $allowed_html),
                'default' => true,
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Navbar Mobile Options', 'payone') . '</h3>'
            ),
            array(
                'id' => 'header_two_social_repeater',
                'type' => 'repeater',
                'title' => esc_html__('Social Repeater', 'payone'),
                'fields' => array(
                    array(
                        'id' => 'header_two_social_icon',
                        'type' => 'icon',
                        'title' => esc_html__('Icon', 'payone'),
                    ),
                    array(
                        'id' => 'header_two_social_url',
                        'type' => 'text',
                        'title' => esc_html__('Info URL', 'payone'),
                        'default' => '#'
                    ),
                )
            ),
        )
    ));

    /*-------------------------------------------------------
           ** Footer  Options
    --------------------------------------------------------*/
    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('Footer', 'payone'),
        'id' => 'footer_options',
        'icon' => ' eicon-footer',
    ));
    CSF::createSection($prefix . '_theme_options', array(
        'parent' => 'footer_options',
        'id' => 'footer_general_options',
        'title' => esc_html__('Footer One', 'payone'),
        'icon' => 'fa fa-list-ul',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Subscribe settings', 'payone') . '</h3>'
            ),
            array(
                'id' => 'footer_one_subscribe_enable',
                'title' => esc_html__('subscribe Enable', 'payone'),
                'type' => 'switcher',
                'desc' => wp_kses(__('you can set <mark>Yes / No</mark> to enable/disable Category', 'payone'), $allowed_html),
                'default' => false,
            ),
            array(
                'id' => 'footer_one_subscribe_bg',
                'type' => 'media',
                'title' => esc_html__('Subscribe Bg', 'payone'),
                'library' => 'image',
                'desc' => wp_kses(__('you can upload <mark> background image</mark> here it will overwrite customizer uploaded logo', 'payone'), $allowed_html),
            ),
            array(
                'id' => 'footer_one_subscribe_title',
                'type' => 'text',
                'title' => esc_html__('Subscribe Title', 'payone'),
                'default' => esc_html__('Join Our Newsletter', 'payone'),
            ),
            array(
                'id' => 'footer_one_subscribe_content',
                'type' => 'text',
                'title' => esc_html__('Subscribe Content', 'payone'),
                'default' => esc_html__('Subscribe to our newsletter for the latest updates, news, and exclusive insights straight to your inbox.', 'payone'),
            ),
            array(
                'id' => 'footer_one_subscribe_shortcode',
                'title' => esc_html__('footer subscribe', 'payone'),
                'type' => 'textarea',
                'desc' => wp_kses(__('use  <mark>{copy}</mark> for footer subscribe ', 'payone'), $allowed_html)
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Footer Area Options', 'payone') . '</h3>'
            ),
            array(
                'id' => 'footer_one_bg_image',
                'type' => 'media',
                'title' => esc_html__('Footer Background Image', 'payone'),
                'library' => 'image',
                'desc' => wp_kses(__('you can upload <mark> background image</mark> here it will overwrite customizer uploaded logo', 'payone'), $allowed_html),
            ),
            array(
                'id' => 'copyright_one_text',
                'title' => esc_html__('Copyright Area Text', 'payone'),
                'type' => 'textarea',
                'desc' => wp_kses(__('use  <mark>{copy}</mark> for copyright symbol, use <mark>{year}</mark> for current year, ', 'payone'), $allowed_html)
            )
        )
    ));

    CSF::createSection($prefix . '_theme_options', array(
        'parent' => 'footer_options',
        'id' => 'footer_two_options',
        'title' => esc_html__('Footer Two', 'payone'),
        'icon' => 'fa fa-list-ul',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Subscribe settings', 'payone') . '</h3>'
            ),
            array(
                'id' => 'footer_two_subscribe_enable',
                'title' => esc_html__('subscribe Enable', 'payone'),
                'type' => 'switcher',
                'desc' => wp_kses(__('you can set <mark>Yes / No</mark> to enable/disable Category', 'payone'), $allowed_html),
                'default' => false,
            ),
            array(
                'id' => 'footer_two_subscribe_bg',
                'type' => 'media',
                'title' => esc_html__('Subscribe Bg', 'payone'),
                'library' => 'image',
                'desc' => wp_kses(__('you can upload <mark> background image</mark> here it will overwrite customizer uploaded logo', 'payone'), $allowed_html),
            ),
            array(
                'id' => 'footer_two_subscribe_title',
                'type' => 'text',
                'title' => esc_html__('Subscribe Title', 'payone'),
                'default' => esc_html__('Join Our Newsletter', 'payone'),
            ),
            array(
                'id' => 'footer_two_subscribe_content',
                'type' => 'text',
                'title' => esc_html__('Subscribe Content', 'payone'),
                'default' => esc_html__('Subscribe to our newsletter for the latest updates, news, and exclusive insights straight to your inbox.', 'payone'),
            ),
            array(
                'id' => 'footer_two_subscribe_shortcode',
                'title' => esc_html__('footer subscribe', 'payone'),
                'type' => 'textarea',
                'desc' => wp_kses(__('use  <mark>{copy}</mark> for footer subscribe ', 'payone'), $allowed_html)
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Footer Area Options', 'payone') . '</h3>'
            ),
            array(
                'id' => 'footer_two_bg_image',
                'type' => 'media',
                'title' => esc_html__('Footer Background Image', 'payone'),
                'library' => 'image',
                'desc' => wp_kses(__('you can upload <mark> background image</mark> here it will overwrite customizer uploaded logo', 'payone'), $allowed_html),
            ),
            array(
                'id' => 'copyright_two_text',
                'title' => esc_html__('Copyright Area Text', 'payone'),
                'type' => 'textarea',
                'desc' => wp_kses(__('use  <mark>{copy}</mark> for copyright symbol, use <mark>{year}</mark> for current year, ', 'payone'), $allowed_html)
            )
        )
    ));

    CSF::createSection($prefix . '_theme_options', array(
        'parent' => 'footer_options',
        'id' => 'footer_three_options',
        'title' => esc_html__('Footer Three', 'payone'),
        'icon' => 'fa fa-list-ul',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Subscribe settings', 'payone') . '</h3>'
            ),
            array(
                'id' => 'footer_three_subscribe_enable',
                'title' => esc_html__('subscribe Enable', 'payone'),
                'type' => 'switcher',
                'desc' => wp_kses(__('you can set <mark>Yes / No</mark> to enable/disable Category', 'payone'), $allowed_html),
                'default' => false,
            ),
            array(
                'id' => 'footer_three_subscribe_bg',
                'type' => 'media',
                'title' => esc_html__('Subscribe Bg', 'payone'),
                'library' => 'image',
                'desc' => wp_kses(__('you can upload <mark> background image</mark> here it will overwrite customizer uploaded logo', 'payone'), $allowed_html),
            ),
            array(
                'id' => 'footer_three_subscribe_title',
                'type' => 'text',
                'title' => esc_html__('Subscribe Title', 'payone'),
                'default' => esc_html__('Join Our Newsletter', 'payone'),
            ),
            array(
                'id' => 'footer_three_subscribe_content',
                'type' => 'text',
                'title' => esc_html__('Subscribe Content', 'payone'),
                'default' => esc_html__('Subscribe to our newsletter for the latest updates, news, and exclusive insights straight to your inbox.', 'payone'),
            ),
            array(
                'id' => 'footer_three_subscribe_shortcode',
                'title' => esc_html__('footer subscribe', 'payone'),
                'type' => 'textarea',
                'desc' => wp_kses(__('use  <mark>{copy}</mark> for footer subscribe ', 'payone'), $allowed_html)
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Footer Area Options', 'payone') . '</h3>'
            ),
            array(
                'id' => 'footer_three_bg_image',
                'type' => 'media',
                'title' => esc_html__('Footer Background Image', 'payone'),
                'library' => 'image',
                'desc' => wp_kses(__('you can upload <mark> background image</mark> here it will overwrite customizer uploaded logo', 'payone'), $allowed_html),
            ),
            array(
                'id' => 'copyright_three_text',
                'title' => esc_html__('Copyright Area Text', 'payone'),
                'type' => 'textarea',
                'desc' => wp_kses(__('use  <mark>{copy}</mark> for copyright symbol, use <mark>{year}</mark> for current year, ', 'payone'), $allowed_html)
            )
        )
    ));

    /*-------------------------------------------------------
          ** Blog  Options
    --------------------------------------------------------*/
    CSF::createSection($prefix . '_theme_options', array(
        'id' => 'blog_settings',
        'title' => esc_html__('Blog Settings', 'payone'),
        'icon' => 'fa fa-book'
    ));
    CSF::createSection($prefix . '_theme_options', array(
        'parent' => 'blog_settings',
        'id' => 'blog_post_options',
        'title' => esc_html__('Blog Post', 'payone'),
        'icon' => 'fa fa-list-ul',
        'fields' => Payone_Group_Fields::post_meta('blog_post', esc_html__('Blog Page', 'payone'))
    ));
    CSF::createSection($prefix . '_theme_options', array(
        'parent' => 'blog_settings',
        'id' => 'blog_single_post_options',
        'title' => esc_html__('Single Post', 'payone'),
        'icon' => 'fa fa-list-alt',
        'fields' => Payone_Group_Fields::post_meta('blog_single_post', esc_html__('Blog Single Page', 'payone'))
    ));

    CSF::createSection($prefix . '_theme_options', array(
        'id' => 'shop_settings',
        'title' => esc_html__('Shop Settings', 'payone'),
        'icon' => 'fas fa-shopping-basket',
    ));
    /*  Product page options */
    CSF::createSection($prefix . '_theme_options', array(
        'id' => 'product_shop_page',
        'title' => esc_html__('Product Page', 'payone'),
        'parent' => 'shop_settings',
        'icon' => 'fas fa-shopping-basket',
        'fields' => Payone_Group_Fields::page_layout_options(esc_html__('Product Shop Page', 'payone'), 'product_shop')
    ));
    /*  Product single page options */
    CSF::createSection($prefix . '_theme_options', array(
        'id' => 'product_shop_single_page',
        'title' => esc_html__('Product Single Page', 'payone'),
        'parent' => 'shop_settings',
        'icon' => 'fas fa-shopping-basket',
        'fields' => array(
            array(
                'id' => 'product_shop_single_page_bg_color',
                'type' => 'color',
                'title' => esc_html__('Page Background Color', 'payone'),
                'default' => ''
            ),
            array(
                'id' => 'product_shop_single_page_spacing_top',
                'title' => esc_html__('Page Spacing Top', 'payone'),
                'type' => 'slider',
                'desc' => wp_kses(__('you can set <mark>Padding Top</mark> for page content area.', 'payone'), $allowed_html),
                'min' => 0,
                'max' => 500,
                'step' => 1,
                'unit' => 'px',
                'default' => 120,
            ),
            array(
                'id' => 'product_shop_single_page_spacing_bottom',
                'title' => esc_html__('Page Spacing Bottom', 'payone'),
                'type' => 'slider',
                'desc' => wp_kses(__('you can set <mark>Padding Bottom</mark> for page content area.', 'payone'), $allowed_html),
                'min' => 0,
                'max' => 500,
                'step' => 1,
                'unit' => 'px',
                'default' => 100,
            ),
        ),
    ));

    /*-------------------------------------------------------
          ** Pages & templates Options
   --------------------------------------------------------*/
    CSF::createSection($prefix . '_theme_options', array(
        'id' => 'pages_and_template',
        'title' => esc_html__('Pages Settings', 'payone'),
        'icon' => 'fa fa-files-o'
    ));
    /*  404 page options */
    CSF::createSection($prefix . '_theme_options', array(
        'id' => '404_page',
        'title' => esc_html__('404 Page', 'payone'),
        'parent' => 'pages_and_template',
        'icon' => 'fa fa-exclamation-triangle',
        'fields' => array(
            array(
                'id' => 'error_bg_switch',
                'title' => esc_html__('404 Image Enable', 'payone'),
                'type' => 'switcher',
                'desc' => wp_kses(__('you can set <mark>Yes / No</mark> to show/hide breadcrumb', 'payone'), $allowed_html),
                'default' => true,
            ),
            array(
                'id' => 'error_bg',
                'title' => esc_html__('404 Image', 'payone'),
                'type' => 'media',
                'desc' => wp_kses(__('you can set <mark>background</mark> for breadcrumb', 'payone'), $allowed_html),
                'dependency' => array('error_bg_switch', '==', 'true')
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('404 Page Options', 'payone') . '</h3>',
            ),
            array(
                'id' => '404_bg_color',
                'type' => 'color',
                'title' => esc_html__('Page Background Color', 'payone'),
                'default' => ''
            ),
            array(
                'id' => '404_title',
                'title' => esc_html__('Title', 'payone'),
                'type' => 'text',
                'info' => wp_kses(__('you can change <mark>title</mark> of 404 page', 'payone'), $allowed_html),
                'attributes' => array('placeholder' => esc_html__('Sorry! The Page Not Found', 'payone'))
            ),
            array(
                'id' => '404_paragraph',
                'title' => esc_html__('Paragraph', 'payone'),
                'type' => 'textarea',
                'info' => wp_kses(__('you can change <mark>paragraph</mark> of 404 page', 'payone'), $allowed_html),
                'attributes' => array('placeholder' => esc_html__('Oops! The page you are looking for does not exit. it might been moved or deleted.', 'payone'))
            ),
            array(
                'id' => '404_button_text',
                'title' => esc_html__('Button Text', 'payone'),
                'type' => 'text',
                'info' => wp_kses(__('you can change <mark>button text</mark> of 404 page', 'payone'), $allowed_html),
                'attributes' => array('placeholder' => esc_html__('back to home', 'payone'))
            ),
            array(
                'id' => '404_spacing_top',
                'title' => esc_html__('Page Spacing Top', 'payone'),
                'type' => 'slider',
                'desc' => wp_kses(__('you can set <mark>Padding Top</mark> for page content area.', 'payone'), $allowed_html),
                'min' => 0,
                'max' => 500,
                'step' => 1,
                'unit' => 'px',
                'default' => 120,
            ),
            array(
                'id' => '404_spacing_bottom',
                'title' => esc_html__('Page Spacing Bottom', 'payone'),
                'type' => 'slider',
                'desc' => wp_kses(__('you can set <mark>Padding Bottom</mark> for page content area.', 'payone'), $allowed_html),
                'min' => 0,
                'max' => 500,
                'step' => 1,
                'unit' => 'px',
                'default' => 120,
            ),
        )
    ));

    /*  blog page options */
    CSF::createSection($prefix . '_theme_options', array(
        'id' => 'blog_page',
        'title' => esc_html__('Blog Page', 'payone'),
        'parent' => 'pages_and_template',
        'icon' => 'fa fa-indent',
        'fields' => Payone_Group_Fields::page_layout_options(esc_html__('Blog', 'payone'), 'blog')
    ));
    /*  blog single page options */
    CSF::createSection($prefix . '_theme_options', array(
        'id' => 'blog_single_page',
        'title' => esc_html__('Blog Single Page', 'payone'),
        'parent' => 'pages_and_template',
        'icon' => 'fa fa-indent',
        'fields' => Payone_Group_Fields::page_layout_options(esc_html__('Blog Single', 'payone'), 'blog_single')
    ));
    /*  archive page options */
    CSF::createSection($prefix . '_theme_options', array(
        'id' => 'archive_page',
        'title' => esc_html__('Archive Page', 'payone'),
        'parent' => 'pages_and_template',
        'icon' => 'fa fa-archive',
        'fields' => Payone_Group_Fields::page_layout_options(esc_html__('Archive', 'payone'), 'archive')
    ));
    /*  search page options */
    CSF::createSection($prefix . '_theme_options', array(
        'id' => 'search_page',
        'title' => esc_html__('Search Page', 'payone'),
        'parent' => 'pages_and_template',
        'icon' => 'fa fa-search',
        'fields' => Payone_Group_Fields::page_layout_options(esc_html__('Search', 'payone'), 'search')
    ));

    /*-------------------------------------------------------
           ** Backup  Options
    --------------------------------------------------------*/
    CSF::createSection($prefix . '_theme_options', array(
        'id' => 'backup',
        'title' => esc_html__('Import / Export', 'payone'),
        'icon' => 'eicon-export-kit',
        'fields' => array(
            array(
                'type' => 'notice',
                'style' => 'warning',
                'content' => esc_html__('You can save your current options. Download a Backup and Import.', 'payone'),
            ),
            array(
                'type' => 'backup',
                'title' => esc_html__('Backup & Import', 'payone')
            )
        )
    ));
}
