<?php
/**
 * Theme Metabox Options
 * @package payone
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
    exit(); // exit if access directly
}

if (class_exists('CSF')) {

    $allowed_html = payone()->kses_allowed_html(array('mark'));

    $prefix = 'payone';

    /*-------------------------------------
        Post Format Options
    -------------------------------------*/
    CSF::createMetabox($prefix . '_post_video_options', array(
        'title' => esc_html__('Video Post Format Options', 'payone'),
        'post_type' => 'post',
        'post_formats' => 'video'
    ));
    CSF::createSection($prefix . '_post_video_options', array(
        'fields' => array(
            array(
                'id' => 'video_url',
                'type' => 'text',
                'title' => esc_html__('Enter Video URL', 'payone'),
                'desc' => wp_kses(__('enter <mark>video url</mark> to show in frontend', 'payone'), $allowed_html)
            )
        )
    ));
    CSF::createMetabox($prefix . '_post_gallery_options', array(
        'title' => esc_html__('Gallery Post Format Options', 'payone'),
        'post_type' => 'post',
        'post_formats' => 'gallery'
    ));
    CSF::createSection($prefix . '_post_gallery_options', array(
        'fields' => array(
            array(
                'id' => 'gallery_images',
                'type' => 'gallery',
                'title' => esc_html__('Select Gallery Photos', 'payone'),
                'desc' => wp_kses(__('select <mark>gallery photos</mark> to show in frontend', 'payone'), $allowed_html)
            )
        )
    ));

    /*-------------------------------------
      Page Container Options
    -------------------------------------*/
    CSF::createMetabox($prefix . '_page_container_options', array(
        'title' => esc_html__('Page Options', 'payone'),
        'post_type' => array('page'),
    ));
    CSF::createSection($prefix . '_page_container_options', array(
        'title' => esc_html__('Layout & Colors', 'payone'),
        'icon' => 'fa fa-columns',
        'fields' => Payone_Group_Fields::page_layout()
    ));
    CSF::createSection($prefix . '_page_container_options', array(
        'title' => esc_html__('Header Footer & Breadcrumb', 'payone'),
        'icon' => 'fa fa-header',
        'fields' => Payone_Group_Fields::Page_Container_Options('header_options')
    ));
    CSF::createSection($prefix . '_page_container_options', array(
        'title' => esc_html__('Width & Padding', 'payone'),
        'icon' => 'fa fa-file-o',
        'fields' => Payone_Group_Fields::Page_Container_Options('container_options')
    ));

    
    //	Service Meta Box
    CSF::createMetabox($prefix . '_service_options', array(
        'title' => esc_html__('Service Options', 'payone'),
        'post_type' => 'service',
    ));
    CSF::createSection($prefix . '_service_options', array(
        'fields' => array(
            array(
                'id' => 'service_icon',
                'type' => 'media',
                'title' => esc_html__('Icon', 'payone'),
                'desc' => wp_kses(__('Select Your Icon', 'payone'), $allowed_html)
            ),
            array(
                'id' => 'service_subtitle',
                'type' => 'text',
                'title' => esc_html__('service subtitle', 'payone'),
                'desc' => wp_kses(__('Type Your service subtitle', 'payone'), $allowed_html)
            ),
            array(
                'id' => 'service_content',
                'type' => 'textarea',
                'title' => esc_html__('service content', 'payone'),
                'desc' => wp_kses(__('Select Your service content', 'payone'), $allowed_html)
            ),
        )
    ));

    /*-------------------------------------
     Team Options
    -------------------------------------*/
    CSF::createMetabox($prefix . '_team_options', array(
        'title' => esc_html__('Team Options', 'payone'),
        'post_type' => array('team'),
        'priority' => 'high'
    ));
    CSF::createSection($prefix . '_team_options', array(
        'title' => esc_html__('Team Icon', 'payone'),
        'id' => 'payone-team-icon',
        'fields' => array(
            array(
                'id' => 'team_icon',
                'type' => 'media',
                'title' => esc_html__('Icon', 'payone'),
                'desc' => wp_kses(__('Select Your Icon', 'payone'), $allowed_html)
            )
        )
    ));
    
    CSF::createSection($prefix . '_team_options', array(
        'title' => esc_html__('Team Info', 'payone'),
        'id' => 'payone-info',
        'fields' => array(
            array(
                'id' => 'designation',
                'type' => 'text',
                'title' => esc_html__('Designation', 'payone'),
            ),
            array(
                'id' => 'description',
                'type' => 'textarea',
                'title' => esc_html__('Description', 'payone'),
                'default' => esc_html__('This category focuses on the design and construction of buildings and the This  category focuses on the design and construction of buildings and  arrangement of furniture and decorative elements within themarrangement', 'payone'),
            ),
            array(
                'id' => 'description_2',
                'type' => 'textarea',
                'title' => esc_html__('Description Two', 'payone'),
                'default' => esc_html__('This category focuses on the design and construction of buildings and the This  category focuses on the design and construction of buildings', 'payone'),
            ),
            array(
                'id' => 'team-info',
                'type' => 'repeater',
                'title' => esc_html__('Team Info', 'payone'),
                'fields' => array(

                    array(
                        'id' => 'title',
                        'type' => 'text',
                        'title' => esc_html__('Title', 'payone')
                    ),
                    array(
                        'id' => 'value',
                        'type' => 'text',
                        'title' => esc_html__('Value', 'payone')
                    ),

                ),
            ),
        )
    ));
    CSF::createSection($prefix . '_team_options', array(
        'title' => esc_html__('Social Info', 'payone'),
        'id' => 'social-info',
        'fields' => array(
            array(
                'id' => 'social-icons',
                'type' => 'repeater',
                'title' => esc_html__('Social Info', 'payone'),
                'fields' => array(

                    array(
                        'id' => 'title',
                        'type' => 'text',
                        'title' => esc_html__('Title', 'payone')
                    ),
                    array(
                        'id' => 'icon',
                        'type' => 'icon',
                        'title' => esc_html__('Icon', 'payone')
                    ),
                    array(
                        'id' => 'url',
                        'type' => 'text',
                        'title' => esc_html__('URL', 'payone')
                    ),

                ),
            ),
        )
    ));

    //	Project Meta Box
    CSF::createMetabox($prefix . '_project_options', array(
        'title' => esc_html__('Project Options', 'payone'),
        'post_type' => 'project',
    ));

    CSF::createSection($prefix . '_project_options', array(
        'fields' => array(
            array(
                'id' => 'project_subtitle',
                'type' => 'text',
                'title' => esc_html__('Project Subtitle', 'payone'),
                'default' => esc_html__('Development Coaches', 'payone'),
            ),
            array(
                'id' => 'project_icon',
                'type' => 'media',
                'title' => esc_html__('Icon', 'payone'),
                'desc' => wp_kses(__('Select Your Icon', 'payone'), $allowed_html)
            ),
        )
    ));

    //	Event Meta Box
    CSF::createMetabox($prefix . '_event_options', array(
        'title' => esc_html__('Event Options', 'payone'),
        'post_type' => 'event',
    ));
    CSF::createSection($prefix . '_event_options', array(
        'fields' => array(
            array(
                'id' => 'event_icon',
                'default' => 'flaticon-protection',
                'type' => 'icon',
                'title' => esc_html__('Icon', 'payone'),
                'desc' => wp_kses(__('Select Your Icon', 'payone'), $allowed_html)
            ),
            array(
                'id' => 'event_date_option',
                'type' => 'text',
                'title' => esc_html__('Event Date', 'payone'),
                'default' => esc_html__('21', 'payone'),
            ),
            array(
                'id' => 'event_month_option',
                'type' => 'text',
                'title' => esc_html__('Event Month', 'payone'),
                'default' => esc_html__('Feb', 'payone'),
            ),
            array(
                'id' => 'event_year_option',
                'type' => 'text',
                'title' => esc_html__('Event Year', 'payone'),
                'default' => esc_html__('2025', 'payone'),
            ),
            array(
                'id' => 'event_time_option',
                'type' => 'text',
                'title' => esc_html__('Event Time', 'payone'),
                'default' => esc_html__('10:00am', 'payone'),
            ),
            array(
                'id' => 'event_location_option',
                'type' => 'text',
                'title' => esc_html__('Event Location', 'payone'),
                'default' => esc_html__('684 Ann St. FL 34608', 'payone'),
            )
        )
    ));

    //	Courses Meta Box
    CSF::createMetabox($prefix . '_courses_options', array(
        'title' => esc_html__('Courses Options', 'payone'),
        'post_type' => 'courses',
    ));

    CSF::createSection($prefix . '_courses_options', array(
        'title' => esc_html__('Social Info', 'payone'),
        'id' => 'social-info',
        'fields' => array(
            array(
                'id' => 'course_start_date_option',
                'type' => 'text',
                'title' => esc_html__('Start From', 'payone'),
                'default' => esc_html__('Thursday, Nov 4, 2025', 'payone'),
            ),
            array(
                'id' => 'study-option',
                'type' => 'repeater',
                'title' => esc_html__('Study Options', 'payone'),
                'fields' => array(

                    array(
                        'id' => 'qualification',
                        'type' => 'text',
                        'title' => esc_html__('Qualification', 'payone'),
                        'default' => esc_html__('Bachelor of Aviation (Hons)', 'payone'),
                    ),
                    array(
                        'id' => 'length',
                        'type' => 'text',
                        'title' => esc_html__('Length', 'payone'),
                        'default' => esc_html__('9 months full time', 'payone'),
                    ),
                    array(
                        'id' => 'code',
                        'type' => 'text',
                        'title' => esc_html__('Code', 'payone'),
                        'default' => esc_html__('ba1x', 'payone'),
                    ),
                ),
            ),
            array(
                'id' => 'course_module_option',
                'type' => 'text',
                'title' => esc_html__('Course Module Title', 'payone'),
                'default' => esc_html__('Download full course Module', 'payone'),
            ),
            array(
                'id' => 'course_module_button_title',
                'type' => 'text',
                'title' => esc_html__('Course Module Button Title', 'payone'),
                'default' => esc_html__('Download', 'payone'),
            ),
            array(
                'id' => 'course_module_button_url',
                'type' => 'text',
                'title' => esc_html__('Course Module Button URL', 'payone'),
                'default' => esc_html__('#', 'payone'),
            ),
        )
    ));
}//endif