<?php
/**
 * Theme functions & definitations
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package payone
 */
 
/**
 * Define Theme Folder Path & URL Constant
 * @package payone
 * @since 1.0.0
 */
 

 
 // Simple submenu fix for arrow clicks
function fix_submenu_arrow_clicks() {
    ?>
    <script>
    jQuery(document).ready(function($) {
        $('.has-submenu > a').click(function(e) {
            var link = $(this);
            var clickX = e.pageX - link.offset().left;
            var linkWidth = link.width();
            
            // If click is in the last 30px (arrow area), stop navigation
            if (clickX > linkWidth - 30) {
                e.preventDefault();
                link.parent('.has-submenu').toggleClass('submenu-open');
            }
        });
        
        // Close when clicking outside
        $(document).click(function(e) {
            if (!$(e.target).closest('.has-submenu').length) {
                $('.has-submenu').removeClass('submenu-open');
            }
        });
    });
    </script>
    
    <style>.has-submenu.submenu-open .sub-menu{display:block!important}</style>
    <?php
}
add_action('wp_footer', 'fix_submenu_arrow_clicks');

function enqueue_mobile_menu_scripts() {
    // Enqueue jQuery (should already be included in WordPress)
    wp_enqueue_script('jquery');
    
    // Enqueue mobile menu script
    wp_add_inline_script('jquery', '
        jQuery(document).ready(function($) {
            // Mobile menu toggle functionality
            $(".toggle-mobileMenu").on("click", function() {
                $(".mobile-menu").removeClass("tw--translate-x-full");
                $("body").addClass("mobile-menu-open");
            });
            
            // Close mobile menu
            $(".close-button").on("click", function() {
                $(".mobile-menu").addClass("tw--translate-x-full");
                $("body").removeClass("mobile-menu-open");
            });
            
            // Close menu when clicking outside
            $(document).on("click", function(e) {
                if (!$(e.target).closest(".mobile-menu").length && !$(e.target).closest(".toggle-mobileMenu").length) {
                    $(".mobile-menu").addClass("tw--translate-x-full");
                    $("body").removeClass("mobile-menu-open");
                }
            });
            
            // Prevent closing when clicking inside menu
            $(".mobile-menu").on("click", function(e) {
                e.stopPropagation();
            });
            
            // Mobile submenu toggle
            $(".nav-menu__item.has-submenu > a").on("click", function(e) {
                if ($(window).width() < 992) {
                    e.preventDefault();
                    var $submenu = $(this).next(".sub-menu");
                    $submenu.slideToggle(300);
                    $(this).parent().toggleClass("submenu-open");
                }
            });
        });
    ');
    
    // Add mobile menu CSS
    wp_add_inline_style('your-theme-style', '
        .mobile-menu {
            transition: transform 0.3s ease-in-out;
            box-shadow: 0 0 50px rgba(0, 0, 0, 0.1);
        }
        .mobile-menu:not(.tw--translate-x-full) {
            transform: translateX(0) !important;
        }
        .mobile-menu-open {
            overflow: hidden;
        }
        .mobile-menu-open::before {
            content: "";
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.5);
            z-index: 998;
        }
        .nav-submenu {
            display: none !important;
            position: static !important;
            width: 100% !important;
            box-shadow: none !important;
            background: transparent !important;
            padding: 0 !important;
        }
        .nav-menu__item.has-submenu.submenu-open .nav-submenu {
            display: block !important;
        }
        .nav-submenu__link {
            padding-left: 1.5rem !important;
            border-left: 2px solid transparent;
        }
        .nav-submenu__link:hover {
            border-left-color: #fa0b20;
        }
        .close-button {
            transition: all 0.3s ease;
        }
        .close-button:hover {
            transform: rotate(90deg);
        }
        .nav-menu__link {
            transition: all 0.3s ease;
            border-bottom: 1px solid #f1f1f1;
        }
        .nav-menu__link:hover {
            background-color: #f8f9fa;
            padding-left: 1rem !important;
        }
    ');
}
add_action('wp_enqueue_scripts', 'enqueue_mobile_menu_scripts');
 
 
// More comprehensive font implementation
function apply_albra_sans_font_to_headings() {
    // Add the font face definition and CSS
    $font_css = "
        /* Define Albra Sans Font */
        @font-face {
            font-family: 'Albra Sans';
            src: url('https://testingservertwo.xyz/snowflow/wp-content/themes/payone/assets/fonts/AlbraSansTRIAL-Bold.otf') format('opentype');
            font-weight: 700;
            font-style: normal;
            font-display: swap;
        }
        
        /* Apply to all heading elements */
        h1, h2, h3, h4, h5, h6 {
            font-family: 'Albra Sans', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen-Sans, Ubuntu, Cantarell, 'Helvetica Neue', sans-serif !important;
            font-weight: 700 !important;
        }
        
        /* Apply to WordPress specific heading classes */
        .entry-title, 
        .page-title, 
        .post-title,
        .widget-title,
        .site-title,
        .comments-title,
        .reply-title {
            font-family: 'Albra Sans', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen-Sans, Ubuntu, Cantarell, 'Helvetica Neue', sans-serif !important;
            font-weight: 700 !important;
        }
        
        /* Apply to WooCommerce headings */
        .woocommerce-loop-product__title,
        .product_title,
        .related.products > h2,
        .upsells.products > h2,
        .cross-sells > h2 {
            font-family: 'Albra Sans', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen-Sans, Ubuntu, Cantarell, 'Helvetica Neue', sans-serif !important;
            font-weight: 700 !important;
        }
        
        /* Apply to theme specific heading classes */
        .card-title,
        .blog-post-title,
        .section-title,
        .block-title,
        .module-title {
            font-family: 'Albra Sans', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen-Sans, Ubuntu, Cantarell, 'Helvetica Neue', sans-serif !important;
            font-weight: 700 !important;
        }
        
        /* Gutenberg block editor headings */
        .wp-block-heading h1,
        .wp-block-heading h2,
        .wp-block-heading h3,
        .wp-block-heading h4,
        .wp-block-heading h5,
        .wp-block-heading h6,
        h1.wp-block-heading,
        h2.wp-block-heading,
        h3.wp-block-heading,
        h4.wp-block-heading,
        h5.wp-block-heading,
        h6.wp-block-heading {
            font-family: 'Albra Sans', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen-Sans, Ubuntu, Cantarell, 'Helvetica Neue', sans-serif !important;
            font-weight: 700 !important;
        }
    ";
    
    wp_add_inline_style('wp-block-library', $font_css);
}
add_action('wp_enqueue_scripts', 'apply_albra_sans_font_to_headings');



define('PAYONE_THEME_ROOT', get_template_directory());
define('PAYONE_THEME_ROOT_URL', get_template_directory_uri());
define('PAYONE_INC', PAYONE_THEME_ROOT . '/inc');
define('PAYONE_THEME_SETTINGS', PAYONE_INC . '/theme-settings');
define('PAYONE_THEME_SETTINGS_IMAGES', PAYONE_THEME_ROOT_URL . '/inc/theme-settings/images');
define('PAYONE_TGMA', PAYONE_INC . '/plugins/tgma');
define('PAYONE_DYNAMIC_STYLESHEETS', PAYONE_INC . '/theme-stylesheets');
define('PAYONE_CSS', PAYONE_THEME_ROOT_URL . '/assets/css');
define('PAYONE_JS', PAYONE_THEME_ROOT_URL . '/assets/js');
define('PAYONE_ASSETS', PAYONE_THEME_ROOT_URL . '/assets');
define('PAYONE_DEV', true);


/**
 * Theme Initial File
 * @package payone
 * @since 1.0.0
 */
if (file_exists(PAYONE_INC . '/theme-init.php')) {
    require_once PAYONE_INC . '/theme-init.php';
}


/**
 * Codester Framework Functions
 * @package payone
 * @since 1.0.0
 */
if (file_exists(PAYONE_INC . '/theme-cs-function.php')) {
    require_once PAYONE_INC . '/theme-cs-function.php';
}


/**
 * Theme Helpers Functions
 * @package payone
 * @since 1.0.0
 */
if (file_exists(PAYONE_INC . '/theme-helper-functions.php')) {

    require_once PAYONE_INC . '/theme-helper-functions.php';
    if (!function_exists('payone')) {
        function payone()
        {
            return class_exists('Payone_Helper_Functions') ? new Payone_Helper_Functions() : false;
        }
    }
}

/**
 * Nav menu fallback function
 * @since 1.0.0
 */
if (is_user_logged_in()) {
    function payone_theme_fallback_menu()
    {
        get_template_part('template-parts/default', 'menu');
    }
}