<?php
/**
 * Theme Footer Template
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package payone
 */

$page_container_meta = Payone_Group_Fields_Value::page_container('payone', 'header_options');
?>

</div><!-- #content -->

<?php get_template_part('template-parts/footer/footer', $page_container_meta['footer_type']); ?>

</div><!-- #page -->

<?php wp_footer(); ?>

<script>
    // jQuery(document).ready(function($) {
    //     $('.has-submenu > a').on('click', function(e) {
    //         // Only prevent default if it's a submenu item and we're on desktop
    //         if ($(window).width() > 768) {
    //             e.preventDefault();
    //             $(this).parent('.has-submenu').toggleClass('submenu-open');
    //         }
    //         // On mobile or without JavaScript, let the link work normally
    //     });
    // });
    jQuery(document).ready(function($) {
        $(document).on('click', '.has-submenu > a', function(e) {
            var $link = $(this);
            var $parent = $link.parent('.has-submenu');
            
            // Check if this menu item has an active submenu
            var hasActiveSubmenu = $parent.hasClass('submenu-open');
            
            // Get click position
            var linkWidth = $link.outerWidth();
            var clickX = e.pageX - $link.offset().left;
            
            // If clicked in arrow area (last 30px)
            if (clickX > (linkWidth - 30)) {
                e.preventDefault();
                e.stopImmediatePropagation();
                
                // Close all other submenus
                $('.has-submenu').not($parent).removeClass('submenu-open');
                
                // Toggle this submenu
                $parent.toggleClass('submenu-open');
                
                return false;
            }
            
            // If submenu is already open and user clicks anywhere in the link, close it
            if (hasActiveSubmenu) {
                e.preventDefault();
                $parent.removeClass('submenu-open');
                return false;
            }
            
            // Otherwise, allow the link to work normally
        });
        
        // Close submenus when clicking elsewhere
        $(document).on('click', function(e) {
            if (!$(e.target).closest('.has-submenu').length) {
                $('.has-submenu').removeClass('submenu-open');
            }
        });
    });
</script>

</body>
</html>
