<?php
/**
 * Theme File Download Widget
 * @package Payone
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
    exit(); //exit if access directly
}
// Control core classes for avoid errors
if (class_exists('CSF')) {


    // Create a About Widget
    CSF::createWidget('payone_file_download_widget', array(
        'title' => esc_html__('Payone: File Download', 'payone-core'),
        'classname' => 'payone-widget-file-download',
        'description' => esc_html__('Display File Download widget', 'payone-core'),
        'fields' => array(
            array(
                'id' => 'title',
                'type' => 'text',
                'title' => esc_html__('Title', 'Payone-core'),
                'default' => esc_html__('Download', 'payone-core')
            ),

            array(
                'id' => 'payone-file-download-repeater',
                'type' => 'repeater',
                'title' => esc_html__('File Download', 'payone-core'),
                'fields' => array(
                    array(
                        'id' => 'payone-file-download',
                        'type' => 'media',
                        'title' => esc_html__('File', 'payone-core'),
                    ),
                    array(
                        'id' => 'payone-file-download-text',
                        'type' => 'text',
                        'title' => esc_html__('File Text', 'payone-core'),
                        'default' => esc_html__('Company Profile', 'payone-core')
                    ),

                ),
            ),
        )
    ));


    if (!function_exists('payone_file_download_widget')) {
        function payone_file_download_widget($args, $instance)
        {

            echo $args['before_widget'];

            $title = $instance['title'] ?? '';
            $file_download = is_array($instance['payone-file-download-repeater']) && !empty($instance['payone-file-download-repeater']) ? $instance['payone-file-download-repeater'] : [];


            ?>
            <div class="widget_download">
                <h5 class="widget-headline style-01"><?php echo esc_html($title); ?></h5>               
                <ul>
                    <?php
                        foreach ($file_download as $file) {
                            echo '<li class="mb-0 mt-0">
                                <a download href="'.$file['payone-file-download']['url'].'">
                                    ' . $file['payone-file-download-text'] . '
                                    <i class="fa fa-angle-double-right"></i>
                                </a>
                            </li>';
                        };
                    ?>
                </ul>
            </div>
            <?php

            echo $args['after_widget'];

        }
    }

}

?>