<?php
/**
 * Theme Contact Info Widget
 * @package Payone
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
    exit(); //exit if access directly
}
// Control core classes for avoid errors
if (class_exists('CSF')) {


    // Create a Contact Info Widget
    CSF::createWidget('payone_contact_info_widget', array(
        'title' => esc_html__('Payone: Contact Info', 'payone-core'),
        'classname' => 'payone-widget-contact-info',
        'description' => esc_html__('Display Contact Info widget', 'payone-core'),
        'fields' => array(
            array(
                'id' => 'title',
                'type' => 'text',
                'title' => esc_html__('Title', 'payone-core'),
            ),
            array(
                'id' => 'location',
                'type' => 'textarea',
                'title' => esc_html__('Location', 'Payone-core'),
                'default' => esc_html__('4517 Washington Ave. Manchester, Kentucky 39495', 'payone-core'),
            ),
            array(
                'id' => 'phone',
                'type' => 'text',
                'title' => esc_html__('Phone', 'Payone-core'),
                'default' => esc_html__(' (+888) 123 456 765', 'payone-core'),
            ),
            array(
                'id' => 'email',
                'type' => 'text',
                'title' => esc_html__('Email', 'Payone-core'),
                'default' => esc_html__(' infoname@mail.com', 'payone-core'),
            ),
            array(
                'id' => 'open_time',
                'type' => 'text',
                'title' => esc_html__('Open Time', 'Payone-core'),
                'default' => esc_html__('We are open from Monday to Friday 09.00 AM - 17.00 PM', 'payone-core'),
            ),

            array(
                'id' => 'payone-footer-social-icon-repeater',
                'type' => 'repeater',
                'title' => esc_html__('Social Icon', 'payone-core'),
                'fields' => array(

                    array(
                        'id' => 'payone-footer-social-icon',
                        'type' => 'icon',
                        'title' => esc_html__('Icon', 'payone-core'),
                        'default' => 'flaticon-call'
                    ),
                    array(
                        'id' => 'payone-footer-social-text',
                        'type' => 'text',
                        'title' => esc_html__('Enter Your Url', 'payone-core'),
                        'default' => esc_html__('#', 'payone-core')
                    ),

                ),
            ),
        )
    ));


    if (!function_exists('payone_contact_info_widget')) {
        function payone_contact_info_widget($args, $instance)
        {

            echo $args['before_widget'];
            $title = $instance['title'] ?? '';
            $location = $instance['location'] ?? '';
            $phone = $instance['phone'] ?? '';
            $email = $instance['email'] ?? '';
            $open_time = $instance['open_time'] ?? '';
            $csocialIcon = is_array($instance['payone-footer-social-icon-repeater']) && !empty($instance['payone-footer-social-icon-repeater']) ? $instance['payone-footer-social-icon-repeater'] : [];
            ?>

            <div class="footer-widget widget">
            	<h4 class="widget-headline"><?php echo esc_html($title); ?></h4>
            	<div class="widget_contact">
                    <?php if($phone) : ?>
                        <div class="flex-align gap-20 mb-24">
                            <span class="icon d-flex text-32 text-main-600"><i class="ph ph-phone"></i></span>
                            <div class="">
                                <a href="<?php echo esc_url($phone); ?>" class="text-neutral-500 d-block hover-text-main-600 mb-4"><?php echo esc_html($phone); ?></a>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if($email) : ?>
                        <div class="flex-align gap-20 mb-24">
                            <span class="icon d-flex text-32 text-main-600"><i class="ph ph-envelope-open"></i></span>
                            <div class="">
                                <a href="<?php echo esc_url($email); ?>" class="text-neutral-500 d-block hover-text-main-600 mb-4"><?php echo esc_html($email); ?></a>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if($location) : ?>
                        <div class="flex-align gap-20 mb-24">
                            <span class="icon d-flex text-32 text-main-600"><i class="ph ph-map-trifold"></i></span>
                            <div>
                                <span class="text-neutral-500 d-block mb-4"><?php echo esc_html($location); ?></span>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if (!empty($csocialIcon)) { ?>
                        <ul class="social-media mt-4">
                            <?php
                            foreach ($csocialIcon as $cicon) {
                                echo '<li>
	                                <a href="'.$cicon['payone-footer-social-text'].'">
	                                    <i class="'. $cicon['payone-footer-social-icon'] . '"></i></a>
	                            </li>';
                            };
                            ?>
                        </ul>
                    <?php } ?>
                </div>
            </div>

            <?php

            echo $args['after_widget'];

        }
    }

}

?>