<?php
/*
Plugin Name: Payone Core
Plugin URI: https://themeforest.net/user/wowtheme7/portfolio
Description: Plugin to contain short codes and custom post types of the Payone theme.
Author: Wowtheme7
Author URI: https://wowtheme7.com/
Version: 1.0.0
Text Domain: payone-core
Developer: Md Alamgir (mdalamgirhossen576@gmail.com)
*/


/**
 * If this file is called directly, abort.
 * @package payone
 * @since 1.0.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


/**
 * Plugin directory path
 * @package payone
 * @since 1.0.0
 */
define( 'PAYONE_CORE_ROOT_PATH', plugin_dir_path( __FILE__ ) );
define( 'PAYONE_CORE_ROOT_URL', plugin_dir_url( __FILE__ ) );
define( 'PAYONE_CORE_SELF_PATH', 'payone-core/payone-core.php' );
define( 'PAYONE_CORE_VERSION', '2.0.1' );
define( 'PAYONE_CORE_INC', PAYONE_CORE_ROOT_PATH .'/inc');
define( 'PAYONE_CORE_LIB', PAYONE_CORE_ROOT_PATH .'/lib');
define( 'PAYONE_CORE_ELEMENTOR', PAYONE_CORE_ROOT_PATH .'/elementor');
define( 'PAYONE_CORE_DEMO_IMPORT', PAYONE_CORE_ROOT_PATH .'/demo-import');
define( 'PAYONE_CORE_ADMIN', PAYONE_CORE_ROOT_PATH .'/admin');
define( 'PAYONE_CORE_ADMIN_ASSETS', PAYONE_CORE_ROOT_URL .'admin/assets');
define( 'PAYONE_CORE_WP_WIDGETS', PAYONE_CORE_ROOT_PATH .'/wp-widgets');
define( 'PAYONE_CORE_ASSETS', PAYONE_CORE_ROOT_URL .'assets/');
define( 'PAYONE_CORE_CSS', PAYONE_CORE_ASSETS .'css');
define( 'PAYONE_CORE_JS', PAYONE_CORE_ASSETS .'js');
define( 'PAYONE_CORE_IMG', PAYONE_CORE_ASSETS .'img');


/**
 * Load additional helpers functions
 * @package payone
 * @since 1.0.0
 */
if (!function_exists('payone_core')){
	require_once PAYONE_CORE_INC .'/theme-core-helper-functions.php';
	if (!function_exists('payone_core')){
		function payone_core(){
			return class_exists('Payone_Core_Helper_Functions') ? new Payone_Core_Helper_Functions() : false;
		}
	}
}
//ob flash
remove_action( 'shutdown', 'wp_ob_end_flush_all', 1 );


/**
 * Load Codestar Framework Functions
 * @package payone
 * @since 1.0.0
 */
if ( !payone_core()->is_payone_active()) {
	if ( file_exists( PAYONE_CORE_ROOT_PATH . '/inc/csf-functions.php' ) ) {
		require_once PAYONE_CORE_ROOT_PATH . '/inc/csf-functions.php';
	}
}

/**
 * Core Plugin Init
 * @package payone
 * @since 1.0.0
 */
if ( file_exists( PAYONE_CORE_ROOT_PATH . '/inc/theme-core-init.php' ) ) {
	require_once PAYONE_CORE_ROOT_PATH . '/inc/theme-core-init.php';
}

/**
 * Theme builder
 */
if ( file_exists( PAYONE_CORE_ROOT_PATH . '/theme-builder/hugebinary-header-footer.php' ) ) {
    require_once PAYONE_CORE_ROOT_PATH . '/theme-builder/hugebinary-header-footer.php';
}

// functions.php
function payone_elementor_editor_page() {
    // AOS CSS
    wp_enqueue_style(
        'aos-css',
        'https://cdnjs.cloudflare.com/ajax/libs/aos/2.3.4/aos.css',
        [],
        '2.3.4'
    );
    // AOS JS
    wp_enqueue_script(
        'aos-js',
        'https://cdnjs.cloudflare.com/ajax/libs/aos/2.3.4/aos.js',
        ['jquery'],
        '2.3.4',
        true
    );
    // Init script
    wp_add_inline_script(
        'aos-js',
        'jQuery(document).ready(function($){ AOS.init({ once: false }); });'
    );
}
add_action('wp_enqueue_scripts', 'payone_elementor_editor_page');
add_action('elementor/editor/after_enqueue_scripts', 'payone_elementor_editor_page');