<?php

/**
 * Elementor Addons Init
 * @package payone
 * @since 1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit(); // exit if access directly
}


if ( ! class_exists( 'Payone_Elementor_Widget_Init' ) ) {

	class Payone_Elementor_Widget_Init {
	   /**
		* $instance
		* @since 1.0.0
		*/
		private static $instance;

	   /**
		* construct()
		* @since 1.0.0
		*/
		public function __construct() {
			add_action( 'elementor/elements/categories_registered', array( $this, '_widget_categories' ) );
			//elementor widget registered
			add_action( 'elementor/widgets/widgets_registered', array( $this, '_widget_registered' ) );
			// elementor editor css
			add_action( 'elementor/editor/after_enqueue_scripts', array( $this, 'load_assets_for_elementor' ) );
			//add icon to elementor new icons fileds
			add_filter( 'elementor/icons_manager/native', array( $this, 'add_custom_icon_to_elementor_icons' ) );
		}

		/**
	     * getInstance()
	     * @since 1.0.0
	     */
		public static function getInstance() {
			if ( null == self::$instance ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		/**
		 * _widget_categories()
		 * @since 1.0.0
		 */
		public function _widget_categories( $elements_manager ) {
			$elements_manager->add_category(
				'payone_widgets',
				[
					'title' => esc_html__( 'Payone Widgets', 'payone-core' ),
					'icon'  => 'fas fa-plug',
				]
			);
		}

		/**
		 * _widget_registered()
		 * @since 1.0.0
		 */
		public function _widget_registered() {
			if ( ! class_exists( 'Elementor\Widget_Base' ) ) {
				return;
			}
			$elementor_widgets = array(
				'accordion-one',
				'accordion-tab',
				'about-img',
				'banner-one',
				'banner-two',
				'banner-three',
				'blog-list',
				'button',
				'breadcrumb',
				'contact-box',
				'icon-box',
				'heading-title',
				'marquee',
				'navbar',
				'navbar-two',
				'payment-slider',
				'payment-solution',
				'payment-solution-two',
				'pricing-one',
				'testimonial-slider-one',
				'team-list',
				'service-list',
				'service-slider',
				'service-title',
				'video-box',
				'why-payone',
				'work-process',
			);

			$elementor_widgets = apply_filters( 'payone_elementor_widget', $elementor_widgets );
			ksort( $elementor_widgets );
			if ( is_array( $elementor_widgets ) && ! empty( $elementor_widgets ) ) {
				foreach ( $elementor_widgets as $widget ) {
					if ( file_exists( PAYONE_CORE_ELEMENTOR . '/addons/elementor-' . $widget . '-widget.php' ) ) {
						require_once PAYONE_CORE_ELEMENTOR . '/addons/elementor-' . $widget . '-widget.php';
					}
				}
			}
			
		}

		public function add_custom_icon_to_elementor_icons( $icons ) {
			$icons['flaticon'] = [
				'name'          => 'flaticon',
				'label'         => esc_html__( 'Flaticon', 'payone-core' ),
				'url'           => PAYONE_CORE_CSS . '/flaticon.css',
				// icon css file
				'enqueue'       => [ PAYONE_CORE_CSS . '/flaticon.css' ],
				// icon css file
				'prefix'        => 'flaticon-',
				//prefix ( like fas-fa  )
				'displayPrefix' => '',
				//prefix to display icon
				'labelIcon'     => 'flaticon-karate-1',
				//tab icon of elementor icons library
				'ver'           => '1.0.0',
				'fetchJson'     => PAYONE_CORE_JS . '/flaticon.js',
				//json file with icon list example {"icons: ['icon class']}
				'native'        => true,
			];

			return $icons;
		}

		/**
		 * load custom assets for elementor
		 * @since 1.0.0
		*/
		public function load_assets_for_elementor() {
			wp_enqueue_style( 'flaticon', PAYONE_CORE_CSS . '/flaticon.css' );
			wp_enqueue_style( 'payone-core-elementor-style', PAYONE_CORE_ADMIN_ASSETS . '/css/elementor-editor.css' );
		}
	}

	if ( class_exists( 'Payone_Elementor_Widget_Init' ) ) {
		Payone_Elementor_Widget_Init::getInstance();
	}
}//end if


