<?php
/**
 * Elementor Widget
 * @package payone
 * @since 1.0.0
 */

namespace Elementor;

class Payone_Testimonial_Slider_Two_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'payone-testimonial-slider-two';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Testimonial Slider Two', 'payone-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-slides';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['payone_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {
        $this->start_controls_section(
            'left_settings_section',
            [
                'label' => esc_html__('Testimonial Left Content', 'payone-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'subtitle',
            [
                'label' => esc_html__('Subtitle', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Safe Transportation & Logistics', 'payone-core'),
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('What our client is says about our services', 'payone-core'),
            ]
        );
        $this->add_control(
            'button_text',
            [
                'label' => esc_html__('Button Text', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('View services', 'payone-core'),
            ]
        );
        $this->add_control(
            'button_link',
            [
                'label' => esc_html__('Button Link', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('#', 'payone-core'),
            ]
        );
        $this->add_control(
            'quote_icon', [
                'label' => esc_html__('Quote Icon', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('Quote Icon', 'payone-core'),
            ]
        );
        $this->add_control(
            'testi_image_left', [
                'label' => esc_html__('testi Image', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('testi Image', 'payone-core'),
            ]
        );
        $this->add_control(
            'show_counter',
            [
                'label' => __( 'Show / Hide Counter Box One', 'payone-core' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'payone-core' ),
                'label_off' => __( 'Hide', 'payone-core' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'counter_number', [
                'label' => esc_html__('Conter Number', 'payone-core'),
                'type' => Controls_Manager::NUMBER,
                'default' => esc_html__('25', 'payone-core')
            ]
        );
        $this->add_control(
            'number_plus', [
                'label' => esc_html__('Number Plus', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('+', 'payone-core')
            ]
        );
        $this->add_control(
            'counter_title', [
                'label' => esc_html__('Counter Title', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'description' => esc_html__('Enter Title', 'payone-core'),
                'default' => esc_html__('Years of experience', 'payone-core')
            ]
        );
        $this->add_control(
            'counter_line_shape', [
                'label' => esc_html__('line Image', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
                'default' => array(
                    'url' => Utils::get_placeholder_image_src()
                ),
            ]
        );
        $this->add_control(
            'counter_rating', [
                'label' => esc_html__('Counter Rating', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'description' => esc_html__('Enter Rating', 'payone-core'),
                'default' => esc_html__('4.9', 'payone-core')
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'slider_settings_section',
            [
                'label' => esc_html__('Slider Content', 'payone-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

       
        $repeater->add_control(
            'testi_quate', [
                'label' => esc_html__('Testimonial Quate Image', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('Upload Quote', 'payone-core'),
            ]
        );
        $repeater->add_control(
            'testi_image', [
                'label' => esc_html__('Testimonial Thumb', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('Testimonial Thumb', 'payone-core'),
            ]
        );
        $repeater->add_control(
            'name', [
                'label' => esc_html__('Name', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Robiul Hasan', 'payone-core'),
                'show_label' => true,
                'description' => esc_html__('Enter name', 'payone-core'),
            ]
        );
        $repeater->add_control(
            'designation', [
                'label' => esc_html__('Designation', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Front End Developer', 'payone-core'),
                'description' => esc_html__('Enter designation', 'payone-core'),
            ]
        );
        $repeater->add_control(
            'content', [
                'label' => esc_html__('Content', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'show_label' => false,
                'default' => esc_html__('are so beguiled and demorali ed by the tech of pleasure of the moment Dislike men who are so beguiled and demoraliz worlds ed by the charms of '),
                'description' => esc_html__('Upload Content', 'payone-core'),
            ]
        );
        $repeater->add_control(
            'rating', [
                'label' => esc_html__('Rating', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('5', 'payone-core'),
            ]
        );
        $this->add_control('testimonial_items', [
            'label' => esc_html__('Testimonial Slider Item', 'payone-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'image' => array(
                        'url' => Utils::get_placeholder_image_src()
                    )
                ]
            ],
        ]);
        $this->add_control(
            'testi_bg_shape', [
                'label' => esc_html__('Testimonial BG Shape', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('Testimonial BG Shap', 'payone-core'),
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'slider_control_section',
            [
                'label' => esc_html__('Slider Settings', 'payone-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control('nav_position', [
            'label' => esc_html__('Nav Position', 'payone-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'style-1' => esc_html__('default', 'payone-core'),
                'slider-control-right-top' => esc_html__('Top Right', 'payone-core'),
            ),
            'default' => 'style-1',
            'description' => esc_html__('Select price style', 'payone-core')
        ]);
        $this->add_control(
            'items',
            [
                'label' => esc_html__('slidesToShow', 'payone-core'),
                'type' => Controls_Manager::NUMBER,
                'description' => esc_html__('you can set how many item show in slider', 'payone-core'),
                'default' => '1',
            ]
        );
        $this->add_control(
            'loop',
            [
                'label' => esc_html__('Loop', 'payone-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'payone-core'),
            ]
        );
        $this->add_control(
            'autoplay',
            [
                'label' => esc_html__('Autoplay', 'payone-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'payone-core'),
            ]
        );
        $this->add_control(
            'nav',
            [
                'label' => esc_html__('Nav', 'payone-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'payone-core'),
                'default' => 'yes'
            ]
        );
        $this->add_control(
            'nav_left_arrow',
            [
                'label' => esc_html__('Nav Left Icon', 'payone-core'),
                'type' => Controls_Manager::ICONS,
                'description' => esc_html__('you can set yes/no to enable/disable', 'payone-core'),
                'default' => [
                    'value' => 'fas fa-angle-left',
                    'library' => 'solid',
                ],
                'condition' => ['nav' => 'yes']
            ]
        );
        $this->add_control(
            'nav_right_arrow',
            [
                'label' => esc_html__('Nav Right Icon', 'payone-core'),
                'type' => Controls_Manager::ICONS,
                'description' => esc_html__('you can set yes/no to enable/disable', 'payone-core'),
                'default' => [
                    'value' => 'fas fa-angle-right',
                    'library' => 'solid',
                ],
                'condition' => ['nav' => 'yes']
            ]
        );
        $this->add_control(
            'center',
            [
                'label' => esc_html__('Center', 'payone-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'payone-core'),

            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'testi_styling_settings_section',
            [
                'label' => esc_html__('Styling Settings', 'payone-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control('subtitle_color', [
            'label' => esc_html__('Sub Title Color', 'payone-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .text-main-600" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('subtitle Typography', 'payone-core'),
            'name' => 'subtitle_typography',
            'description' => esc_html__('subtitle typography', 'payone-core'),
            'selector' => "{{WRAPPER}} .tw-text-xl"
        ]);
        $this->add_control('title_color', [
            'label' => esc_html__('Title Color', 'payone-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} h2" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('title Typography', 'payone-core'),
            'name' => 'title_typography',
            'description' => esc_html__('title typography', 'payone-core'),
            'selector' => "{{WRAPPER}} h2"
        ]);
        $this->add_control('button_color', [
            'label' => esc_html__('Button text Color', 'payone-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .btn-main" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Button Text Typography', 'payone-core'),
            'name' => 'button_typography',
            'description' => esc_html__('button text typography', 'payone-core'),
            'selector' => "{{WRAPPER}} .btn-main"
        ]);
        $this->add_control('number_color', [
            'label' => esc_html__(' Number  Color', 'payone-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} h1.text-white" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Number Typography', 'payone-core'),
            'name' => 'number_typography',
            'description' => esc_html__('Number typography', 'payone-core'),
            'selector' => "{{WRAPPER}} h1.text-white"
        ]);

        $this->add_control('content_color', [
            'label' => esc_html__('Content Color', 'payone-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} p.text-main-two-600" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Content Typography', 'payone-core'),
            'name' => 'content_typography',
            'description' => esc_html__('Content typography', 'payone-core'),
            'selector' => "{{WRAPPER}} p.tw-text-md"
        ]);

        $this->add_control('name_color', [
            'label' => esc_html__('Name Color', 'payone-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} h6.tw-text-lg" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Name Typography', 'payone-core'),
            'name' => 'name_typography',
            'description' => esc_html__('Name typography', 'payone-core'),
            'selector' => "{{WRAPPER}} h6.tw-text-lg"
        ]);

        $this->add_control('designation_color', [
            'label' => esc_html__('Designation Color', 'payone-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} span.text-main-600" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Designation Typography', 'payone-core'),
            'name' => 'desig_typography',
            'description' => esc_html__('Designation typography', 'payone-core'),
            'selector' => "{{WRAPPER}} span.text-main-600"
        ]);
        $this->add_control('star_color', [
            'label' => esc_html__('Star Color', 'payone-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .text-star" => "color: {{VALUE}}"
            ]
        ]);
        $this->end_controls_section();

    }


    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $all_testimonial_items = $settings['testimonial_items'];

        $rand_numb = rand(333, 999999999);
        //slider settings
        $slider_settings = [
            "loop" => esc_attr($settings['loop']),
            "items" => esc_attr($settings['items'] ?? 1),
            "center" => esc_attr($settings['center']),
            "autoplay" => esc_attr($settings['autoplay']),
            "nav" => esc_attr($settings['nav']),
            "navleft" => payone_core()->render_elementor_icons($settings['nav_left_arrow']),
            "navright" => payone_core()->render_elementor_icons($settings['nav_right_arrow'])
        ];
        
        ?>

            <div class="py-140 bg-neutral-50 overflow-hidden position-relative z-1">
                <?php if($settings['testi_bg_shape']) : ?>
                        <img src="<?php echo $settings['testi_bg_shape']['url']; ?>" alt="" class="position-absolute bottom-0 tw-start-0 w-100 z-n1">
                <?php endif; ?>
                
                <div class="container">
                    <div class="d-flex align-items-end flex-wrap tw-gap-6 justify-content-between tw-mb-15">
                        <div class="max-w-632-px text-start">
                            <?php if($settings['subtitle']) : ?>
                                <span class="splitTextStyleTwo cursor-small tw-text-xl fw-bold fst-italic text-decoration-underline text-main-600 tw-mb-305"><?php echo $settings['subtitle']; ?></span>
                            <?php endif; ?>
                            <?php if($settings['title']) : ?>
                                <h2 class="splitTextStyleOne cursor-big h1"><?php echo $settings['title']; ?></h2>
                            <?php endif; ?>
                        </div>
                        <?php if($settings['button_text']) : ?>
                            <a href="<?php echo $settings['button_link']; ?>" class="cursor-small btn btn-main hover-style-one button--stroke d-inline-flex align-items-center justify-content-center tw-gap-5 group active--translate-y-2 rounded-0 tw-px-13 tw-py-505" data-block="button">
                                <span class="button__flair"></span>
                                <span class="button__label"><?php echo $settings['button_text']; ?></span>
                            </a>
                        <?php endif; ?>
                    </div>
                    
                    <div class="view-w-100 position-relative z-1">
                        <div class="row gy-4 gx-5">

                            <div class="col-lg-3">
                                <div class="tw-pb-8 position-relative h-100">
                                    <div class="bg-white tw-rounded-xl tw-p-205 h-100">
                                        <?php if($settings['testi_image_left']['url']) : ?>
                                            <div class="position-relative tw-rounded-xl overflow-hidden h-100" data-aos="zoom-in" data-aos-duration="1000" data-aos-delay="200">
                                                <img src="<?php echo $settings['testi_image_left']['url']; ?>" alt="img" class="w-100 h-100 object-fit-cover">
                                            </div>
                                        <?php endif; ?>
                                        <?php if($settings['quote_icon']['url']) : ?>
                                            <div class="bg-white cursor-big common-shadow-two tw-rounded-md d-flex justify-content-center align-items-center position-absolute top-0 tw-w-108-px tw-h-108-px tw-mt-6 tw--ms-54-px" data-aos="zoom-in" data-aos-duration="1000" data-aos-delay="200">
                                                <img src="<?php echo $settings['quote_icon']['url']; ?>" alt="img">
                                            </div>
                                        <?php endif; ?>
                                        <?php if( 'yes'===$settings['show_counter'] ){ ?>
                                            <div class="tw-p-10 tw-pe-130-px tw--translate-x-30-px bg-main-600 position-absolute tw-start-0 bottom-0 tw--ms-30-px" data-aos="zoom-in" data-aos-duration="1000" data-aos-delay="200">
                                                <?php if($settings['counter_number']) : ?>
                                                    <h1 class="text-white tw-mb-4 cursor-big counter d-inline-block">
                                                        <?php echo $settings['counter_number']; ?> 
                                                    </h1>
                                                <?php endif; ?>
                                                <?php if($settings['number_plus']) : ?>
                                                    <h1 class="text-white tw-mb-4 cursor-big d-inline-block"><?php echo $settings['number_plus']; ?></h1>
                                                <?php endif; ?>
                                                <div class="d-flex flex-column tw-gap-1 align-items-start">
                                                    <?php if($settings['counter_title']) : ?>
                                                        <span class="text-white fw-medium cursor-small"><?php echo $settings['counter_title']; ?></span>
                                                        <?php if($settings['counter_line_shape']) : ?>
                                                            <img src="<?php echo $settings['counter_line_shape']['url']; ?>" alt="img">
                                                        <?php endif; ?>
                                                    <?php endif; ?>
                                                </div>
                                                <?php if($settings['counter_rating']) : ?>
                                                    <div class="cursor-small before-border position-relative tw-p-205 bg-white d-inline-flex align-items-start tw-gap-1 position-absolute top-0 tw-end-0 tw-mt-205 tw-me-205 z-1">
                                                        <span class="tw-text-xl fw-semibold text-main-600"><?php echo $settings['counter_rating']; ?></span>
                                                        <span class="tw-text-xl fw-semibold text-main-600 d-flex tw--translate-y-4-px"><i class="ph-fill ph-star"></i></span>
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-8">

                                <div class="testimonials-two-slider swiper">
                                    <?php foreach ($all_testimonial_items as $testimonial_item): ?>
                                        <div class="swiper-wrapper">
                                            <div class="swiper-slide" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="100">
                                                <div class="text-center ">
                                                    <div class="testimonials-two__content common-shadow-six bg-white tw-rounded-2xl tw-pt-15 tw-pb-84-px tw-px-4 border border-white hover-border-main-600 tw-duration-300">
                                                        <?php if($testimonial_item['testi_quate']) : ?>
                                                            <span class="tw-mb-8 cursor-small">
                                                                <img src="<?php echo $testimonial_item['testi_quate']['url']; ?>" alt="img">
                                                            </span>
                                                        <?php endif; ?>
                                                        <?php if($testimonial_item['content']) : ?>
                                                            <p class="tw-text-md text-main-two-600 cursor-small max-w-318-px mx-auto tw-leading-loose">
                                                                <?php echo esc_html($testimonial_item['content']); ?></p>
                                                        <?php endif; ?>
                                                        <ul class="tw-mt-7 d-inline-flex tw-gap-1 cursor-small">
                                                            <?php for ($i=0; $i < $testimonial_item['rating']; $i++) {  ?>
                                                                <li class="text-star tw-text-lg d-flex"><i class="ph-fill ph-star"></i></li>
                                                            <?php }?>
                                                        </ul>
                                                    </div>
                                                    <div class="tw--mt-45-px position-relative">
                                                        <?php if($testimonial_item['testi_image']) : ?>
                                                            <div class="bg-white rounded-circle tw-w-90-px tw-h-90-px common-shadow-six tw-p-105 d-inline-flex">
                                                                <img src="<?php echo $testimonial_item['testi_image']['url']; ?>" alt="img" class="w-100 h-100 object-fit-cover rounded-circle">
                                                            </div>
                                                        <?php endif; ?>
                                                        <?php if($testimonial_item['name']) : ?>
                                                            <h6 class="tw-text-lg tw-mt-4 cursor-big"><?php echo esc_html($testimonial_item['name']); ?></h6>
                                                        <?php endif; ?>
                                                        <?php if($testimonial_item['designation']) : ?>
                                                            <span class="tw-mt-105 text-main-600 cursor-small"><?php echo esc_html($testimonial_item['designation']); ?></span>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                </div>

                                <div class="position-relative z-1 d-flex justify-content-center align-items-center tw-gap-5 tw-mt-12">
                                    <div class="cursor-big testimonials-two-button-prev tw-w-14 tw-h-14 rounded-circle tw-text-xl bg-white text-main-two-600 hover-bg-main-600 d-flex justify-content-center align-items-center tw-duration-300">
                                        <i class="ph ph-arrow-left"></i>
                                    </div>
                                    <div class="cursor-big testimonials-two-button-next tw-w-14 tw-h-14 rounded-circle tw-text-xl bg-white text-main-two-600 hover-bg-main-600 d-flex justify-content-center align-items-center tw-duration-300">
                                        <i class="ph ph-arrow-right"></i> 
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php
    }
}
Plugin::instance()->widgets_manager->register_widget_type(new Payone_Testimonial_Slider_Two_Widget());