<?php
/**
 * Elementor Widget
 * @package payone
 * @since 1.0.0
 */

namespace Elementor;
class Payone_Payment_Solution extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'payone-payment-solution';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Payment Solution', 'payone-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-editor-list-ul';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['payone_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {
        $this->start_controls_section(
            'payment_section',
            [
                'label' => esc_html__('payment Content', 'payone-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'left_img', [
                'label' => esc_html__('Left Image', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'left_title', [
                'label' => esc_html__('Title', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Online Sellers', 'payone-core')
            ]
        );
        $this->add_control(
            'left_content', [
                'label' => esc_html__('Title', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Secure and seamless payment solutions designed specifically for online sellers worldwide.', 'payone-core')
            ]
        );

        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'main_img', [
                'label' => esc_html__('Main Image', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
            ]
        );
        $repeater->add_control(
            'title', [
                'label' => esc_html__('Title', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'description' => esc_html__('enter title.', 'payone-core'),
                'default' => esc_html__('Online Sellers', 'payone-core')
            ]
        );
        $repeater->add_control(
            'content', [
                'label' => esc_html__('Content Title', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'description' => esc_html__('enter title.', 'payone-core'),
                'default' => esc_html__('Secure and seamless payment solutions designed specifically for online sellers worldwide.', 'payone-core')
            ]
        );
        $repeater->add_control(
            'btn_text', [
                'label' => esc_html__('btn text', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('LEARN MORE', 'payone-core')
            ]
        );
        $repeater->add_control(
            'btn_url', [
                'label' => esc_html__('btn_url', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('#', 'payone-core')
            ]
        );
        $this->add_control('payment_items', [
            'label' => esc_html__('payment Item', 'payone-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
        ]);


        $this->add_control(
            'animate_img1', [
                'label' => esc_html__('animate img 1', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'animate_img2', [
                'label' => esc_html__('animate img 2', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'animate_img3', [
                'label' => esc_html__('animate img 3', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
            ]
        );
        $this->end_controls_section();


        
        $this->start_controls_section(
            'styling_settings_section',
            [
                'label' => esc_html__('Styling Settings', 'payone-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control('subtitle_color', [
            'label' => esc_html__('Subtitle Color', 'payone-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .text-main-600" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->end_controls_section();
    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $payment_items = $settings['payment_items'];
        ?>
            <div class="bg-base-two-600 position-relative z-1 overflow-hidden">
                <?php if($settings['animate_img1']['url']) : ?>
                    <img src="<?php echo $settings['animate_img1']['url']; ?>" alt="Image" class="position-absolute z-n1 inset-block-end-100px inset-inline-start-100px d-lg-block d-none animation-Updowm__two">
                <?php endif; ?>
                <?php if($settings['animate_img2']['url']) : ?>
                    <img src="<?php echo $settings['animate_img2']['url']; ?>" alt="Image" class="position-absolute z-n1 inset-inline-end-100px d-lg-block d-none animation-rotation__two">
                <?php endif; ?>
                <?php if($settings['animate_img3']['url']) : ?>
                    <img src="<?php echo $settings['animate_img3']['url']; ?>" alt="Image" class="position-absolute z-n1 inset-block-end-89px inset-inline-end-95px d-lg-block d-none animation-Updowm__two">
                <?php endif; ?>
                <div class="container">
                    <div class="row gy-4">
                        <div class="col-lg-5">
                            <div class="position-relative platform-item-img" data-aos="fade-up" data-aos-duration="600">
                                <?php if($settings['left_img']['url']) : ?>
                                    <img src="<?php echo $settings['left_img']['url']; ?>" alt="h-100 w-100">
                                <?php endif; ?>
                                <div class="platform-item max-w-370-px w-100 position-absolute bottom-0 tw-start-0 tw-mb-10 tw-ms-10">
                                    <?php if($settings['left_title']) : ?>
                                        <h4 class="fw-normal text-white tw-mb-3 cursor-big"><?php echo $settings['left_title']; ?></h4>
                                    <?php endif; ?>
                                    <?php if($settings['left_content']) : ?>
                                        <p class="fw-semibold tw-text-405 text-white "><?php echo $settings['left_content']; ?></p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-7">
                            <div class="one-platform__title d-flex align-items-center tw-gap-4">
                                <?php 
                                    $k = 0;
                                    foreach($payment_items as $item) : 
                                    $k++;
                                    if($k == 2) {
                                        $active = 'active';
                                    }else {
                                        $active = '';
                                    }
                                ?>
                                <div class="payment-solutions__item cursor-pointer tw-duration-500 <?php echo $active; ?>" data-aos="fade-up" data-aos-duration="800">
                                    <?php if($item['title']) : ?>
                                        <div class="payment-solutions__button bg-white tw-w-86-px tw-h-380-px tw-rounded-md tw-py-6">
                                            <h4 class="one-platform__text fw-normal text-dark-600 tw-transform-rotate-90deg tw-w-250-px cursor-big"><?php echo $item['title']; ?></h4>
                                        </div>
                                    <?php endif; ?>
                                    <div class="payment-solutions__content max-w-370-px tw-h-380-px position-relative w-100">
                                        <?php if($item['main_img']['url']) : ?>
                                            <img src="<?php echo $item['main_img']['url']; ?>" alt="Image" class="h-100 w-100">
                                        <?php endif; ?>
                                        <div class="max-w-346-px position-absolute top-0 tw-start-0 tw-mt-8 tw-ms-8">
                                            <?php if($item['title']) : ?>
                                                <h4 class="fw-normal text-white cursor-big tw-mb-3"><?php echo $item['title']; ?></h4>
                                            <?php endif; ?>
                                            <?php if($item['content']) : ?>
                                                <p class="fw-semibold tw-text-405 text-white"><?php echo $item['content']; ?></p>
                                            <?php endif; ?>
                                        </div>
                                        <?php if($item['btn_text']) : ?>
                                            <a href="<?php echo $item['btn_url']; ?>" class="text-dark-600-important one-platform__link fw-semibold tw-text-405 max-w-310-px w-100 text-dark-600 bg-main-600 tw-py-3 tw-px-5 text-center tw-rounded-md position-absolute bottom-0 tw-start-0 tw-ms-50-persent tw-translate-x-50 tw-mb-8">
                                                <?php echo $item['btn_text']; ?>
                                            </a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <?php endforeach; ?>

                            </div>
                        </div>

                    </div>

                </div>
            </div>
        <?php 
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Payone_Payment_Solution());