<?php
/**
 * Elementor Widget
 * @package payone
 * @since 1.0.0
 */

namespace Elementor;
class Payone_Payment_Solution_Two extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'payone-payment-solution-two';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Payment Solution 02', 'payone-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-editor-list-ul';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['payone_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {
        $this->start_controls_section(
            'payment_section',
            [
                'label' => esc_html__('payment Content', 'payone-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'title_icon_class', [
                'label' => esc_html__('title icon class', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('ph-fill ph-thumbs-up', 'payone-core'),
            ]
        );
        $repeater->add_control(
            'title', [
                'label' => esc_html__('Title', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'description' => esc_html__('enter title.', 'payone-core'),
                'default' => esc_html__('Online Sellers', 'payone-core')
            ]
        );

        
        $repeater->add_control(
            'main_img', [
                'label' => esc_html__('Main Image', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
            ]
        );
        $repeater->add_control(
            'content', [
                'label' => esc_html__('Content Title', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'description' => esc_html__('enter title.', 'payone-core'),
                'default' => esc_html__('Replacing a maintains the amount of lines. When replacing a selection. help agencies to define their new business objectives and then create.', 'payone-core')
            ]
        );
        $repeater->add_control(
            'btn_text', [
                'label' => esc_html__('btn text', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('LEARN MORE', 'payone-core')
            ]
        );
        $repeater->add_control(
            'btn_url', [
                'label' => esc_html__('btn_url', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('#', 'payone-core')
            ]
        );
        $this->add_control('payment_items', [
            'label' => esc_html__('payment Item', 'payone-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'image' => array(
                        'url' => Utils::get_placeholder_image_src()
                    )
                ]
            ],
        ]);
        $this->end_controls_section();


        
        $this->start_controls_section(
            'styling_settings_section',
            [
                'label' => esc_html__('Styling Settings', 'payone-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control('subtitle_color', [
            'label' => esc_html__('Subtitle Color', 'payone-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .text-main-600" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->end_controls_section();
    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $payment_items = $settings['payment_items'];
        ?>

            <div class="z-1 overflow-hidden">
                <div class="container">
                    <div class="one-platform__title d-flex align-items-center tw-gap-4">

                        <?php 
                            $i = 0;
                            foreach($payment_items as $payment_item) : 
                            $i++;
                            if($i == 2) {
                                $active = 'active';
                            }else {
                                $active = '';
                            }
                        ?>
                            <div class="payment-solutions__item cursor-pointer <?php echo $active; ?>" data-aos="fade-up" data-aos-duration="800">
                                <div class="payment-solutions__button bg-base-two-10 tw-w-86-px tw-h-420-px tw-rounded-md tw-py-6 border-base-two-600 border-top border-bottom position-relative">
                                    <?php if($payment_item['title_icon_class']) : ?>
                                        <span class="choose-us__icon tw-w-13 tw-h-13 bg-base-two-10 tw-rounded-md text-base-two-600 tw-text-7 d-flex align-items-center justify-content-center position-absolute bottom-0 tw-start-0 tw-ms-50-persent  translate-middle-x tw-mb-7">
                                            <i class="<?php echo $payment_item['title_icon_class']; ?>"></i>
                                        </span>
                                    <?php endif; ?>
                                    <h4 class="choose-us__title fw-normal text-dark-600 cursor-big tw-transform-rotate-90deg-translate-72px tw-w-406-px">
                                        <?php echo $payment_item['title']; ?>
                                    </h4>
                                </div>
                                <div class="payment-solutions__content max-w-418-px tw-w-406-px w-100 bg-base-two-600 tw-rounded-xl tw-px-8 tw-py-8">
                                    <?php if($payment_item['main_img']['url']) : ?>
                                        <span class="tw-w-15 tw-h-15 bg-white tw-rounded-md d-flex align-items-center justify-content-center tw-mb-8">
                                            <img src="<?php echo $payment_item['main_img']['url']; ?>" alt="Image">
                                        </span>
                                    <?php endif; ?>
                                    <?php if($payment_item['title']) : ?>
                                        <h4 class="fw-normal cursor-big text-white tw-mb-3"><?php echo $payment_item['title']; ?></h4>
                                    <?php endif; ?>
                                    <?php if($payment_item['content']) : ?>
                                        <p class="fw-normal tw-text-md text-white tw-mb-17">
                                            <?php echo $payment_item['content']; ?>
                                        </p>
                                    <?php endif; ?>
                                    <?php if($payment_item['btn_text']) : ?>
                                        <a href="<?php echo $payment_item['btn_url']; ?>" class="fw-semibold tw-text-4 text-dark-600 bg-white tw-px-6 tw-py-3 tw-rounded-md w-100 text-center ">
                                            <?php echo $payment_item['btn_text']; ?>
                                        </a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endforeach ?>

                    </div>
                </div>
            </div>

        <?php 
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Payone_Payment_Solution_Two());