<?php
/**
 * Elementor Widget
 * @package Payone
 * @since 1.0.0
 */

namespace Elementor;
class Payone_Marquee extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'payone-marquee-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Marquee', 'payone-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-editor-list-ul';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['payone_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'payone-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control('marque_style', [
            'label' => esc_html__('marque style', 'payone-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'style-1' => esc_html__('Style 1', 'payone-core'),
                'style-2' => esc_html__('style 2', 'payone-core'),
            ),
            'default' => 'style-1',
            'description' => esc_html__('Select marque Style', 'payone-core')
        ]);
        
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'image', [
                'label' => esc_html__('Main Image', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('Upload Main image', 'payone-core'),
            ]
        );
        $repeater->add_control(
            'title', [
                'label' => esc_html__('Name', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Transportation', 'payone-core'),
                'show_label' => true,
                'description' => esc_html__('Enter Title', 'payone-core'),
            ]
        );
        $this->add_control('marquee_items', [
            'label' => esc_html__('Marquee Item', 'payone-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
        ]);
        $this->end_controls_section();


        /*  tab styling tabs start */
        $this->start_controls_section(
            'tab_settings_section',
            [
                'label' => esc_html__('Tab Settings', 'payone-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->end_controls_tabs();

        $this->end_controls_section();

    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        
        $settings = $this->get_settings_for_display();
        $marquee_items = $settings['marquee_items'];
        ?>

        <?php if($settings['marque_style'] == 'style-1') : ?>
            <div class="overflow-hidden">
                <div class="slider__marquee style2 bg-base-two-600 tw-py-8">
                    <div class="marquee_mode">
                        <?php foreach ($marquee_items as $item): ?>
                            <div class="item tw-gap-10">
                                <?php if($item['image']['url']) : ?>
                                    <img src="<?php echo $item['image']['url']; ?>" alt="img">
                                <?php endif; ?>
                                <?php if($item['title']) : ?>
                                    <h3 class="fw-normal text-white hover-text-main-600 tw-duration-500"><?php echo $item['title']; ?></h3>
                                <?php endif; ?>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        <?php elseif($settings['marque_style'] == 'style-2') : ?>
            <h2>Style 2</h2>
        <?php endif; ?>        

        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Payone_Marquee());