<?php
/**
 * Elementor Widget
 * @package Payone
 * @since 1.0.0
 */

namespace Elementor;
class Payone_Button_Widget extends Widget_Base
{

    /**
     * Get widget name.
     * @return string Widget name.
     */
    public function get_name()
    {
        return 'payone-button-widget';
    }

    /**
     * Get widget title.
     * @return string Widget title.
     */
    public function get_title()
    {
        return __('Payone Button', 'payone-core');
    }

    public function get_keywords()
    {
        return ['Section', 'Button', "CodexShaper", 'Payone'];
    }

    /**
     * Get widget icon.
     * @return string Widget icon.
     */
    public function get_icon()
    {
        return 'eicon-button';
    }

    /**
     * Get widget categories.
     * @return array Widget categories.
     *
     */
    public function get_categories()
    {
        return ['Payone_widgets'];
    }

    /**
     * Register Elementor widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => __('General Settings', 'payone-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control('button_style', [
            'label' => esc_html__('button_style', 'payone-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'style-1' => esc_html__('Style One', 'payone-core'),
                'style-2' => esc_html__('Style Two', 'payone-core'),
                'style-3' => esc_html__('Style Three', 'payone-core'),
                'style-4' => esc_html__('Style Four', 'payone-core'),
            ),
            'default' => 'style-1',
            'description' => esc_html__('button style', 'payone-core')
        ]);
        $this->add_control(
            'btn_text',
            [
                'label' => __('Btn text', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'description' => __('enter  btn text.', 'payone-core'),
                'default' => __('Discover More ', 'payone-core'),
            ]
        );
        $this->add_control(
            'btn_url',
            [
                'label' => __('Btn url', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'description' => __('Enter  btn url.', 'payone-core'),
                'default' => __('#', 'payone-core'),
            ]
        );
        $this->add_control(
            'btn_icon',
            [
                'label' => __('Btn Icon', 'payone-core'),
                'type' => Controls_Manager::ICONS,
                'description' => __('enter  btn Icon.', 'payone-core'),
            ]
        );
        $this->add_control('icon_alignment', [
            'label' => __('Icon Alignment', 'payone-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'float-end' => __('Icon Right', 'payone-core'),
                'float-start' => __('Icon Left', 'payone-core'),
            ),
            'default' => 'float-end',
        ]);
        $this->end_controls_section();

        //style tab start
        $this->start_controls_section(
            'styling_section',
            [
                'label' => __('Styling Settings', 'payone-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'btn_padding',
            [
                'label' => __('Button Padding', 'payone-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .btn-wrapper .btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'btn_border_radius',
            [
                'label' => __('Button Border Radius', 'payone-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .btn-wrapper .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'btn_icon_margin',
            [
                'label' => __('Button Icon Margin', 'payone-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .btn-wrapper .btn svg' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control('btn_color', [
            'label' => __('btn Color', 'payone-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .btn-wrapper .btn" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_control('btn_bg_color', [
            'label' => __('btn bg Color', 'payone-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .btn-wrapper .btn" => "background-color: {{VALUE}}"
            ]
        ]);
        $this->add_control('btn_hover_color', [
            'label' => __('btn hover Color', 'payone-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .btn-wrapper .btn:hover" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_control('btn_hover_bg_color', [
            'label' => __('btn hover bg Color', 'payone-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .btn-wrapper .btn:hover" => "background-color: {{VALUE}}"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'btn_extra_typography',
            'label' => __('Btn Typography', 'payone-core'),
            'selector' => "{{WRAPPER}} .btn-wrapper .btn"
        ]);
        
        $this->add_control('btn_icon_hover_color', [
            'label' => __('btn Icon hover Color', 'payone-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .btn-wrapper .btn:hover svg" => "fill: {{VALUE}}"
            ]
        ]);
        $this->end_controls_section();
    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $icon_alignment = $settings['icon_alignment'];
    ?>
        <?php if($settings['button_style'] == 'style-1') : ?>
            <div class="btn-wrapper">
                <a class="btn btn-main" href="<?php echo $settings['btn_url'] ?>">
                    <?php echo $settings['btn_text'] ?>
                    <?php if($settings['btn_icon']) : ?>
                        <span class="<?php echo $icon_alignment; ?>">
                            <?php Icons_Manager::render_icon($settings['btn_icon'], ['aria-hidden' => 'true']); ?>
                        </span>
                    <?php endif; ?>
                </a>
            </div>
        <?php elseif($settings['button_style'] == 'style-2') : ?>
            <div class="position-relative d-inline-block"> 
                <a href="<?php echo $settings['btn_url'] ?>" class="our-serbices-item-link fw-semibold tw-text-lg text-center hover-text-dark-600 tw-duration-500">
                    <span class="position-relative zn-2 px-4 text-dark-700 tw-py-205 bg-main-600 w-100 rounded-3 border-two-px-solid"><?php echo $settings['btn_text'] ?></span>
                </a>
            </div>
        <?php elseif($settings['button_style'] == 'style-3') : ?>
            <div class="position-relative d-inline-block"> 
                <a href="<?php echo $settings['btn_url'] ?>" class="platform-two-link fw-semibold tw-text-lg text-center hover-text-dark-600 tw-duration-500">
                    <span class="position-relative zn-2 px-4 text-dark-700 tw-py-205 bg-main-600 w-100 rounded-3 border-two-px-solid"><?php echo $settings['btn_text'] ?></span>
                </a>
            </div>
        <?php endif; ?>

    <?php
    }
}
Plugin::instance()->widgets_manager->register(new Payone_Button_Widget());