<?php
/**
 * Elementor Widget
 * @package Payone
 * @since 1.0.0
 */

namespace Elementor;
class Payone_Breadcrumb_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'payone-breadcrumb-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Breadcrumb', 'payone-core');
    }

    public function get_keywords()
    {
        return ['Section', 'Breadcrumb', 'Title', "HugeBinary", 'Payone'];
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-t-letter';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['payone_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'logo_section',
            [
                'label' => esc_html__('Logo Content', 'payone-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->end_controls_section();
    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $page_id = payone()->page_id();
        $check_page = (!is_home() && !is_front_page() && is_singular()) || is_search() || is_author() || is_404() || is_archive() ? true : false;
        $check_home_page = payone()->is_home_page();
        $header_variant_class = isset($page_header_meta['navbar_type']) ? 'navbar-' . $page_header_meta['navbar_type'] : 'navbar-default';
        $breadcrumb_enable = cs_get_option('breadcrumb_enable');
        ?>
        <?php if(!empty($breadcrumb_enable)){ ?>    
            <?php if (payone()->is_payone_core_active()) : ?>    
                <div class="breadcrumb-wrap breadcrumb-wrap-icon pd-top-100 pd-bottom-120 gt-breadcrumb-wrapper bg-cover gt-breadcrumb-wrap-ele <?php echo esc_attr($header_variant_class); ?>">
            <?php else : ?>     
                <div class="breadcrumb-wrap gt-breadcrumb-wrapper pd-top-100 pd-bottom-120 bg-cover gt-breadcrumb-wrap-ele <?php echo esc_attr($header_variant_class); ?>">
            <?php endif; ?>
                <div class="container">
                    <div class="gt-page-heading"> 
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="breadcrumb-content text-center">
                                    <?php
                                    if (is_archive()) {
                                        if (class_exists('WooCommerce') && is_shop()) {
                                            printf('<h2 class="page-title">%1$s </h2>', str_replace("Archives: ", "", get_the_archive_title()));
                                        } else {
                                            the_archive_title('<h2 class="page-title">', '</h2>');
                                        }
                                    } elseif (is_404()) {
                                        printf('<h2 class="page-title">%1$s</h2>', esc_html__('Error 404', 'payone'));
                                    } elseif (is_search()) {
                                        printf('<h2 class="page-title">%1$s %2$s</h2>', esc_html__('Search Results for:', 'payone'), get_search_query());
                                    } elseif (is_singular('post')) {
                                        printf('<h2 class="page-title">%1$s </h2>', get_the_title());
                                    } elseif (is_singular('page')) {
                                        printf('<h2 class="page-title">%1$s </h2>', get_the_title());
                                    } else {
                                        printf('<h2 class="page-title">%1$s </h2>', get_the_title($page_id));
                                    }
                                    payone_breadcrumb();
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>  
                </div>
            </div> 
        <?php
        }
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Payone_Breadcrumb_Widget());