<?php
/**
 * Elementor Widget
 * @package payone
 * @since 1.0.0
 */

namespace Elementor;
class Payone_Accordion_Tab extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'payone-accordion-tab';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Accordion Tab', 'payone-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-editor-list-ul';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['payone_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {   
        $this->start_controls_section(
            'accordion_tab',
            [
                'label' => esc_html__('accordion tab', 'payone-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'tab1_img', [
                'label' => esc_html__('tab1 img', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'tab1_name', [
                'label' => esc_html__('tab1 name', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('General Questions', 'payone-core')
            ]
        );
        $this->add_control(
            'tab2_img', [
                'label' => esc_html__('tab2 img', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'tab2_name', [
                'label' => esc_html__('tab2 name', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Mobile Banking', 'payone-core')
            ]
        );
        $this->add_control(
            'tab3_img', [
                'label' => esc_html__('tab3 img', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'tab3_name', [
                'label' => esc_html__('tab3 name', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Money Transfer', 'payone-core')
            ]
        );
        $this->add_control(
            'tab4_img', [
                'label' => esc_html__('tab4 img', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'tab4_name', [
                'label' => esc_html__('tab4 name', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Fees and Charges', 'payone-core')
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'tab_1',
            [
                'label' => esc_html__('tab 1', 'payone-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'tab1_title', [
                'label' => esc_html__('Title', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'description' => esc_html__('enter title.', 'payone-core'),
                'default' => esc_html__('What services do you offer?', 'payone-core')
            ]
        );
        $repeater->add_control(
            'tab1_content', [
                'label' => esc_html__('Content Title', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'description' => esc_html__('enter title.', 'payone-core'),
                'default' => esc_html__('To access online and mobile banking, simply log in using your registered email or phone number along with your secure password. You can use our website via any browser or download our mobile app from the App Store or Google Play.', 'payone-core')
            ]
        );
        $this->add_control('tab1_items', [
            'label' => esc_html__('tab1 Item', 'payone-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
        ]);
        $this->end_controls_section();

        $this->start_controls_section(
            'tab_2',
            [
                'label' => esc_html__('tab 2', 'payone-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'tab2_title', [
                'label' => esc_html__('Title', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'description' => esc_html__('enter title.', 'payone-core'),
                'default' => esc_html__('What services do you offer?', 'payone-core')
            ]
        );
        $repeater->add_control(
            'tab2_content', [
                'label' => esc_html__('Content Title', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'description' => esc_html__('enter title.', 'payone-core'),
                'default' => esc_html__('To access online and mobile banking, simply log in using your registered email or phone number along with your secure password. You can use our website via any browser or download our mobile app from the App Store or Google Play.', 'payone-core')
            ]
        );
        $this->add_control('tab2_items', [
            'label' => esc_html__('tab2 Item', 'payone-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
        ]);
        $this->end_controls_section();

        $this->start_controls_section(
            'tab_3',
            [
                'label' => esc_html__('tab 3', 'payone-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'tab3_title', [
                'label' => esc_html__('Title', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'description' => esc_html__('enter title.', 'payone-core'),
                'default' => esc_html__('What services do you offer?', 'payone-core')
            ]
        );
        $repeater->add_control(
            'tab3_content', [
                'label' => esc_html__('Content Title', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'description' => esc_html__('enter title.', 'payone-core'),
                'default' => esc_html__('To access online and mobile banking, simply log in using your registered email or phone number along with your secure password. You can use our website via any browser or download our mobile app from the App Store or Google Play.', 'payone-core')
            ]
        );
        $this->add_control('tab3_items', [
            'label' => esc_html__('tab3 Item', 'payone-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
        ]);
        $this->end_controls_section();

        $this->start_controls_section(
            'tab_4',
            [
                'label' => esc_html__('tab 4', 'payone-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'tab4_title', [
                'label' => esc_html__('Title', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'description' => esc_html__('enter title.', 'payone-core'),
                'default' => esc_html__('What services do you offer?', 'payone-core')
            ]
        );
        $repeater->add_control(
            'tab4_content', [
                'label' => esc_html__('Content Title', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'description' => esc_html__('enter title.', 'payone-core'),
                'default' => esc_html__('To access online and mobile banking, simply log in using your registered email or phone number along with your secure password. You can use our website via any browser or download our mobile app from the App Store or Google Play.', 'payone-core')
            ]
        );
        $this->add_control('tab4_items', [
            'label' => esc_html__('tab4 Item', 'payone-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
        ]);
        $this->end_controls_section();

    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $tab1_items = $settings['tab1_items'];
        $tab2_items = $settings['tab2_items'];
        $tab3_items = $settings['tab3_items'];
        $tab4_items = $settings['tab4_items'];
        ?>

            <div class="overflow-hidden"> 
                <div class="container">
                    <div class="max-w-856 justify-content-center mx-auto">
                        <div class="tw-mb-80-px">
                            <ul class="nav nav-pills nav-faq mb-3 align-items-center tw-gap-6" id="pills-tab-two" role="tablist">
                                <?php if($settings['tab1_name']) : ?>
                                    <li class="nav-item" role="presentation">
                                        <button class="nav-link nav-link-three w-100 tw-px-5 tw-py-6 text-center rounded-3 active"
                                                id="pills-homeeee-tab" data-bs-toggle="pill" data-bs-target="#pills-homeeee"
                                                type="button" role="tab" aria-controls="pills-homeeee" aria-selected="true">
                                            <?php if($settings['tab1_img']['url']) : ?>
                                                <span class="tw-mb-5 group-hover-item-text-invert tw-transition-04-secend d-block">
                                                    <img src="<?php echo $settings['tab1_img']['url']; ?>" alt="Image" class="faq-img">
                                                </span>
                                            <?php endif; ?>
                                            <span class="faq-text fw-medium tw-text-md text-dark-500 group-hover-text-white tw-transition-04-secend d-block">
                                                <?php echo $settings['tab1_name']; ?>
                                            </span>
                                        </button>
                                    </li>
                                <?php endif; ?>
                                <?php if($settings['tab2_name']) : ?>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link nav-link-three w-100 tw-px-5 tw-py-6 text-center rounded-3"
                                            id="pills-mobileeee-tab" data-bs-toggle="pill" data-bs-target="#pills-mobileeee"
                                            type="button" role="tab" aria-controls="pills-mobileeee" aria-selected="false">
                                        <?php if($settings['tab2_img']['url']) : ?>
                                            <span class="tw-mb-5 group-hover-item-text-invert tw-transition-04-secend d-block">
                                                <img src="<?php echo $settings['tab2_img']['url']; ?>" alt="Image" class="faq-img">
                                            </span>
                                        <?php endif; ?>
                                        <span class="faq-text fw-medium tw-text-md text-dark-500 group-hover-text-white tw-transition-04-secend d-block">
                                            <?php echo $settings['tab2_name']; ?> 
                                        </span>
                                    </button>
                                </li>
                                <?php endif; ?>
                                <?php if($settings['tab3_name']) : ?>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link nav-link-three w-100 tw-px-5 tw-py-6 text-center rounded-3"
                                            id="pills-transferrrr-tab" data-bs-toggle="pill" data-bs-target="#pills-transferrrr"
                                            type="button" role="tab" aria-controls="pills-transferrrr" aria-selected="false">
                                        <?php if($settings['tab3_img']['url']) : ?>
                                            <span class="tw-mb-5 group-hover-item-text-invert tw-transition-04-secend d-block">
                                                <img src="<?php echo $settings['tab3_img']['url']; ?>" alt="Image" class="faq-img">
                                            </span>
                                        <?php endif; ?>
                                        <span class="faq-text fw-medium tw-text-md text-dark-500 group-hover-text-white tw-transition-04-secend d-block">
                                            <?php echo $settings['tab3_name']; ?>
                                        </span>
                                    </button>
                                </li>
                                <?php endif; ?>
                                <?php if($settings['tab4_name']) : ?>
                                    <li class="nav-item" role="presentation">
                                        <button class="nav-link nav-link-three w-100 tw-px-5 tw-py-6 text-center rounded-3"
                                                id="pills-feessss-tab" data-bs-toggle="pill" data-bs-target="#pills-feessss"
                                                type="button" role="tab" aria-controls="pills-feessss" aria-selected="false">
                                            <?php if($settings['tab4_img']['url']) : ?>
                                                <span class="tw-mb-5 group-hover-item-text-invert tw-transition-04-secend d-block">
                                                    <img src="<?php echo $settings['tab4_img']['url']; ?>" alt="Image" class="faq-img">
                                                </span>
                                            <?php endif; ?>
                                            <span class="faq-text fw-medium tw-text-md text-dark-500 group-hover-text-white tw-transition-04-secend d-block">
                                                <?php echo $settings['tab4_name']; ?>
                                            </span>
                                        </button>
                                    </li>
                                <?php endif; ?>
                            </ul>
                        </div>
                        <div class="tab-content" id="pills-tabContent-two">
                            <div class="tab-pane fade show active" id="pills-homeeee" role="tabpanel" aria-labelledby="pills-homeeee-tab" tabindex="0">
                                <div class="accordion" id="accordionExample-one">
                                    <?php 
                                        $i = 0;
                                        foreach($tab1_items as $item1) : 
                                        $i++;
                                        if($i < 2) {
                                            $show1 = 'show';
                                        }else {
                                            $show1 = '';
                                        }
                                    ?>
                                    <div class="accordion-item tw-mb-6 rounded-3 bg-neutral-10 border-neutral-1px-solid"  data-aos="fade-up" data-aos-duration="600">
                                        <h2 class="accordion-header cursor-big position-relative z-2">
                                            <button class="accordion-button bg-neutral-10 rounded-3 tw-text-xl tw-gap-1" type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo $i; ?>" aria-expanded="true" aria-controls="collapse<?php echo $i; ?>">
                                                <?php echo $item1['tab1_title']; ?>
                                            </button>
                                        </h2>
                                        <div id="collapse<?php echo $i; ?>" class="accordion-collapse collapse <?php echo $show1; ?>" data-bs-parent="#accordionExample-one">
                                            <div class="accordion-body">
                                                <p class="fw-normal tw-text-md text-dark-600"><?php echo $item1['tab1_content']; ?></p>
                                            </div>
                                        </div>
                                    </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="pills-mobileeee" role="tabpanel" aria-labelledby="pills-mobileeee-tab" tabindex="0">
                                <div class="accordion" id="accordionExample-two">
                                    <?php 
                                        $j = 0;
                                        foreach($tab2_items as $item2) : 
                                        $j++;
                                        if($j < 2) {
                                            $show2 = 'show';
                                        }else {
                                            $show2 = '';
                                        }
                                    ?>
                                    <div class="accordion-item tw-mb-6 rounded-3 bg-neutral-10 border-neutral-1px-solid"  data-aos="fade-up" data-aos-duration="600">
                                        <h2 class="accordion-header cursor-big position-relative z-2">
                                            <button class="accordion-button bg-neutral-10 rounded-3 tw-text-xl tw-gap-1" type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo $j; ?>" aria-expanded="true" aria-controls="collapse<?php echo $j; ?>">
                                                <?php echo $item2['tab2_title']; ?>
                                            </button>
                                        </h2>
                                        <div id="collapse<?php echo $j; ?>" class="accordion-collapse collapse <?php echo $show2; ?>" data-bs-parent="#accordionExample-one">
                                            <div class="accordion-body">
                                                <p class="fw-normal tw-text-md text-dark-600"><?php echo $item2['tab2_content']; ?></p>
                                            </div>
                                        </div>
                                    </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="pills-transferrrr" role="tabpanel" aria-labelledby="pills-transferrrr-tab" tabindex="0">
                                <div class="accordion" id="accordionExample-three">
                                    <?php 
                                        $k = 0;
                                        foreach($tab3_items as $item3) : 
                                        $k++;
                                        if($k < 2) {
                                            $show3 = 'show';
                                        }else {
                                            $show3 = '';
                                        }
                                    ?>
                                    <div class="accordion-item tw-mb-6 rounded-3 bg-neutral-10 border-neutral-1px-solid"  data-aos="fade-up" data-aos-duration="600">
                                        <h2 class="accordion-header cursor-big position-relative z-2">
                                            <button class="accordion-button bg-neutral-10 rounded-3 tw-text-xl tw-gap-1" type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo $k; ?>" aria-expanded="true" aria-controls="collapse<?php echo $k; ?>">
                                                <?php echo $item3['tab3_title']; ?>
                                            </button>
                                        </h2>
                                        <div id="collapse<?php echo $k; ?>" class="accordion-collapse collapse <?php echo $show3; ?>" data-bs-parent="#accordionExample-one">
                                            <div class="accordion-body">
                                                <p class="fw-normal tw-text-md text-dark-600"><?php echo $item3['tab3_content']; ?></p>
                                            </div>
                                        </div>
                                    </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="pills-feessss" role="tabpanel" aria-labelledby="pills-feessss-tab" tabindex="0">
                                <div class="accordion" id="accordionExample-four">
                                    <?php 
                                        $l = 0;
                                        foreach($tab4_items as $item4) : 
                                        $l++;
                                        
                                        if($l < 2) {
                                            $show4 = 'show';
                                        }else {
                                            $show4 = '';
                                        }
                                    ?>
                                    <div class="accordion-item tw-mb-6 rounded-3 bg-neutral-10 border-neutral-1px-solid"  data-aos="fade-up" data-aos-duration="600">
                                        <h2 class="accordion-header cursor-big position-relative z-2">
                                            <button class="accordion-button bg-neutral-10 rounded-3 tw-text-xl tw-gap-1" type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo $l; ?>" aria-expanded="true" aria-controls="collapse<?php echo $l; ?>">
                                                <?php echo $item4['tab4_title']; ?>
                                            </button>
                                        </h2>
                                        <div id="collapse<?php echo $l; ?>" class="accordion-collapse collapse <?php echo $show4; ?>" data-bs-parent="#accordionExample-one">
                                            <div class="accordion-body">
                                                <p class="fw-normal tw-text-md text-dark-600"><?php echo $item4['tab4_content']; ?></p>
                                            </div>
                                        </div>
                                    </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php 
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Payone_Accordion_Tab());