<?php
/**
 * Theme Social Share Widget
 * @package Payone
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
    exit(); //exit if access directly
}
// Control core classes for avoid errors
if (class_exists('CSF')) {


    // Create a About Widget
    CSF::createWidget('payone_social_share_widget', array(
        'title' => esc_html__('Payone: Social Share', 'payone-core'),
        'classname' => 'payone-social-share-about',
        'description' => esc_html__('Display Social Share widget', 'payone-core'),
        'fields' => array(
            array(
                'id' => 'heading',
                'type' => 'text',
                'title' => esc_html__('Enter Your Header Title', 'payone-core'),
                'default' => esc_html__('Never Miss News', 'payone-core')
            ),
            array(
                'id' => 'payone-social-icon-repeater',
                'type' => 'repeater',
                'title' => esc_html__('Social Icon', 'payone-core'),
                'fields' => array(
                    array(
                        'id' => 'payone-social-icon',
                        'type' => 'icon',
                        'title' => esc_html__('Icon', 'payone-core'),
                        'default' => 'fab fa-facebook'
                    ),
                    array(
                        'id' => 'payone-social-text',
                        'type' => 'text',
                        'title' => esc_html__('Enter Your Ulr', 'payone-core'),
                        'default' => '#'
                    ),
                ),
            ),
        )
    ));


    if (!function_exists('payone_social_share_widget')) {
        function payone_social_share_widget($args, $instance)
        {

            echo $args['before_widget'];
            

            $heading_title = $instance['heading'] ?? '';
            $socialIcon = is_array($instance['payone-social-icon-repeater']) && !empty($instance['payone-social-icon-repeater']) ? $instance['payone-social-icon-repeater'] : [];


            ?>
            <div class="social-share-widget">
                <h4 class="widget-headline"><?php echo esc_html($heading_title); ?></h4>
                <ul class="social-icon style-03">
                    <?php
                    foreach ($socialIcon as $icon) {
                        printf('<li><a href="%2$s"><i class="%1$s"></i></a></li>', esc_html($icon['payone-social-icon']), esc_url($icon['payone-social-text']));
                    };
                    ?>
                </ul>
            </div>

            <?php

            echo $args['after_widget'];

        }
    }

}

?>