<?php
/**
 * Theme About Us Widget
 * @package Payone
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
    exit(); //exit if access directly
}
// Control core classes for avoid errors
if (class_exists('CSF')) {


    // Create a About Widget
    CSF::createWidget('payone_about_widget', array(
        'title' => esc_html__('Payone: About Us', 'payone-core'),
        'classname' => 'payone-widget-about',
        'description' => esc_html__('Display about us widget', 'payone-core'),
        'fields' => array(
            array(
                'id' => 'logo-area',
                'type' => 'media',
                'title' => esc_html__('Upload Your Photo', 'payone-core'),
            ),
            array(
                'id' => 'description',
                'type' => 'textarea',
                'title' => esc_html__('Description', 'Payone-core'),
                'default' => esc_html__('Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore.', 'payone-core')
            ),
            array(
                'id' => 'shortcode',
                'type' => 'textarea',
                'title' => esc_html__('Shortcode', 'Payone-core'),
            ),

            array(
                'id' => 'payone-footer-social-icon-repeater',
                'type' => 'repeater',
                'title' => esc_html__('Social Icon', 'payone-core'),
                'fields' => array(

                    array(
                        'id' => 'payone-footer-social-icon',
                        'type' => 'icon',
                        'title' => esc_html__('Icon', 'payone-core'),
                        'default' => 'flaticon-call'
                    ),
                    array(
                        'id' => 'payone-footer-social-text',
                        'type' => 'text',
                        'title' => esc_html__('Enter Your Url', 'payone-core'),
                        'default' => esc_html__('#', 'payone-core')
                    ),

                ),
            ),
        )
    ));


    if (!function_exists('payone_about_widget')) {
        function payone_about_widget($args, $instance)
        {

            echo $args['before_widget'];

            $logo = $instance['logo-area'];
            $img_id = $logo['id'] ?? '';
            $img_print = $img_id ? wp_get_attachment_image_src($img_id,'full')[0] : '';
            $alt_text = get_post_meta($img_id, '_wp_attachment_image_alt', true);
            $paragraph = $instance['description'] ?? '';
            $shortcode = $instance['shortcode'] ?? '';
            $socialIcon = is_array($instance['payone-footer-social-icon-repeater']) && !empty($instance['payone-footer-social-icon-repeater']) ? $instance['payone-footer-social-icon-repeater'] : [];


            ?>
            <div class="footer-widget widget">
                <div class="about_us_widget style-01">
                    <div class="footer-item__logo">  
                        <a href="<?php echo get_home_url(); ?>">
                            <?php
                                if (!empty($img_print)) {
                                    printf('<img src="%1$s" alt="%2$s"/>', esc_url($img_print), esc_attr($alt_text));
                                }
                            ?>  
                        </a>
                    </div>
                    <p class="my-32">
                        <?php echo $paragraph; ?>
                    </p>
                    <?php if (!empty($socialIcon)) { ?>
                        <ul class="social-list flex-align gap-24">
                            <?php
                            foreach ($socialIcon as $icon) {
                                echo '<li class="social-list__item mt-0 mb-0">
                                <div class="icon">
                                    <a class="text-main-600 text-2xl hover-text-main-two-600" href="'.$icon['payone-footer-social-text'].'">
                                        <i class="' . $icon['payone-footer-social-icon'] . '"></i>
                                    </a>
                                </div>
                            </li>';
                            };
                            ?>
                        </ul>
                    <?php } ?>
                </div>
            </div>

            <?php

            echo $args['after_widget'];

        }
    }

}

?>