<?php
/**
 * Theme Core Init
 * @package payone
 * @since 1.0.0
 */

if (!defined("ABSPATH")) {
	exit(); //exit if access directly
}

if (!class_exists('Payone_Core_Init')) {

	class Payone_Core_Init
	{
	   /**
        * $instance
        * @since 1.0.0
        */
		protected static $instance;

		public function __construct()
		{
			//Load plugin assets
			add_action('wp_enqueue_scripts', array($this, 'plugin_assets'));
			//Load plugin admin assets
			add_action('admin_enqueue_scripts', array($this, 'admin_assets'));
			//load plugin text domain
			add_action('init', array($this, 'load_textdomain'));
			//add custom icon to codester framework
			add_filter('csf_field_icon_add_icons', array($this, 'csf_custom_icon'));
			//load plugin dependency files()
            add_action('plugin_loaded', array($this, 'load_plugin_dependency_files'));
			//load codestar
            add_action('after_setup_theme', array($this, 'load_codestar'));
		}

	   /**
        * getInstance()
        * @since 1.0.0
        */
		public static function getInstance()
		{
			if (null == self::$instance) {
				self::$instance = new self();
			}
			return self::$instance;
		}

		/**
		 * Load Plugin Text domain
		 * @since 1.0.0
		 */
		public function load_textdomain()
		{
			load_plugin_textdomain('payone-core', false, PAYONE_CORE_ROOT_PATH . '/languages');
		}

		/**
		 * Load codestar
		 * @since 1.0.0
		 */
		public function load_codestar(){
			if (!class_exists('CSF') ) {
				require_once plugin_dir_path(__FILE__) . '../lib/codestar-framework/codestar-framework.php';
			}
		}

		/**
        * init codestar
        * @since 1.0.0
        */
		public function init_codestar(){
			if (class_exists('CSF') ) {
				CSF::init();
			}
		}

		/**
		 * Load plugin dependency files()
		 * @since 1.0.0
		 */
		public function load_plugin_dependency_files()
		{
			$includes_files = array(
				array(
					'file-name' => 'theme-menu-page',
					'folder-name' => PAYONE_CORE_ADMIN
				),
				array(
					'file-name' => 'theme-custom-post-type',
					'folder-name' => PAYONE_CORE_ADMIN
				),
				array(
					'file-name' => 'theme-post-column-customize',
					'folder-name' => PAYONE_CORE_ADMIN
				),
				array(
					'file-name' => 'theme-payone-core-excerpt',
					'folder-name' => PAYONE_CORE_INC
				),
				array(
					'file-name' => 'csf-taxonomy',
					'folder-name' => PAYONE_CORE_INC
				),
				array(
					'file-name' => 'theme-core-shortcodes',
					'folder-name' => PAYONE_CORE_INC
				),
				array(
					'file-name' => 'elementor-widget-init',
					'folder-name' => PAYONE_CORE_ELEMENTOR
				),
                array(
                    'file-name' => 'theme-social-share-widget',
                    'folder-name' => PAYONE_CORE_WP_WIDGETS
                ),
                array(
                    'file-name' => 'theme-about-me-widget',
                    'folder-name' => PAYONE_CORE_WP_WIDGETS
                ),
                array(
                    'file-name' => 'theme-about-us-widget',
                    'folder-name' => PAYONE_CORE_WP_WIDGETS
                ),
                array(
                    'file-name' => 'theme-post-search-widget',
                    'folder-name' => PAYONE_CORE_WP_WIDGETS
                ),
                array(
                    'file-name' => 'theme-post-tags-menu',
                    'folder-name' => PAYONE_CORE_WP_WIDGETS
                ),
				array(
					'file-name' => 'theme-recent-post-widget',
					'folder-name' => PAYONE_CORE_WP_WIDGETS
				),
				array(
					'file-name' => 'theme-recent-post-title-widget',
					'folder-name' => PAYONE_CORE_WP_WIDGETS
				),
				array(
					'file-name' => 'theme-contact-info-widget',
					'folder-name' => PAYONE_CORE_WP_WIDGETS
				),
                array(
                    'file-name' => 'theme-service-category-widget',
                    'folder-name' => PAYONE_CORE_WP_WIDGETS
                ),
                array(
                    'file-name' => 'theme-request-form-widget',
                    'folder-name' => PAYONE_CORE_WP_WIDGETS
                ),
                array(
                    'file-name' => 'theme-post-category-widget',
                    'folder-name' => PAYONE_CORE_WP_WIDGETS
                ),
                array(
                    'file-name' => 'theme-discover-company-widget',
                    'folder-name' => PAYONE_CORE_WP_WIDGETS
                ),
                array(
                    'file-name' => 'theme-file-download-widget',
                    'folder-name' => PAYONE_CORE_WP_WIDGETS
                ),
                array(
                    'file-name' => 'theme-author-widget',
                    'folder-name' => PAYONE_CORE_WP_WIDGETS
                ),
				array(
					'file-name' => 'theme-demo-data-import',
					'folder-name' => PAYONE_CORE_DEMO_IMPORT
				),
			);

            if (defined('ELEMENTOR_VERSION')) {
                $includes_files[] = array(
                    'file-name' => 'theme-elementor-icon-manager',
                    'folder-name' => PAYONE_CORE_INC
                );
            }
			if (is_array($includes_files) && !empty($includes_files)) {
				foreach ($includes_files as $file) {
					if (file_exists($file['folder-name'] . '/' . $file['file-name'] . '.php')) {
						require_once $file['folder-name'] . '/' . $file['file-name'] . '.php';
					}
				}
			}
		}

		/**
		 * Admin assets
		 * @since 1.0.0
		 */
		public function plugin_assets()
		{
			self::load_plugin_css_files();
			self::load_plugin_js_files();
		}

		/**
		 * Load plugin css files()
		 * @since 1.0.0
		 */
		public function load_plugin_css_files()
		{
			$plugin_version = PAYONE_CORE_VERSION;
			$all_css_files = array(
                array(
                    'handle' => 'font-awesome',
                    'src' => PAYONE_CORE_CSS . '/font-awesome.min.css',
                    'deps' => array(),
                    'ver' => '5.15.4',
                    'media' => 'all',
                ),
                array(
                    'handle' => 'nice-select',
                    'src' => PAYONE_CORE_CSS . '/nice-select.css',
                    'deps' => array(),
                    'ver' => $plugin_version,
                    'media' => 'all'
                ),
                array(
                    'handle' => 'swiper-bundle',
                    'src' => PAYONE_CORE_CSS . '/swiper-bundle.min.css',
                    'deps' => array(),
                    'ver' => $plugin_version,
                    'media' => 'all'
                ),
				array(
					'handle' => 'payone-core-main-style',
					'src' => PAYONE_CORE_CSS . '/main-style.css',
					'deps' => array(),
					'ver' => $plugin_version,
					'media' => 'all'
				)
			);
			
			if (!payone_core()->is_payone_active()) {
				$all_css_files[] = array(
					'handle' => 'payone-main-style',
					'src' => PAYONE_CORE_CSS . '/theme-style.css',
					'deps' => array(),
					'ver' => $plugin_version,
					'media' => 'all'
				);
				$all_css_files[] = array(
					'handle' => 'payone-responsive',
					'src' => PAYONE_CORE_CSS . '/theme-responsive.css',
					'deps' => array(),
					'ver' => $plugin_version,
					'media' => 'all'
				);
			}
			$all_css_files = apply_filters('payone_core_css', $all_css_files);

			if (is_array($all_css_files) && !empty($all_css_files)) {
				foreach ($all_css_files as $css) {
					call_user_func_array('wp_enqueue_style', $css);
				}
			}
		}

		/**
		 * Load plugin js
		 * @since 1.0.0
		 */
		public function load_plugin_js_files()
		{
			// all js files
            wp_enqueue_script( 'phosphor', PAYONE_CORE_JS . '/phosphor-icon.js', array('jquery'), '1.0.6', true );
            wp_enqueue_script( 'gsap', PAYONE_CORE_JS . '/gsap.min.js', array('jquery'), '1.0.6', true );
            wp_enqueue_script( 'SplitText', PAYONE_CORE_JS . '/SplitText.min.js', array('jquery'), '1.0.6', true );
            wp_enqueue_script( 'swiper', PAYONE_CORE_JS . '/swiper-bundle.min.js', array('jquery'), '1.0.2', true );
            wp_enqueue_script( 'marquee', PAYONE_CORE_JS . '/marquee-main.js', array('jquery'), '1.0.2', true );
            wp_enqueue_script( 'scrollTrigger', PAYONE_CORE_JS . '/ScrollTrigger.min.js', array('jquery'), '1.0.2', true );
            wp_enqueue_script( 'scrollSmoother', PAYONE_CORE_JS . '/ScrollSmoother.min.js', array('jquery'), '1.0.2', true );
            wp_enqueue_script( 'aos', PAYONE_CORE_JS . '/aos-animation.js', array('jquery'), '1.0.2', true );
			wp_enqueue_script( 'counter', PAYONE_CORE_JS . '/counterup.min.js', array('jquery'), '11.1.14', true );
            wp_enqueue_script( 'custom-gsap', PAYONE_CORE_JS . '/custom-gsap.js', array('jquery'), '1.0.6', true );
            wp_enqueue_script( 'payone-core-main-script', PAYONE_CORE_JS . '/main.js', array('jquery'), time(), true );
		}

		/**
		 * Admin assets
		 * @since 1.0.0
		 */
		public function admin_assets()
		{
			self::load_admin_css_files();
			self::load_admin_js_files();
		}

		/**
		 * Load plugin admin css files()
		 * @since 1.0.0
		 */
		public function load_admin_css_files()
		{
			$plugin_version = PAYONE_CORE_VERSION;
			$all_css_files = array(
				array(
					'handle' => 'payone-core-admin-style',
					'src' => PAYONE_CORE_ADMIN_ASSETS . '/css/admin.css',
					'deps' => array(),
					'ver' => $plugin_version,
					'media' => 'all'
				),
				array(
					'handle' => 'flaticon',
					'src' => PAYONE_CORE_CSS . '/flaticon.css',
					'deps' => array(),
					'ver' => $plugin_version,
					'media' => 'all'
				),
			);

			$all_css_files = apply_filters('payone_admin_css', $all_css_files);
			if (is_array($all_css_files) && !empty($all_css_files)) {
				foreach ($all_css_files as $css) {
					call_user_func_array('wp_enqueue_style', $css);
				}
			}
		}

		/**
		 * Load plugin admin js
		 * @since 1.0.0
		 */
		public function load_admin_js_files()
		{
			wp_enqueue_script( 'payone-core-widget', PAYONE_CORE_ADMIN_ASSETS . '/js/widget.js', array('jquery'), '1.0.6', true );
		}

		/**
		 * Add Custom Icon To Codester Framework
		 * @since 1.0.0
		 */
		public function csf_custom_icon($icons)
		{
			//adding new icon
			$icons[]  = array(
				'title' => esc_html__('Flaticon', 'payone-core'),
				'icons' => array(
					'flaticon-right-arrow',
					'flaticon-running',
					'flaticon-stationery-bicycle',
					'flaticon-boxing-gloves',
					'flaticon-kickboxing',
					'flaticon-right-arrow-1',
					'flaticon-share',
					'flaticon-facebook',
					'flaticon-twitter',
					'flaticon-google-plus',
					'flaticon-instagram',
					'flaticon-consultation',
					'flaticon-customer',
					'flaticon-trainer',
					'flaticon-team',
					'flaticon-straight-quotes',
					'flaticon-star',
					'flaticon-telephone-call',
					'flaticon-volume',
					'flaticon-qualified',
					'flaticon-fit',
					'flaticon-fighting',
					'flaticon-karate',
					'flaticon-judo',
					'flaticon-kickboxing-1',
					'flaticon-karate-1',
					'flaticon-wrestling',
					'flaticon-karate-2',
					'flaticon-karate-3',
					'flaticon-taekwondo',
					'flaticon-check',
					'flaticon-email',
					'flaticon-badge',
					'flaticon-placeholder',
					'flaticon-boxing',
					'flaticon-boxing-1',
					'flaticon-boxing-2',
					'flaticon-location',
					'flaticon-phone-call',
					'flaticon-quote',
					'flaticon-good-shape',
					'flaticon-man',
					'flaticon-fitness',
					'flaticon-star-1',
					'flaticon-whistle',
					'flaticon-boxing-glove',
					'flaticon-magnifying-glass',
					'flaticon-mission',
					'flaticon-focus',
					'flaticon-mission-1',
					'flaticon-arroba',
					'flaticon-clock-circular-outline',
					'flaticon-calendar',
					'flaticon-stopwatch',
					'flaticon-maps-and-flags',
					'flaticon-slim-down',
					'flaticon-heart',
					'flaticon-flag',
					'flaticon-document',
					'flaticon-expand',
					'flaticon-red-eye',
					'flaticon-group',
					'flaticon-writing',
					'flaticon-id-card',
					'flaticon-calendar-1',
					'flaticon-calendar-2',
					'flaticon-right-arrow-2',
					'flaticon-right-arrows',
					'flaticon-next',
					'flaticon-next-1',
					'flaticon-right-arrow-3',
					'flaticon-arrow',
					'flaticon-left-arrow',
					'flaticon-arrow-1',
					'flaticon-youtube'
				)
			);

			$icons = array_reverse($icons);

			return $icons;
		}
	} //end class
	if (class_exists('Payone_Core_Init')) {
		Payone_Core_Init::getInstance();
	}
}
