<?php
/**
 * Elementor Widget
 * @package Payone
 * @since 1.0.0
 */

namespace Elementor;
class Payone_Work_Process_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
    */
    public function get_name()
    {
        return 'payone-work-process-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Work Process', 'payone-core');
    }

    public function get_keywords()
    {
        return ['Section', 'work process', 'Title', 'Payone'];
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-editor-list-ol';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['payone_widgets'];
    }

    
    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'working_section',
            [
                'label' => esc_html__('Content Settings', 'payone-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'subtitle',
            [
                'label' => esc_html__('Sub Title', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Safe Transportation & Logistics', 'payone-core'),
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__('Section Title', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Introducing The most Modern way of Transportation', 'payone-core'),
            ]
        );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'icon_class', [
                'label' => esc_html__('icon class', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('ph-fill ph-user-circle', 'payone-core'),
            ]
        );
        $repeater->add_control(
            'work_step',
            [
                'label' => esc_html__('STEP', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('STEP_01', 'payone-core'),
            ]
        );
        $repeater->add_control(
            'work_title',
            [
                'label' => esc_html__('Work Title', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Create an Account', 'payone-core'),
            ]
        );
        $repeater->add_control(
            'work_content',
            [
                'label' => esc_html__('Content', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Sign up with your email or phone number. Complete a quick verification to secure your account.', 'payone-core'),
            ]
        );
        $this->add_control('work_items', [
            'label' => esc_html__('Work Item', 'payone-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
        ]);
        $this->add_control(
            'animate_img_1', [
                'label' => esc_html__('Plane Image', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'animate_img_2', [
                'label' => esc_html__('Biman Line Shape', 'payone-core'),
                'type' => Controls_Manager::MEDIA,

            ]
        );
        $this->end_controls_section();

        //Style tab style
        $this->start_controls_section(
            'style_settings_section',
            [
                'label' => esc_html__('Style Settings', 'payone-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->end_controls_section();
    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $work_items = $settings['work_items'];
        ?>

        <div class="overflow-hidden">
            <div class="container">
                <div class="max-w-856 mx-auto justify-content-center overflow-hidden">
                    <div class="working-process-area position-relative overflow-hidden">
                        <span class="fast-safe border-neutral-100 position-absolute top-0 start-50 w-05 h-100  d-lg-block d-none"></span>
                        <?php 
                            $number = 0;
                            foreach($work_items as $items) : 
                            $number++;
                        ?>
                            <?php if ($number % 2 == 0) { ?>
                                <div class="working-process max-w-580 d-flex align-items-center tw-gap-16 text-end pb-120 flex-wrap" data-aos="fade-up" data-aos-duration="1000">
                                    <div class="max-w-400 tw-px-10 working-process__text">
                                        <span class="fw-bold tw-text-lg text-primary-600 tw-mb-3"><?php echo $items['work_step']; ?></span>
                                        <h4 class="fw-normal tw-mb-3 cursor-big"><?php echo $items['work_title']; ?></h4>
                                        <p class="fw-normal tw-text-lg text-dark-500"><?php echo $items['work_content']; ?></p>
                                    </div>
                                    <span class="payment-method tw-w-100px tw-h-100-px bg-base-two-10 tw-text-15 rounded-circle d-flex align-items-center justify-content-center text-base-two-600 flex-shrink-0"> 
                                        <i class="<?php echo $items['icon_class']; ?>"></i>
                                    </span>
                                </div>
                            <?php } else { ?>
                                <div class="working-process max-w-580 d-flex align-items-center tw-gap-16 tw-ms-auto pb-120 flex-wrap" data-aos="fade-up" data-aos-duration="1000">
                                    <span class="tw-w-100px tw-h-100-px bg-base-two-10 tw-text-15 rounded-circle d-flex align-items-center justify-content-center text-base-two-600 flex-shrink-0"> 
                                        <i class="<?php echo $items['icon_class']; ?>"></i>
                                    </span>
                                    <div class="max-w-400 tw-px-10">
                                        <span class="fw-bold tw-text-lg text-primary-600 tw-mb-3"><?php echo $items['work_step']; ?> </span>
                                        <h4 class="fw-normal tw-mb-3 cursor-big"><?php echo $items['work_title']; ?></h4>
                                        <p class="fw-normal tw-text-lg text-dark-500"><?php echo $items['work_content']; ?></p>
                                    </div>
                                </div>
                            <?php } ?>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        </div>

        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Payone_Work_Process_Widget());