<?php
/**
 * Elementor Widget
 * @package Payone
 * @since 1.0.0
 */

namespace Elementor;
class Payone_Whychoose_Us_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'payone-theme-whychoose-us-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Whychoose Us', 'payone-core');
    }

    public function get_keywords()
    {
        return ['why', 'whychoose', 'choose', "HugeBinary", 'Payone'];
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-heading';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['payone_widgets'];
    }

    
    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'whychoose_one_content_settings_section',
            [
                'label' => esc_html__('Left Content', 'payone-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'whychoose_subtitle',
            [
                'label' => esc_html__('Sub Title', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Why Choose Us', 'payone-core'),
            ]
        );
        $this->add_control(
            'whychoose_title',
            [
                'label' => esc_html__('Title', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Our Commitment to Excellence, Learn, Grow & Success.', 'payone-core'),
            ]
        );       
        $this->add_control(
            'whychoose_description',
            [
                'label' => esc_html__('Description', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'description' => esc_html__('enter  description.', 'payone-core'),
                'default' => esc_html__('We are passionate about transforming lives through education. Founded with a vision to make learning accessible to all, we believe in the power of knowledge to', 'payone-core'),
            ]
        );

        $repeater = new \Elementor\Repeater();
        
        $repeater->add_control(
            'whychoose_list', [
                'label' => esc_html__('List Item', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'description' => esc_html__('Enter List Text', 'payone-core'),
                'default' => esc_html__('9/10 Average Satisfaction Rate', 'payone-core')
            ]
        );
        $this->add_control('whychoose_list_items', [
            'label' => esc_html__('Why Choose Us Item', 'payone-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
        ]);
        $this->add_control(
            'show_button',
            [
                'label' => __( 'Show Button', 'payone-core' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'payone-core' ),
                'label_off' => __( 'Hide', 'payone-core' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'button_text',
            [
                'label' => __( 'Button Text', 'payone-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => __( 'Read More', 'payone-core' ),
                'label_block' => true,
                'default' => __( 'Read More', 'payone-core' ),
            ]
        );
        $this->add_control(
            'button_url',
            [
                'label' => __( 'Button Link', 'payone-core' ),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __( 'Enter Your Link Here', 'payone-core' ),
            ]
        );
        $this->add_control(
            'button_icon',
            [
                'label' => __( 'Button Icon', 'payone-core' ),
                'type' => \Elementor\Controls_Manager::ICONS,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'whychoose_one_content_settings_right',
            [
                'label' => esc_html__('Right Content', 'payone-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'whychoose_right_image1', [
                'label' => esc_html__('Right Main Image1', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
                'default' => array(
                    'url' => Utils::get_placeholder_image_src()
                ),
            ]
        );
        $this->add_control(
            'whychoose_right_image2', [
                'label' => esc_html__('Right Main Image2', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
                'default' => array(
                    'url' => Utils::get_placeholder_image_src()
                ),
            ]
        );
        $this->add_control(
            'whychoose_book_shape', [
                'label' => esc_html__('Book shape', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
                'default' => array(
                    'url' => Utils::get_placeholder_image_src()
                ),
            ]
        );
        $this->add_control(
            'whychoose_count_number',
            [
                'label' => esc_html__('Count Number', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('36k+', 'payone-core'),
            ]
        );
        $this->add_control(
            'whychoose_count_title',
            [
                'label' => esc_html__('Count Title', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Enrolled Students', 'payone-core'),
            ]
        );
        $this->add_control(
            'whychoose_right_count_image', [
                'label' => esc_html__('Count Images', 'payone-core'),
                'type' => Controls_Manager::GALLERY,
                'default' => [],
            ]
        );
        $this->add_control(
            'icon_img_1', [
                'label' => esc_html__('Icon Image', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
                'default' => array(
                    'url' => Utils::get_placeholder_image_src()
                ),
            ]
        );
        $this->add_control(
            'review_text',
            [
                'label' => esc_html__('review Text', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('4.6', 'payone-core'),
            ]
        );
        $this->add_control(
            'client_text',
            [
                'label' => esc_html__('Client Text', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('(2.4k)', 'payone-core'),
            ]
        );
        $this->add_control(
            'review_title',
            [
                'label' => esc_html__('review Title', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('AVG Reviews', 'payone-core'),
            ]
        );
        $this->add_control(
            'video_link',
            [
                'label' => esc_html__('Video Link', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('https://www.youtube.com/watch?v=e5Hc2B50Z7c', 'payone-core'),
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'whychoose_one_content_settings_animation',
            [
                'label' => esc_html__('Animation Shape', 'payone-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'animate_img_1', [
                'label' => esc_html__('animate Dot1', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'animate_img_2', [
                'label' => esc_html__('animate Dot2', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
            ]
        );

        $this->end_controls_section();

        //Style tab style
        $this->start_controls_section(
            'style_settings_section',
            [
                'label' => esc_html__('Style Settings', 'payone-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control('whychoose_bg_color', [
            'label' => esc_html__('whychoose bg Color', 'payone-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .choose-us" => "background-color: {{VALUE}}"
            ]
        ]);
        $this->add_responsive_control(
            'whychoose_padding',
            [
                'label' => __('whychoose padding', 'payone-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .choose-us' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control('subtitle_color', [
            'label' => esc_html__('subtitle Color', 'payone-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .flex-align .text-main-600" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_control('title_color', [
            'label' => esc_html__('Title Color', 'payone-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .whychoose-content h1" => "color: {{VALUE}}"
            ]
        ]);

        $this->end_controls_section();
    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $whychoose_list_items = $settings['whychoose_list_items'];
        ?>

        <div class="choose-us pt-120 position-relative z-1 mash-bg-main mash-bg-main-two">
            <?php if($settings['animate_img_1']['url']) : ?>
                <img src="<?php echo $settings['animate_img_2']['url']; ?>" alt="img" class="shape one animation-scalation">
            <?php endif; ?>
            <?php if($settings['animate_img_2']['url']) : ?>
                <img src="<?php echo $settings['animate_img_2']['url']; ?>" alt="img" class="shape six animation-scalation">
            <?php endif; ?>
            <div class="container">
                <div class="row gy-4">
                    <div class="col-lg-6">
                        <div class="choose-us__content">
                            <div class="mb-40">
                                <div class="flex-align gap-8 mb-16 wow bounceInDown">
                                    <?php if($settings['whychoose_subtitle']) : ?>
                                        <span class="w-8 h-8 bg-main-600 rounded-circle"></span>
                                        <h5 class="text-main-600 mb-0"><?php echo $settings['whychoose_subtitle']; ?></h5>
                                    <?php endif; ?>
                                </div>
                                <?php if($settings['whychoose_title']) : ?>
                                        <h2 class="mb-24  wow bounceIn">
                                            <?php echo $settings['whychoose_title'];?>
                                        </h2>
                                    <?php endif; ?>
                                <?php if($settings['whychoose_description']) : ?>
                                    <p class="text-neutral-500 text-line-2  wow bounceInUp"><?php echo $settings['whychoose_description']; ?></p>
                                <?php endif; ?>
                            </div>
                            <ul>
                                <?php foreach ($whychoose_list_items as $item): ?>
                                    <li class="flex-align gap-12 mb-16" data-aos="fade-up-left"  data-aos-duration="200">
                                        <span class="flex-shrink-0 text-xl text-main-600 d-flex"><i class="ph-bold ph-checks"></i></span>
                                        <span class="flex-grow-1 text-neutral-500"><?php echo $item['whychoose_list']; ?></span>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                            <div class="pt-24 border-top border-neutral-50 mt-28 border-dashed border-0">
                                <?php if( 'yes'===$settings['show_button'] ){ ?>
                                    <a href="<?php echo esc_url($settings['button_url']['url']); ?>" class="btn btn-main rounded-pill flex-align d-inline-flex gap-8">
                                        <?php echo $settings['button_text']; ?>
                                        <?php \Elementor\Icons_Manager::render_icon( $settings['button_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                    </a>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6 order-lg-0 order-1">
                        <div class="choose-us__thumbs position-relative">
                            <div class="offer-message style-two px-24 py-12 rounded-12 bg-white fw-medium flex-align d-inline-flex gap-16 box-shadow-lg animation-upDown">
                                <span class="flex-shrink-0 w-48 h-48 bg-dark-yellow text-white text-2xl flex-center rounded-circle">
                                    <?php if($settings['icon_img_1']['url']) : ?>
                                        <img src="<?php echo $settings['icon_img_1']['url']; ?>" alt="img">
                                    <?php endif; ?>
                                </span>
                                <div>
                                    <span class="text-lg text-neutral-700 d-block">
                                        <?php if($settings['review_text']) : ?>
                                            <?php echo $settings['review_text']; ?>
                                        <?php endif; ?>
                                        <span class="text-neutral-100">
                                        <?php if($settings['client_text']) : ?>
                                            <?php echo $settings['client_text']; ?>
                                        <?php endif; ?>
                                        </span>
                                    </span>
                                    <span class="text-neutral-500">
                                        <?php if($settings['review_title']) : ?>
                                            <?php echo $settings['review_title']; ?>
                                        <?php endif; ?>
                                    </span>
                                </div>
                            </div>
                            <div class="banner-box one style-two px-24 py-12 rounded-12 bg-white fw-medium box-shadow-lg d-inline-block" data-aos="fade-left">
                                <?php if($settings['whychoose_count_number']) : ?>
                                    <span class="text-main-600"><?php echo $settings['whychoose_count_number']; ?></span>
                                <?php endif; ?>
                                <?php if($settings['whychoose_count_title']) : ?>
                                    <?php echo $settings['whychoose_count_title']; ?>
                                <?php endif; ?>
                                <div class="enrolled-students mt-12">
                                    <?php if (!empty($settings['whychoose_right_count_image'])) : ?>
                                        <?php foreach ($settings['whychoose_right_count_image'] as $image) : ?>
                                            <img src="<?php echo esc_url($image['url']); ?>" alt="Gallery Image" class="w-48 h-48 rounded-circle object-fit-cover">
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="text-end" data-aos="zoom-out">
                                <div class="d-sm-inline-block d-block position-relative">
                                    <?php if($settings['whychoose_right_image1']['url']) : ?>
                                        <img src="<?php echo $settings['whychoose_right_image1']['url']; ?>" alt="img" class="choose-us__img rounded-12" data-tilt data-tilt-max="16" data-tilt-speed="500" data-tilt-perspective="5000" data-tilt-full-page-listening>
                                    <?php endif; ?>
                                    <span class="shadow-main-two w-80 h-80 flex-center bg-main-two-600 rounded-circle position-absolute inset-block-start-0 inset-inline-start-0 mt-40 ms--40 animation-upDown">
                                    <?php if($settings['whychoose_right_image2']['url']) : ?>
                                        <img src="<?php echo $settings['whychoose_book_shape']['url']; ?>" alt="img">
                                    <?php endif; ?>
                                    </span>
                                </div>
                            </div>
                            <div class="animation-video"  data-aos="zoom-in">
                                <?php if($settings['whychoose_right_image2']['url']) : ?>
                                    <img src="<?php echo $settings['whychoose_right_image2']['url']; ?>" alt="img" class="border border-white rounded-circle border-3" data-tilt>
                                <?php endif; ?>
                                <?php if($settings['video_link']) : ?>
                                    <a href="<?php echo $settings['video_link']; ?>" class="popup-video-link video-popup__button play-button w-48 h-48 flex-center bg-main-600 text-white rounded-circle text-xl position-absolute top-50 start-50 translate-middle">
                                    <i class="ph-fill ph-play"></i>
                                    <?php endif; ?>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Payone_Whychoose_Us_Widget());