<?php
/**
 * Elementor Widget
 * @package payone
 * @since 1.0.0
 */

namespace Elementor;

class Payone_Why_Payone_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'payone-why-payone';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Why Payone', 'payone-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-slides';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['payone_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content Settings', 'payone-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'main_title',
            [
                'label' => esc_html__('Main Title', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('WHY PAYONE', 'payone-core'),
            ]
        );
        $this->add_control(
            'main_content', [
                'label' => esc_html__('main content', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('PayOne is constantly growing for a World without high fees.', 'payone-core'),
            ]
        );

        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'box_img', [
                'label' => esc_html__('Box img', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
                'description' => esc_html__('Box Img', 'payone-core'),
                'default' => array(
                    'url' => Utils::get_placeholder_image_src()
                )
            ]
        );
        $repeater->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('One Contract, One Integration', 'payone-core'),
            ]
        );
        $repeater->add_control(
            'content', [
                'label' => esc_html__('content', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__("Don't get lost in papers! Easy registration, rapid integration!", 'payone-core'),
            ]
        );
        $this->add_control('choose_items', [
            'label' => esc_html__('choose Item', 'payone-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'image' => array(
                        'url' => Utils::get_placeholder_image_src()
                    )
                ]
            ],
        ]);
        $this->end_controls_section();

        $this->start_controls_section(
            'banner_styling_settings_section',
            [
                'label' => esc_html__('Styling Settings', 'payone-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->end_controls_section();

    }


    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display(); 
        $choose_items = $settings['choose_items'];
        ?>

        <div class="z-1 bg-neutral-10 py-120 position-relative overflow-hidden">
            <div class="container">
                <?php if($settings['main_title'] || $settings['main_content']) : ?>
                    <div class="paynone-item margin-block-start-60px">
                        <div class="text-center justify-content-center align-items-center">
                            <?php if($settings['main_title']) : ?>
                                <h2 class="paynone-title tw-text-80-px fw-normal text-dark-600 tw-mb-3 cursor-big" data-aos="fade-up" data-aos-duration="800">
                                    <?php echo $settings['main_title']; ?>
                                </h2>
                            <?php endif; ?>
                            <?php if($settings['main_content']) : ?>
                                <p class="max-w-322 text-dark-500 tw-text-lg fw-normal mx-auto" data-aos="fade-up" data-aos-duration="1000">
                                    <?php echo $settings['main_content']; ?>
                                </p>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endif; ?>
                <div class="row gy-4">
                    <?php 
                        $position = array('paynone-card-one bg-warning-500 margin-block-start--120px', 'paynone-card-two bg-base-two-600 margin-block-start-200px', 'paynone-card-three bg-base-two-600 margin-block-start--200px margin-inline-start-100px', 'paynone-card-four bg-warning-500 margin-block-start-70px', 'paynone-card-five bg-base-two-600 margin-inline-start-107px margin-block-start-176px', 'paynone-card-six bg-warning-500 margin-inline-start-100px margin-block-start--200px');
                        $i = -1;
                        foreach($choose_items as $choose_item) : 
                        $i++;
                    ?>
                    <div class="col-xl-4 col-lg-4 col-md-6">
                        <div class="<?php echo $position[$i]; ?> max-w-307 payone-card tw-px-8 py-80 rounded-4" data-aos="fade-up" data-aos-duration="800">
                            <div class="max-w-246 text-center justify-content-center align-items-center mx-auto">
                                <?php if($choose_item['box_img']['url']) : ?>
                                    <img src="<?php echo $choose_item['box_img']['url']; ?>" alt="Image" class="tw-text-80-px tw-mb-8">
                                <?php endif; ?>
                                <?php if($choose_item['title']) : ?>
                                    <h4 class="fw-normal tw-mb-6 cursor-big"><?php echo $choose_item['title']; ?></h4>
                                <?php endif; ?>
                                <?php if($choose_item['content']) : ?>
                                    <p class="fw-normal tw-text-lg mb-0"><?php echo $choose_item['content']; ?></p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>

            </div> 
        </div>

        <?php
    }
}
Plugin::instance()->widgets_manager->register_widget_type(new Payone_Why_Payone_Widget());