<?php
/**
 * Elementor Widget
 * @package Payone
 * @since 1.0.0
 */

namespace Elementor;
class Payone_Video_Box_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'payone-video-box-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Video Box', 'payone-core');
    }

    public function get_keywords()
    {
        return ['box', 'Video', 'Title', 'payone-core'];
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-video-playlist';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['payone_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('Video Box Content', 'payone-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'image', [
                'label' => esc_html__('Video BG Image', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('Video BG Image', 'payone-core'),
            ]
        );
        $this->add_control(
            'video_link',
            [
                'label' => esc_html__('Video Link', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('https://www.youtube.com/watch?v=KEFt2quibkg', 'payone-core'),
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'styling_section',
            [
                'label' => esc_html__('Styling Settings', 'payone-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control('title_color', [
            'label' => esc_html__('Title Color', 'payone-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} h2" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('title Typography', 'payone-core'),
            'name' => 'title_typography',
            'description' => esc_html__('title typography', 'payone-core'),
            'selector' => "{{WRAPPER}} h2"
        ]);

        $this->end_controls_section();
        
    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>

            <div class="lg-w-45 w-100 position-relative tw-max-h-778-p">
                <?php if($settings['image']) : ?>
                    <img src="<?php echo $settings['image']['url']; ?>" alt="" class="w-100 h-100 object-fit-cover">
                <?php endif; ?>
                <a href="<?php echo $settings['video_link']; ?>" class="play-button bg-light-animation tw-w-80-px tw-h-80-px d-inline-flex justify-content-center align-items-center bg-white text-base-two-600 hover-text-base-two-600 rounded-circle tw-text-xl position-absolute tw-start-50 tw--translate-middle top-50 z-1">
                    <i class="ph-fill ph-play"></i>
                </a>
            </div>
        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Payone_Video_Box_Widget());