<?php
/**
 * Elementor Widget
 * @package payone
 * @since 1.0.0
 */

namespace Elementor;

class Payone_Testimonial_Slider_One_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'payone-testimonial-slider-one';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Testimonial Slider One', 'payone-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-slides';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['payone_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'slider_settings_section',
            [
                'label' => esc_html__('Slider Content', 'payone-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control('testimonial_style', [
            'label' => esc_html__('testimonial style', 'payone-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'style-1' => esc_html__('Style 1', 'payone-core'),
                'style-2' => esc_html__('style-2', 'payone-core'),
            ),
            'default' => 'style-1',
            'description' => esc_html__('Select testimonial Style', 'payone-core')
        ]);

        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'testi_image', [
                'label' => esc_html__('Testimonial Bus Image', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('Testimonial Bus Image', 'payone-core'),
            ]
        );
        $repeater->add_control(
            'name', [
                'label' => esc_html__('Name', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Robert J. Hare', 'payone-core'),
            ]
        );
        $repeater->add_control(
            'designation', [
                'label' => esc_html__('Designation', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Sr. Product Manager', 'payone-core'),
            ]
        );
        $repeater->add_control(
            'testi_quate', [
                'label' => esc_html__('Testimonial Quate Image', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('Upload Image', 'payone-core'),
            ]
        );
        $repeater->add_control(
            'content', [
                'label' => esc_html__('Content', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'show_label' => false,
                'default' => esc_html__('Our customers love the seamless, Reliable service,  and 24/7 support make transferring money  Trust us for your global payment needs!', 'payone-core'),
            ]
        );
        $repeater->add_control(
            'rating_title', [
                'label' => esc_html__('Rating title', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('4.5 - Excellent', 'payone-core'),
            ]
        );
        $repeater->add_control(
            'rating', [
                'label' => esc_html__('Rating', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('5', 'payone-core'),
            ]
        );
        $this->add_control('testimonial_items', [
            'label' => esc_html__('Testimonial Slider Item', 'payone-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'image' => array(
                        'url' => Utils::get_placeholder_image_src()
                    )
                ]
            ],
        ]);
        $this->end_controls_section();

        $this->start_controls_section(
            'slider_control_section',
            [
                'label' => esc_html__('Slider Settings', 'payone-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->end_controls_section();

    }


    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $all_testimonial_items = $settings['testimonial_items'];

        echo '
            <script>
                jQuery(document).ready(function($) {
                    var swiper = new Swiper(".testimonial-slider", {
                        slidesPerView: 3,
                        loop: true,
                        spaceBetween: 20,
                        navigation: {
                            nextEl: ".testimonial-button-next",
                            prevEl: ".testimonial-button-prev",
                        },
                        breakpoints: {
                            0: {
                            slidesPerView: 1, // Mobile default
                            },
                            640: {
                            slidesPerView: 1,
                            },
                            768: {
                            slidesPerView: 2,
                            },
                            1024: {
                            slidesPerView: 2,
                            },
                            1199: {
                            slidesPerView: 3,
                            },
                        },
                    });

                    var swiper = new Swiper(".testimonial-two-slider", {
                        slidesPerView: 2,
                        loop: true,
                        spaceBetween: 20,
                        navigation: {
                            nextEl: ".testimonial-button-next",
                            prevEl: ".testimonial-button-prev",
                        },
                        breakpoints: {
                            0: {
                            slidesPerView: 1, // Mobile default
                            },
                            640: {
                            slidesPerView: 1,
                            },
                            768: {
                            slidesPerView: 2,
                            },
                            1024: {
                            slidesPerView: 2,
                            },
                        },
                    });
                });
            </script>';
        ?>

        <?php if($settings['testimonial_style'] == 'style-1') : ?>
            <div class="overflow-hidden">
                <div class="container">
                    <div class="swiper testimonial-slider">
                        <div class="swiper-wrapper d-flex">
                            <?php foreach ($all_testimonial_items as $testimonial_item): ?>
                                <div class="swiper-slide" data-aos="fade-up" data-aos-duration="600">
                                    <div class="bg-white tw-px-8 tw-py-8 tw-rounded-xl w-100 h-100">
                                        <div class="">
                                            <div class="d-flex align-items-center justify-content-between tw-gap-3 flex-wrap tw-mb-6">
                                                <?php if($testimonial_item['testi_image']['url']) : ?>
                                                    <img src="<?php echo $testimonial_item['testi_image']['url']; ?>" alt="Darlene Robertson">
                                                <?php endif; ?>
                                                <div class="">
                                                    <?php if($testimonial_item['name']) : ?>
                                                        <h5 class="fw-medium text-dark-600 tw-mb-05"><?php echo esc_html($testimonial_item['name']); ?></h5>
                                                    <?php endif; ?>
                                                    <?php if($testimonial_item['designation']) : ?>
                                                        <span class="fw-normal text-dark-500 tw-text-lg"><?php echo esc_html($testimonial_item['designation']); ?></span>
                                                    <?php endif; ?>
                                                </div>
                                                <?php if($testimonial_item['testi_quate']['url']) : ?>
                                                    <img src="<?php echo $testimonial_item['testi_quate']['url']; ?>" alt="Quote Icon">
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                        <?php if($testimonial_item['content']) : ?>
                                            <p class="fw-normal text-dark-500 tw-text-lg tw-mb-6">
                                                <?php echo esc_html($testimonial_item['content']); ?>
                                            </p>
                                        <?php endif; ?>
                                        <span class="w-100 bg-neutral-05 h-005 d-block"></span>
                                        <div class="d-flex align-items-center tw-gap-5 justify-content-between flex-wrap tw-mt-8">
                                            <?php if($testimonial_item['rating_title']) : ?>
                                                <h4 class="fw-medium text-dark-600"><?php echo esc_html($testimonial_item['rating_title']); ?></h4>
                                            <?php endif; ?>
                                            <ul class="d-flex align-items-center tw-gap-1">
                                                <?php for ($i=0; $i < $testimonial_item['rating']; $i++) {  ?>
                                                    <li class="tw-text-6 text-warning-500"><i class="ph-fill ph-star"></i></li>
                                                <?php }?>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
        <?php if($settings['testimonial_style'] == 'style-2') : ?>
            <div class="z-1 overflow-hidden">
                <div class="container">
                    <div class="swiper testimonial-two-slider">
                        <div class="swiper-wrapper d-flex">
                            <?php foreach ($all_testimonial_items as $testimonial_item): ?>
                                <div class="swiper-slide">
                                    <div class="bg-neutral-10 tw-px-8 tw-py-8 rounded-3">
                                        <div class="">
                                            <div class="d-flex align-items-center justify-content-between tw-gap-3 flex-wrap tw-mb-6">
                                                <div class="d-flex align-items-center tw-gap-3">
                                                    <?php if($testimonial_item['testi_image']['url']) : ?>
                                                        <img src="<?php echo $testimonial_item['testi_image']['url']; ?>" alt="Darlene Robertson">
                                                    <?php endif; ?>
                                                    <div class="">
                                                        <?php if($testimonial_item['name']) : ?>
                                                            <h5 class="fw-medium text-dark-600 tw-mb-05"><?php echo esc_html($testimonial_item['name']); ?></h5>
                                                        <?php endif; ?>
                                                        <?php if($testimonial_item['designation']) : ?>
                                                            <span class="fw-normal text-dark-500 tw-text-lg"><?php echo esc_html($testimonial_item['designation']); ?></span>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                                <?php if($testimonial_item['testi_quate']['url']) : ?>
                                                    <img src="<?php echo $testimonial_item['testi_quate']['url']; ?>" alt="Quote Icon">
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                        <?php if($testimonial_item['content']) : ?>
                                            <p class="fw-normal text-dark-500 tw-text-lg tw-mb-6">
                                                <?php echo esc_html($testimonial_item['content']); ?>
                                            </p>
                                        <?php endif; ?>
                                        <span class="w-100 bg-neutral-05 h-005 d-block"></span>
                                        <div class="d-flex align-items-center tw-gap-5 justify-content-between flex-wrap tw-mt-8">
                                            <?php if($testimonial_item['rating_title']) : ?>
                                                <h4 class="fw-medium text-dark-600"><?php echo esc_html($testimonial_item['rating_title']); ?></h4>
                                            <?php endif; ?>
                                            <ul class="d-flex align-items-center tw-gap-1">
                                                <?php for ($i=0; $i < $testimonial_item['rating']; $i++) {  ?>
                                                    <li class="tw-text-6 text-warning-500"><i class="ph-fill ph-star"></i></li>
                                                <?php }?>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <?php
    }
}
Plugin::instance()->widgets_manager->register_widget_type(new Payone_Testimonial_Slider_One_Widget());