<?php
/**
 * Elementor Widget
 * @package payone
 * @since 1.0.0
 */

namespace Elementor;
class Payone_Service_Title extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'payone-service-title-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Service Title', 'payone-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-info-box';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['payone_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

		$this->start_controls_section(
			'service_section',
			[
				'label' => __( 'Service Content', 'payone-core' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control('total', [
            'label' => esc_html__('Total Posts', 'payone-core'),
            'type' => Controls_Manager::TEXT,
            'default' => '-1',
            'description' => esc_html__('enter how many course you want in masonry , enter -1 for unlimited course.')
        ]);
        $this->add_control('category', [
            'label' => esc_html__('Category', 'payone-core'),
            'type' => Controls_Manager::SELECT2,
            'multiple' => true,
            'options' => payone()->get_terms_names('service-cat', 'id'),
            'description' => esc_html__('select category as you want, leave it blank for all category', 'payone-core'),
        ]);
        $this->add_control('order', [
            'label' => esc_html__('Order', 'payone-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'ASC' => esc_html__('Ascending', 'payone-core'),
                'DESC' => esc_html__('Descending', 'payone-core'),
            ),
            'default' => 'ASC',
            'description' => esc_html__('select order', 'payone-core')
        ]);
		$this->end_controls_section();

	
	}
	protected function render() {
		$settings = $this->get_settings_for_display();
		
        //query settings
        $total_posts = $settings['total'];
        $category = $settings['category'];
        $order = $settings['order'];
        //setup query
        $args = array(
            'post_type' => 'service',
            'posts_per_page' => $total_posts,
            'order' => $order,
            'post_status' => 'publish'
        );

        if (!empty($category)) {
            $args['tax_query'] = array(
                array(
                    'taxonomy' => 'service-cat',
                    'field' => 'term_id',
                    'terms' => $category
                )
            );
        }
        $post_data = new \WP_Query($args);
        ?>

		<div class="service-title-area">
            <?php while ($post_data->have_posts()) : $post_data->the_post(); ?>
                <a href="<?php echo get_the_permalink(); ?>" class="tw-px-4 tw-py-3 bg-neutral-10 tw-rounded-md tw-text-4 fw-normal text-dark-500 d-flex align-items-center tw-gap-3 justify-content-between hover-bg-base-two-600 hover-text-white tw-duration-500 tw-mb-4">
                    <?php echo get_the_title(); ?>
                    <i class="ph ph-caret-double-right"></i>
                </a>
            <?php endwhile; ?>
		</div>

		<?php 
	}
}

Plugin::instance()->widgets_manager->register_widget_type(new Payone_Service_Title());