<?php
/**
 * Elementor Widget
 * @package payone
 * @since 1.0.0
 */

namespace Elementor;

class Payone_Service_Slider_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'payone-service-slider-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Service Slider', 'payone-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-slider-album';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['payone_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'service_content_section',
            [
                'label' => esc_html__('Service content Settings', 'payone-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );  
        $this->add_control(
            'animate_img1', [
                'label' => esc_html__('animate img1', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
                'description' => esc_html__('animate Image 1', 'payone-core'),
            ]
        );
        $this->add_control(
            'animate_img2', [
                'label' => esc_html__('animate img2', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
                'description' => esc_html__('animate Image 2', 'payone-core'),
            ]
        );
        $this->add_control(
            'animate_img3', [
                'label' => esc_html__('animate img3', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
                'description' => esc_html__('animate Image 3', 'payone-core'),
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'service_slider_section',
            [
                'label' => esc_html__('Service Slider Settings', 'payone-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );  
        $this->add_control(
            'subtitle_img',
            [
                'label' => esc_html__('Sub Title Image', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
                'description' => esc_html__('Sub Title Image', 'payone-core'),
            ]
        );
        $this->add_control(
            'subtitle',
            [
                'label' => esc_html__('Sub Title', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Safe Transportation & Logistics', 'payone-core'),
                'description' => esc_html__('enter title. use {c} color text {/c} for color text', 'payone-core'),
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Get Your paynone online Banking', 'payone-core'),
            ]
        );
        $this->add_control(
            'content',
            [
                'label' => esc_html__('content', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Our services include secure online banking, mobile app access, bill payments, fund transfers,', 'payone-core'),
            ]
        );
        $this->add_control(
            'h_btn_text',
            [
                'label' => esc_html__('Button text', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('#', 'payone-core'),
            ]
        );
        $this->add_control(
            'btn_url',
            [
                'label' => esc_html__('Button Url', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('#', 'payone-core'),
            ]
        );

        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'service_icon_class', [
                'label' => esc_html__('service icon class', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('ph-fill ph-thumbs-up', 'payone-core'),
            ]
        );
        $repeater->add_control(
            'service_title', [
                'label' => esc_html__('Title', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'description' => esc_html__('enter title.', 'payone-core'),
                'default' => esc_html__('Online Sellers', 'payone-core')
            ]
        );
        $repeater->add_control(
            'service_content', [
                'label' => esc_html__('Content Title', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'description' => esc_html__('enter title.', 'payone-core'),
                'default' => esc_html__('Ensuring secure payments is our top priority. We employ advanced encryption, multi-factor', 'payone-core')
            ]
        );
        $repeater->add_control(
            'service_btn_url', [
                'label' => esc_html__('btn_url', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('#', 'payone-core')
            ]
        );
        $this->add_control('service_items', [
            'label' => esc_html__('service Item', 'payone-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'image' => array(
                        'url' => Utils::get_placeholder_image_src()
                    )
                ]
            ],
        ]);
        $this->end_controls_section();

        $this->start_controls_section(
            'service_counter_section',
            [
                'label' => esc_html__('Service ounter Settings', 'payone-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        ); 
        $this->add_control(
            'service_counter_num', [
                'label' => esc_html__('service_counter_num', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('11.5K', 'payone-core'),
            ]
        );
        $this->add_control(
            'service_counter_title', [
                'label' => esc_html__('service_counter_title', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Banking Card available', 'payone-core'),
            ]
        );

        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'count_num', [
                'label' => esc_html__('Count_num', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('12+', 'payone-core')
            ]
        );
        $repeater->add_control(
            'count_title', [
                'label' => esc_html__('coun title', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Ensuring secure payments is our top priority. We employ advanced encryption, multi-factor', 'payone-core')
            ]
        );
        $repeater->add_control(
            'count_content', [
                'label' => esc_html__('coun content', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('#', 'payone-core')
            ]
        );
        $this->add_control('count_items', [
            'label' => esc_html__('count Item', 'payone-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
        ]);
        $this->end_controls_section();

        $this->start_controls_section(
            'service_styling',
            [
                'label' => esc_html__('Styling Settings', 'payone-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control('category_color', [
            'label' => esc_html__('Category Color', 'payone-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .text-neutral-1000" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->end_controls_section();

    }


    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $service_items = $settings['service_items'];
        $count_items = $settings['count_items'];
        echo '
            <script>
                jQuery(document).ready(function($) {
                    var swiper = new Swiper(".servics-slider", {
                        slidesPerView: 3,
                        spaceBetween: 20,
                        loop: true,
                        autoplay: {
                            delay: 4000,
                            disableOnInteraction: false,
                        },
                        breakpoints: {
                            320: {
                            slidesPerView: 1,
                            },
                            640: {
                            slidesPerView: 1,
                            },
                            768: {
                            slidesPerView: 2,
                            },
                            1499: {
                            slidesPerView: 3,
                            },
                        },
                    });
                });
            </script>';
        ?>
        <div class="position-relative overflow-hidden">
            <div class="our-services-three position-relative overflow-hidden z-1">
                <?php if($settings['animate_img2']['url']) : ?>
                    <img src="<?php echo $settings['animate_img2']['url']; ?>" alt="Image" class="position-absolute tw-end-100-px tw-mt-104-px d-lg-block d-none animation-pulse__two">
                <?php endif; ?>
                <?php if($settings['animate_img1']['url']) : ?>
                    <img src="<?php echo $settings['animate_img1']['url']; ?>" alt="Image" class="position-absolute inset-inline-start-130px inset-block-start-130px z-n1 d-lg-block d-none animation-rotation__two">
                <?php endif; ?>
                <?php if($settings['animate_img3']['url']) : ?>
                    <img src="<?php echo $settings['animate_img3']['url']; ?>" alt="Image" class="position-absolute inset-inline-start-0 inset-block-end-0 d-lg-block d-none animation-Updowm__two">
                <?php endif; ?>

                <div class="container">
                    <div class="our-services-item d-flex align-items-center tw-gap-268-px justify-content-end">
                        <div class="tw-pt-100-px">
                            <?php if (!empty($settings['service_counter_num'])) : ?>
                                <h2 class="banner-item-title h1 tw-text-15 text-white fw-normal tw-mb-2 cursor-big counter" data-aos="fade-up" data-aos-duration="600"><?php echo $settings['service_counter_num']; ?></h2>
                            <?php endif; ?>
                            <?php if (!empty($settings['service_counter_title'])) : ?>
                                <span class="fw-medium tw-text-6 text-white" data-aos="fade-up" data-aos-duration="800"><?php echo $settings['service_counter_title']; ?></span>
                            <?php endif; ?>
                        </div>
                        <div class="py-80 d-flex align-items-center tw-gap-6 justify-content-end flex-wrap w-100">
                            <?php foreach($count_items as $count_item) : ?>
                                <div class="tw-px-3" data-aos="fade-up" data-aos-duration="600">
                                    <h2 class="fw-normal cursor-big tw-w-100px tw-h-100-px border-primary-600 rounded-circle d-flex align-items-center justify-content-center tw-mb-8 counter"><?php echo $count_item['count_num']; ?></h2>
                                    <h4 class="fw-normal tw-mb-2 "><?php echo $count_item['count_title']; ?></h4>
                                    <span class="fw-normal tw-text-lg text-dark-500"><?php echo $count_item['count_content']; ?></span>
                                </div>
                            <?php endforeach ?>
                        </div>
                    </div>

                    <div class="our-serbices-card  bg-neutral-10 overflow-hidden tw-w-100vw">
                        <div class="our-services-three-slider tw-pt-140px tw-p-left-120-px d-flex tw-gap-94-px tw-pb-140px">
                            <div class="our-services-text max-w-446">
                                <?php if (!empty($settings['subtitle'])) : ?>
                                    <div class="section-heading__subtitle d-inline-flex align-items-center tw-gap-1 tw-mb-3">
                                        <?php if($settings['subtitle_img']['url']) : ?>
                                            <img src="<?php echo $settings['subtitle_img']['url']; ?>" alt="Image">
                                        <?php endif; ?>
                                        <h5 class="sub_title text-primary-600 fw-normal">
                                            <?php echo $settings['subtitle']; ?>
                                        </h5>
                                    </div>
                                <?php endif; ?>
                                <?php if (!empty($settings['title'])) : ?>
                                    <h2 class="fw-normal text-dark-600 tw-mb-3 cursor-big w-446" data-aos="fade-up" data-aos-duration="800"><?php echo $settings['title']; ?></h2>
                                <?php endif; ?>
                                <?php if (!empty($settings['content'])) : ?>
                                    <p class="fw-normal tw-text-lg text-dark-500 tw-mb-8" data-aos="fade-up" data-aos-duration="1000"><?php echo $settings['content']; ?></p>
                                <?php endif; ?>
                                <?php if (!empty($settings['h_btn_text'])) : ?>
                                    <div class="position-relative z-1 max-auto" data-aos="fade-up" data-aos-duration="1200">
                                        <a href="<?php echo $settings['btn_url']; ?>" class="position-relative our-serbices-item-link fw-semibold tw-text-lg text-center hover-text-dark-600 tw-duration-500">
                                            <span class="position-relative zn-2 px-4 text-dark-700 tw-py-205 bg-main-600 w-100 rounded-3 border-two-px-solid"><?php echo $settings['h_btn_text']; ?></span>
                                        </a>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <!-- ================= Our Services section start==================== -->

                            <div class="swiper servics-slider overflow-hidden">
                                <div class="swiper-wrapper d-flex">
                                    <?php foreach($service_items as $service_item) : ?>
                                        <div class="swiper-slide" data-aos="fade-up" data-aos-duration="600">
                                            <div class="our-services-card-three position-relative group group-item">
                                                <div class="bg-white rounded-4 w-100 group-hover-border-dark-600 tw-duration-400">
                                                    <span class="circle-shape-three position-absolute tw-transition-03-secend inset-inline-end-0px inset-block-start-0px tw-w-72px tw-h-72-px bg-neutral-10 rounded-circle"></span>
                                                    <a href="<?php echo $service_item['service_btn_url']; ?>" class="group-hover-bg-main-600 tw-duration-400 our-services-button w-16 h-16 bg-white rounded-circle tw-text-8 text-dark-600 d-flex align-items-center justify-content-center position-absolute inset-block-start-0px inset-inline-end-0px">
                                                        <i class="ph-bold ph-arrow-up-right"></i>
                                                    </a> 
                                                    <?php if($service_item['service_icon_class']) : ?>
                                                        <span class="tw-pt-605 tw-ps-605">
                                                            <span class="tw-w-72px tw-h-72-px border-base-two-100 rounded-3 d-flex align-items-center justify-content-center tw-mb-805">
                                                                <span class="w-15 h-15 bg-base-two-10 rounded-3 d-flex align-items-center justify-content-center group-hover-bg-base-two-600 tw-duration-400 group-hover-text-main-600 tw-text-10 text-base-two-600">
                                                                    <i class="<?php echo $service_item['service_icon_class']; ?>"></i>
                                                                </span>
                                                            </span>
                                                        </span>
                                                    <?php endif; ?>
                                                    <div class="tw-px-8 tw-pb-10">
                                                        <?php if($service_item['service_title']) : ?>
                                                            <h4 class="fw-normal tw-mb-3 text-dark-600 line-clamp-2"><?php echo $service_item['service_title']; ?></h4>
                                                        <?php endif; ?>
                                                        <?php if($service_item['service_content']) : ?>
                                                            <p class="fw-normal tw-text-4 text-dark-500 line-clamp-4">
                                                                <?php echo $service_item['service_content']; ?>
                                                            </p>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach ?>
                                </div>
                            </div> 
                            <!-- ================= Our Services section end==================== -->

                        </div>
                    </div>
                </div>
            
            </div>
        </div>
        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Payone_Service_Slider_Widget());