<?php
/**
 * Elementor Widget
 * @package payone
 * @since 1.0.0
 */

namespace Elementor;
class Payone_Service_List extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'payone-service-list-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Service List', 'payone-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-info-box';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['payone_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

		$this->start_controls_section(
			'service_section',
			[
				'label' => __( 'Service Content', 'payone-core' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);$this->add_control('total', [
            'label' => esc_html__('Total Posts', 'payone-core'),
            'type' => Controls_Manager::TEXT,
            'default' => '-1',
            'description' => esc_html__('enter how many course you want in masonry , enter -1 for unlimited course.')
        ]);
        $this->add_control('category', [
            'label' => esc_html__('Category', 'payone-core'),
            'type' => Controls_Manager::SELECT2,
            'multiple' => true,
            'options' => payone()->get_terms_names('service-cat', 'id'),
            'description' => esc_html__('select category as you want, leave it blank for all category', 'payone-core'),
        ]);
        $this->add_control('order', [
            'label' => esc_html__('Order', 'payone-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'ASC' => esc_html__('Ascending', 'payone-core'),
                'DESC' => esc_html__('Descending', 'payone-core'),
            ),
            'default' => 'ASC',
            'description' => esc_html__('select order', 'payone-core')
        ]);
		$this->end_controls_section();

	
	}
	protected function render() {
		$settings = $this->get_settings_for_display();
		$rand_numb = rand(333, 999999999);
		
        //query settings
        $total_posts = $settings['total'];
        $category = $settings['category'];
        $order = $settings['order'];
        //setup query
        $args = array(
            'post_type' => 'service',
            'posts_per_page' => $total_posts,
            'order' => $order,
            'post_status' => 'publish'
        );

        if (!empty($category)) {
            $args['tax_query'] = array(
                array(
                    'taxonomy' => 'service-cat',
                    'field' => 'term_id',
                    'terms' => $category
                )
            );
        }
        $post_data = new \WP_Query($args);
        ?>

		<div class="service-area">
			<div class="row">
				<?php while ($post_data->have_posts()) : $post_data->the_post(); 
					$service_single_meta_data = get_post_meta(get_the_ID(), 'payone_service_options', true);
                    $service_icon = isset($service_single_meta_data['service_icon']) && !empty($service_single_meta_data['service_icon']) ? $service_single_meta_data['service_icon'] : '';
                    $service_details = isset($service_single_meta_data['service_content']) && !empty($service_single_meta_data['service_content']) ? $service_single_meta_data['service_content'] : '';
				?>
					<div class="col-xl-3 col-lg-4 col-md-6">
						<div class="our-services-card position-relative group"  data-aos="fade-up" data-aos-duration="1000">
							<span class="circle-shape position-absolute tw-transition-03-secend inset-inline-end-0px inset-block-start-0px tw-w-72px tw-h-72-px bg-white rounded-circle"></span>
							<a href="<?php echo get_the_permalink(); ?>" class="text-dark-600-important group-hover-bg-main-600 tw-transition-03-secend our-services-button w-16 h-16 bg-neutral-10 rounded-circle tw-text-8 text-dark-600 d-flex align-items-center justify-content-center position-absolute inset-block-start-0px inset-inline-end-0px">
								<i class="ph-bold ph-arrow-up-right"></i>
							</a> 
							<div class="tw-px-8 tw-py-8 group-hover-bg-base-two-600 tw-transition-03-secend rounded-3">
                                <?php if($service_icon['url']) : ?>
                                    <span class="group-hover-bg-main-600 tw-transition-03-secend group-hover-text-dark-600 our-services-bank w-15 h-15 bg-base-two-600 rounded-3 tw-text-805 text-white align-items-center justify-content-center d-flex tw-mb-10">
                                        <img src="<?php echo $service_icon['url']; ?>" alt="Image" class="text-white">
                                    </span>
                                <?php endif; ?>
								<div class="max-w-242">
									<h4 class="group-hover-text-white tw-transition-03-secend our-services-title fw-normal text-dark-700 tw-mb-3 cursor-big"><?php echo get_the_title(); ?></h4>
									<?php if($service_details) : ?>
										<p class="group-hover-text-white tw-transition-03-secend our-services-text text-dark-500 fw-normal tw-text-4"><?php echo $service_details; ?></p>
									<?php endif; ?>
								</div>
							</div>
						</div>
					</div>
				<?php endwhile; ?>
			</div>
		</div>

		<?php 
	}
}

Plugin::instance()->widgets_manager->register_widget_type(new Payone_Service_List());