<?php
/**
 * Elementor Widget
 * @package Payone
 * @since 1.0.0
 */

namespace Elementor;
class Payone_Pricing_One extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'payone-pricing-one-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Pricing 01', 'payone-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-editor-list-ul';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['payone_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'monthly_section',
            [
                'label' => esc_html__('Monthly Content', 'payone-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'price_subtitle', [
                'label' => esc_html__('price subtitle', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Subscription', 'payone-core')
            ]
        );
        $this->add_control(
            'price_amount', [
                'label' => esc_html__('price amount', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('$39', 'payone-core')
            ]
        );
        $this->add_control(
            'price_month', [
                'label' => esc_html__('price month', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('PER MONTH', 'payone-core')
            ]
        );
        $this->add_control(
            'price_btn', [
                'label' => esc_html__('price btn', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('CHOOSE THIS PLAN', 'payone-core')
            ]
        );
        $this->add_control(
            'price_btn_url', [
                'label' => esc_html__('price btn_url', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('#', 'payone-core')
            ]
        );

        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'price_list_title', [
                'label' => esc_html__('price list Title', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'description' => esc_html__('price list title.', 'payone-core'),
                'default' => esc_html__('1% fee per transaction', 'payone-core')
            ]
        );
        $this->add_control('pricing_list_items', [
            'label' => esc_html__('Pricing list Item', 'payone-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'image' => array(
                        'url' => Utils::get_placeholder_image_src()
                    )
                ]
            ],
        ]);

        $this->add_control(
            'price_duration', [
                'label' => esc_html__('price duration', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('8', 'payone-core')
            ]
        );
        $this->end_controls_section();

        /*  tab styling tabs start */
        $this->start_controls_section(
            'tab_settings_section',
            [
                'label' => esc_html__('Tab Settings', 'payone-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->end_controls_section();

    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $pricing_list_items = $settings['pricing_list_items'];
        ?>

            <div class="group" data-aos="fade-up" data-aos-duration="<?php echo $settings['price_duration']; ?>00">
                <div class="our-pricing-plan-card border-neutral-100 border tw-rounded-xl group-hover-bg-base-two-600 tw-duration-500">
                    <div class="tw-px-12 tw-pt-12">
                        <?php if($settings['price_subtitle']) : ?>
                            <h6 class="fw-normal text-dark-600 tw-mb-3 group-hover-text-white tw-duration-500"><?php echo $settings['price_subtitle']; ?></h6>
                        <?php endif; ?>
                        <?php if($settings['price_amount']) : ?>
                            <div class="d-flex align-items-center tw-gap-1 tw-mb-8 ">
                                <h2 class="fw-normal cursor-big group-hover-text-white tw-duration-500">
                                    <?php echo $settings['price_amount']; ?>
                                </h2>
                                <?php if($settings['price_month']) : ?>
                                    <span class="tw-text-4 text-dark-600 group-hover-text-white tw-duration-500">
                                        <?php echo $settings['price_month']; ?>
                                    </span>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>
                        <?php if($settings['price_btn']) : ?>
                            <div class="position-relative z-2">
                                <a href="<?php echo $settings['price_btn_url']; ?>" class="our-pricing-plan-other-link fw-semibold tw-text-lg text-dark-700 tw-py-3 bg-main-600 border-two-px-solid w-100 text-center tw-rounded-md hover-text-dark-600">
                                    <?php echo $settings['price_btn']; ?>
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>
                    <span class="bg-neutral-100 w-100 tw-h-px tw-mt-8 tw-mb-8"></span>
                    <div class="tw-px-12 tw-pb-12">
                        <div class="price-list-wrap bg-neutral-10 tw-rounded-xl tw-px-6 tw-py-6 group-hover-bg-neutral-200 tw-duration-500">
                            <?php foreach($pricing_list_items as $p_list) : ?>
                                <div class="price-list-item d-flex align-items-center tw-gap-2">
                                    <span class="tw-w-6 tw-h-6 bg-base-two-600 text-white d-flex align-items-center justify-content-center rounded-circle flex-shrink-0 group-hover-bg-neutral-30 tw-duration-500 tw-text-sm">
                                        <i class="ph ph-check"></i>
                                    </span>
                                    <span class="fw-normal tw-text-lg text-dark-500 group-hover-text-white tw-duration-500">
                                        <?php echo $p_list['price_list_title']; ?>
                                    </span>
                                </div>
                                <span class="price-list-border bg-neutral-100 w-100 tw-h-px tw-mt-4 tw-mb-4"></span>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div> 
            </div>

        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Payone_Pricing_One());