<?php
/**
 * Elementor Widget
 * @package payone
 * @since 1.0.0
 */

namespace Elementor;

class Payone_Payment_Slider_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'payone-payment-slider';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Payment Slider', 'payone-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-slides';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['payone_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content Settings', 'payone-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control('payment_style', [
            'label' => esc_html__('payment style', 'payone-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'style-1' => esc_html__('Style 1', 'payone-core'),
                'style-2' => esc_html__('style-2', 'payone-core'),
                'style-3' => esc_html__('style-3', 'payone-core'),
            ),
            'default' => 'style-1',
            'description' => esc_html__('Select Payment Style', 'payone-core')
        ]);

        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'payment_img', [
                'label' => esc_html__('payment img', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
                'description' => esc_html__('payment img', 'payone-core'),
            ]
        );
        $repeater->add_control(
            'payment_title', [
                'label' => esc_html__('payment title', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('payment title', 'payone-core'),
            ]
        );
        $this->add_control('payment_items', [
            'label' => esc_html__('payment Item', 'payone-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'image' => array(
                        'url' => Utils::get_placeholder_image_src()
                    )
                ]
            ],
        ]);
        $this->end_controls_section();

        $this->start_controls_section(
            'banner_styling_settings_section',
            [
                'label' => esc_html__('Styling Settings', 'payone-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->end_controls_section();

    }


    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        echo '
            <script>
                jQuery(document).ready(function($) {
                    const multiplier = {
                        translate: 0.1,
                        rotate: 0.02,
                        };
                        var PaymentSwiper = new Swiper(".payment-mathod-slider", {
                        slidesPerView: 7,
                        spaceBetween: 24,
                        loop: true,
                        autoplay: false,
                        grabCursor: true,
                        navigation: {
                            nextEl: ".payment-method-button-prev",
                            prevEl: ".payment-method-button-next",
                        },
                        breakpoints: {
                            320: { slidesPerView: 2 },
                            640: { slidesPerView: 2 },
                            768: { slidesPerView: 4 },
                            1024: { slidesPerView: 6 },
                            1199: { slidesPerView: 7 },
                        },
                        });
                        function calculateWheel() {
                        const slides = document.querySelectorAll(".single");
                        slides.forEach((slide, i) => {
                            const rect = slide.getBoundingClientRect();
                            const r = window.innerWidth * 0.5 - (rect.x + rect.width * 0.5);
                            let ty =
                            Math.abs(r) * multiplier.translate -
                            rect.width * multiplier.translate;

                            if (ty < 0) {
                            ty = 0;
                            }
                            const transformOrigin = r < 0 ? "left top" : "right top";
                            slide.style.transform = `translate(0, ${ty}px) rotate(${
                            -r * multiplier.rotate
                            }deg)`;
                            slide.style.transformOrigin = transformOrigin;
                        });
                    }
                    function raf() {
                        requestAnimationFrame(raf);
                        calculateWheel();
                    }
                    raf();

                    
                    var swiper = new Swiper(".our-services-two-slider", {
                    slidesPerView: 3,
                    spaceBetween: 20,
                    loop: true,
                    pagination: {
                        el: ".swiper-pagination",
                        clickable: true,
                    },
                    autoplay: {
                        delay: 4000,
                        disableOnInteraction: false,
                    },
                    breakpoints: {
                        320: {
                        slidesPerView: 1,
                        },
                        412: {
                        slidesPerView: 2,
                        },
                        640: {
                        slidesPerView: 2,
                        },
                        768: {
                        slidesPerView: 3,
                        },
                        1024: {
                        slidesPerView: 4,
                        },
                        1199: {
                        slidesPerView: 5,
                        },
                    },
                    });
                });
            </script>';
        ?>

        <?php if($settings['payment_style'] == 'style-1') : ?>
            <div class="overflow-hidden">
                <div class="container">
                    <div class="swiper payment-mathod-slider overflow-hidden tw-h-180-px">
                        <div class="swiper-wrapper d-flex">
                            <?php foreach($settings['payment_items'] as $payment_item) : ?>
                                <div class="swiper-slide">
                                    <div class="single">
                                        <img src="<?php echo $payment_item['payment_img']['url'] ?>" alt="Image">
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                    <div class="d-flex align-items-center justify-content-center gap-3">
                        <button type="button" class="payment-method-button-next w-12 h-12 border-base-two-600 border rounded-circle tw-text-6 text-base-two-600 d-flex align-items-center justify-content-center hover-bg-base-two-600 hover-text-white tw-duration-400" data-aos="fade-right" data-aos-duration="800">
                            <i class="ph ph-caret-left"></i>
                        </button>
                        <button type="button" class="payment-method-button-prev w-12 h-12 border-base-two-600 border rounded-circle tw-text-6 text-base-two-600 d-flex align-items-center justify-content-center hover-bg-base-two-600 hover-text-white tw-duration-400" data-aos="fade-left" data-aos-duration="800">
                            <i class="ph ph-caret-right"></i>
                        </button>
                    </div>
                </div>
            </div>
        <?php elseif($settings['payment_style'] == 'style-2') : ?>
            <div class="overflow-hidden">
                <div class="container">
                    <div class="swiper our-services-two-slider overflow-hidden">
                        <div class="swiper-wrapper d-flex align-items-center tw-gap-4 mx-auto tw-mb-15">
                            <?php foreach($settings['payment_items'] as $payment_item) : ?>
                                <div class="swiper-slide">
                                    <div class="single group max-w-246-px w-100 position-relative">
                                        <div class="our-services-slider-card tw-px-8 tw-py-8 bg-white tw-rounded-xl border-base-two-600 border-bottom text-center group-hover-bg-main-600 tw-duration-500 tw-hover-border-black tw-transition-05-secend">
                                            <?php if($payment_item['payment_img']['url']) : ?>
                                                <span class="tw-mb-6 d-block">
                                                    <img src="<?php echo $payment_item['payment_img']['url']; ?>" alt="Image">
                                                </span>
                                            <?php endif; ?>
                                            <?php if($payment_item['payment_title']) : ?>
                                                <span class="fw-semibold tw-text-5 text-dark-600">
                                                    <?php echo $payment_item['payment_title']; ?>
                                                </span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                        <div class="swiper-pagination text-base-two-600"></div>
                    </div>
                </div>
            </div>
        <?php elseif($settings['payment_style'] == 'style-3') : ?>
            <div class="swiper our-services-two-slider overflow-hidden">
                <div class="swiper-wrapper d-flex align-items-center tw-gap-4 tw-mb-15">
                    <?php foreach($settings['payment_items'] as $payment_item) : ?> 
                        <div class="swiper-slide">
                            <div class="single group group-item max-w-246-px w-100 position-relative">
                                <div class="our-services-slider-card tw-px-8 tw-py-8 bg-white tw-rounded-xl border-base-two-600 border-bottom text-center group-hover-bg-main-600 tw-duration-500 tw-hover-border-black tw-transition-05-secend">
                                    <?php if($payment_item['payment_img']['url']) : ?>
                                        <span class="tw-w-80-px tw-h-80-px tw-border-base-two-600-dashed d-block d-flex align-items-center justify-content-center tw-mb-6 tw-rounded-xl mx-auto">
                                            <span class="tw-w-17 tw-h-17 bg-base-two-10 d-flex align-items-center justify-content-center group-hover-bg-base-two-600 tw-rounded-md tw-duration-500">
                                                <img src="<?php echo $payment_item['payment_img']['url']; ?>" alt="Image" class="group-hover-item-text-invert tw-duration-500">
                                            </span>
                                        </span>
                                    <?php endif; ?>
                                    <?php if($payment_item['payment_title']) : ?>
                                        <span class="fw-semibold tw-text-6 text-dark-600">
                                            <?php echo $payment_item['payment_title']; ?>
                                        </span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
                <div class="swiper-pagination"></div>
            </div>
        <?php endif; ?>

        <?php
    }
}
Plugin::instance()->widgets_manager->register_widget_type(new Payone_Payment_Slider_Widget());