<?php
/**
 * Elementor Widget
 * @package Payone
 * @since 1.0.0
 */
namespace Elementor;
class Payone_Navbar_Two_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'payone-navbar-two-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Navbar 02', 'payone-core');
    }

    public function get_keywords()
    {
        return ['icon', 'Box', 'icon box', 'payone'];
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
	public function get_icon() {
		return 'eicon-nav-menu';
	}

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['payone_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
			'icon_section',
			[
				'label' => __('Icon Box', 'payone-core' ),
                'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
            'time',
            [
                'label' => esc_html__('Time', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => __('24/7 hours support', 'payone-core' ),
            ]
        );
        $this->add_control(
            'email',
            [
                'label' => esc_html__('Email', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => __('paynone@gmail.com', 'payone-core' ),
            ]
        );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'social_icon', [
                'label' => esc_html__('Icons', 'payone-core'),
                'type' => Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-angle-right',
                    'library' => 'solid',
                ],
            ]
        );
        $repeater->add_control(
            'social_url', [
                'label' => esc_html__('social url', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __('#', 'payone-core' ),
            ]
        );
        $this->add_control('social_items', [
            'label' => esc_html__('social Item', 'payone-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'image' => array(
                        'url' => Utils::get_placeholder_image_src()
                    )
                ]
            ],
        ]);

        $this->add_control(
            'logo', [
                'label' => esc_html__('Logo', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
                'description' => esc_html__('Main Logo', 'payone-core'),
            ]
        );
        $this->add_control(
            'rightbar_status',
            [
                'label' => __( 'Show / Hide rightbar', 'payone-core' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'payone-core' ),
                'label_off' => __( 'Hide', 'payone-core' ),
            ]
        );
        $this->add_control(
            'right_link_text',
            [
                'label' => esc_html__('right link text', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __('Track Order', 'payone-core' ),
            ]
        );
        $this->add_control(
            'right_link_url',
            [
                'label' => esc_html__('right link url', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __('#', 'payone-core' ),
            ]
        );
		$this->end_controls_section();

        /*  tab styling tabs start */
        $this->start_controls_section(
            'tab_settings_section',
            [
                'label' => esc_html__('Style Settings', 'payone-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->end_controls_section();
    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();

            echo '
                <script>
                    jQuery(document).ready(function($) {

                        $("ul.nav-menu  > li").addClass("nav-menu__item");
                        $("ul.nav-menu  > li.menu-item-has-children").addClass("has-submenu position-relative");
                        $("ul.nav-menu  > li > a").addClass("nav-menu__link hover--translate-y-1 tw-pe-5 text-heading py-3 fw-semibold w-100");
                        $("ul.nav-menu  > li .sub-menu").addClass("nav-submenu scroll-sm position-absolute start-0 top-100 tw-w-max bg-white tw-rounded-md px-2 py-3 tw-duration-200 tw-z-99");
                        $("ul.nav-menu  > li .sub-menu li a").addClass("nav-submenu__link hover-bg-neutral-100 nav-text-heading fw-semibold w-100 d-block tw-py-2 tw-px-305 tw-rounded hover-bg-main-100");
                        
                        $(".mobile-menu__menu ul > li a").addClass("nav-menu__link w-100");
                    });
                </script>';
            ?>

            <?php
                $preloader_enable = cs_get_option('preloader_enable');
                $preloader_img1 = cs_get_option('preloader_img1');
                $preloader_img2 = cs_get_option('preloader_img2');
                if($preloader_enable == true) :
            ?>
                <div class="preloder">
                    <div class="position-relative tw-w-76-px tw-h-76-px d-flex justify-content-center align-items-center">
                        <?php if($preloader_img1['url']) : ?>
                            <img src="<?php echo $preloader_img1['url']; ?>" alt="Img" class="tw-w-8">
                        <?php endif; ?>
                        <?php if($preloader_img2['url']) : ?>
                            <div class="preloder__exchange__img w-100 h-100">
                                <img src="<?php echo $preloader_img2['url']; ?>" alt="Img" class="w-100 h-100 animation-rotation">
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endif; ?>

            <!--==================== Preloader Start ====================-->
            <div class="progress-wrap cursor-big">
                <svg class="progress-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102">
                    <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" />
                </svg>
            </div>
            <!--==================== Preloader End ====================-->
            
            <div class="side-overlay"></div>
            <div id="toast-container"></div>
            <div class="cursor"></div>
            <span class="dot"></span>
            <!-- Custom Toast Message End -->

            <!-- ==================== Scroll to Top End Here ==================== -->
            <div class="progress-wrap cursor-big">
                <svg class="progress-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102">
                    <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" />
                </svg>
            </div>
            <!-- ==================== Scroll to Top End Here ==================== -->

            <!-- ========================== Top Header Start ============================== -->

            <div class="bg-warning-500 py-3 z-1">
                <div class="container max-w-1640">
                    <div class="d-flex align-items-center tw-gap-3 justify-content-between flex-wrap">
                        <div class="d-md-block d-none">
                            <div class="d-flex align-items-center tw-gap-6 flex-wrap ">
                                <?php if($settings['time']) : ?>
                                    <div class="d-flex align-items-center gap-2 flex-wrap">
                                        <span class="tw-text-lg text-dark-600 fw-medium">
                                            <i class="ph-bold ph-headset"></i>
                                        </span>
                                        <span class="text-dark-600 fw-semibold tw-text-lg">
                                            <?php echo $settings['time']; ?>
                                        </span>
                                    </div>
                                <?php endif; ?>
                                <?php if($settings['email']) : ?>
                                    <div class="d-flex align-items-center gap-2 flex-wrap">
                                        <span class="tw-text-lg text-dark-600 fw-medium d-flex">
                                            <i class="ph-bold ph-envelope-simple"></i>
                                        </span>
                                        <span class="text-dark-600 fw-semibold"><?php echo $settings['email']; ?></span>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php if ( ! empty( $settings['social_items'] ) ) : ?>
                            <div class="top-header-item d-flex align-items-center tw-gap-15 flex-wrap">
                                <div>
                                    <ul class="d-flex align-items-center tw-gap-5 flex-wrap">
                                        <?php foreach ( $settings['social_items'] as $social_icon ) : ?>
                                            <li>
                                                <a href="<?php echo $social_icon['social_url']; ?>" class="tw-text-lg text-dark-600 hover-text-blue">
                                                    <i class="<?php echo $social_icon['social_icon']['value']; ?>"></i>
                                                </a>
                                            </li>
                                        <?php endforeach; ?>
                                    </ul>
                                </div>
                            </div>
                        <?php endif; ?>

                    </div>
                </div>
            </div>

            <!-- ========================== Top Header End ============================== -->
            <header class="header transition-all header-two position-absolute w-100 tw-z-9">
                <div class="container max-w-1640">
                    <nav class="d-flex align-items-center justify-content-between">
                        <!-- Logo Start -->
                        <?php if(!empty($settings['logo']['url'])) : ?>
                            <div class="logo">
                                <a href="<?php echo get_home_url(); ?>" class="link">
                                    <img src="<?php echo $settings['logo']['url']; ?>" alt="Logo" class="tw-h-10">
                                </a>
                            </div>
                        <?php else : ?>
                            <h3><a class="mobile-menu__logo text-white" href="<?php echo get_home_url(); ?>"><?php echo get_bloginfo('title'); ?></a></h3>
                        <?php endif; ?>
                        <!-- Logo End  -->

                        <!-- Menu Start  -->
                        <div class="header-menu d-lg-block d-none">
                            <?php
                                wp_nav_menu(array(
                                    'theme_location' => 'main-menu',
                                    'menu_class' => 'nav-menu d-lg-flex align-items-center tw-gap-6',
                                    'container' => 'div',
                                    'container_id' => 'payone_main_menu',
                                    'fallback_cb' => 'payone_theme_fallback_menu',
                                ));
                            ?>
                        </div>
                        <!-- Menu End  -->
                        
                        <?php if($settings['rightbar_status'] == 'yes') : ?>
                            <!-- Header Right start -->
                            <div class="d-flex align-items-center tw-gap-3">
                                <div class="d-sm-block d-none">
                                    <div class="d-flex align-items-center tw-gap-605 flex-wrap">
                                        <?php if ( is_user_logged_in() ) { 
                                            global $current_user; 
                                        ?>
                                            <span class="text-heading fw-semibold tw-text-lg hover-text-main-600 tw-duration-500 tt-uppercase">
                                                <i class="fa fa-user"></i>
                                                <?php echo esc_html($current_user->display_name); ?>
                                            </span>
                                        <?php }else { ?>
                                            <a href="/wp-admin" class="text-heading fw-semibold tw-text-lg hover-text-main-600 tw-duration-500"><?php echo esc_html('LOGIN', 'payone-core'); ?></a>
                                        <?php } ?>
                                        <?php if($settings['right_link_text']) : ?>
                                            <div class="position-relative z-1">
                                                <a href="<?php echo $settings['right_link_url']; ?>" class="header-three-item-link text-dark-600 fw-semibold tw-text-lg tw-px-4 tw-py-2 bg-main-600 border-two-px-solid rounded-2 hover-text-dark-600">
                                                    <?php echo $settings['right_link_text']; ?>
                                                </a>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <button type="button" class="toggle-mobileMenu leading-none d-lg-none ms-3 text-heading tw-text-9"> 
                                    <i class="ph ph-list"></i>
                                </button>
                            </div>
                            <!-- Header Right End  -->
                        <?php endif; ?>
                    </nav>
                </div>
            </header>
            
            <!-- ==================== Mobile Menu Start Here ==================== -->
            <div class="mobile-menu d-lg-none d-block scroll-sm top-0 position-fixed bg-white tw-w-300-px tw-h-screen overflow-y-auto tw-p-6 tw-z-999 tw--translate-x-full tw-pb-68 ">
                <button type="button" class="close-button position-absolute tw-end-0 top-0 tw-me-2 tw-mt-2 tw-w-605 tw-h-605 rounded-circle d-flex justify-content-center align-items-center text-neutral-900 bg-neutral-200 hover-bg-neutral-900 hover-text-white"> 
                    <i class="ph ph-x"></i>
                </button>
                <div class="mobile-menu__inner">
                    <?php if(!empty($settings['logo']['url'])) : ?>
                        <div class="logo">
                            <a href="<?php echo get_home_url(); ?>" class="mobile-menu__logo">
                                <img src="<?php echo $settings['logo']['url']; ?>" alt="Logo" class="max-w-200-px" />
                            </a>
                        </div>
                    <?php else : ?>
                        <h3><a class="mobile-menu__logo" href="<?php echo get_home_url(); ?>"><?php echo get_bloginfo('title'); ?></a></h3>
                    <?php endif; ?>
                    <div class="mobile-menu__menu">
                        <!-- Nav menu Start -->
                        <?php
                            wp_nav_menu(array(
                                'theme_location' => 'main-menu',
                                'menu_class' => 'nav-menu d-lg-flex align-items-center nav-menu--mobile d-block tw-mt-8',
                                'container' => 'div',
                                'container_id' => 'payone_main_menu',
                                'fallback_cb' => 'payone_theme_fallback_menu',
                            ));
                        ?>
                        <!-- Nav menu End  -->
                    </div>
                </div>
            </div>  
            <!-- ==================== Mobile Menu End Here ==================== -->
            
        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Payone_Navbar_Two_Widget());