<?php
/**
 * Elementor Widget
 * @package Payone
 * @since 1.0.0
 */

namespace Elementor;
class Payone_Icon_Box_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
    */
    public function get_name()
    {
        return 'payone-icon-box-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Payone Icon Box', 'payone-core');
    }

    public function get_keywords()
    {
        return ['Section', 'About', 'Title', 'payone-core'];
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-heading';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['payone_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'payone-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control('box_style', [
            'label' => esc_html__('box_style', 'payone-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'style-1' => esc_html__('Style One', 'payone-core'),
                'style-2' => esc_html__('Style Two', 'payone-core'),
                'style-3' => esc_html__('Style Three', 'payone-core'),
                'style-4' => esc_html__('Style Four', 'payone-core'),
                'style-4' => esc_html__('Style Five', 'payone-core'),
            ),
            'default' => 'style-1',
            'description' => esc_html__('Box style', 'payone-core')
        ]);
        $this->add_control('image_style', [
            'label' => esc_html__('image style', 'payone-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'style-img' => esc_html__('Style Img', 'payone-core'),
                'style-icon' => esc_html__('Style Icon Class', 'payone-core'),
            ),
            'default' => 'style-img',
            'description' => esc_html__('Box style', 'payone-core')
        ]);
        $this->add_control(
            'box_img', [
                'label' => esc_html__('Box img', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
                'description' => esc_html__('Box Img', 'payone-core'),
                'default' => array(
                    'url' => Utils::get_placeholder_image_src()
                ),
                'condition' => [
                  'image_style' => 'style-img',
                ]
            ]
        );
        $this->add_control(
            'box_icon_class', [
                'label' => esc_html__('Box icon Class', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('ph ph-user-check', 'payone-core'),
                'condition' => [
                  'image_style' => 'style-icon',
                ]
            ]
        );
        $this->add_control(
            'box_title', [
                'label' => esc_html__('box title', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Global Money Transfers', 'payone-core')
            ]
        );
        $this->add_control(
            'box_content', [
                'label' => esc_html__('box Content', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Send and receive payments worldwide with ease, speed, and top-tier security.', 'payone-core')
            ]
        );
        $this->add_control(
            'box_number', [
                'label' => esc_html__('box number', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('1', 'payone-core'),
                'condition' => [
                  'box_style' => 'style-2',
                ]
            ]
        );
        $this->add_control(
            'duration_time', [
                'label' => esc_html__('duration time', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('8', 'payone-core')
            ]
        );
        $this->end_controls_section();

        /*  tab styling tabs start */
        $this->start_controls_section(
            'tab_settings_section',
            [
                'label' => esc_html__('Tab Settings', 'payone-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control('icon_box_icon_bg', [
            'label' => esc_html__('icon box icon bg', 'payone-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .icon-box-icon" => "background-color: {{VALUE}} !important"
            ]
        ]);
        $this->add_responsive_control(
            'title_margin',
            [
                'label' => __('title Margin', 'docshipper-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .icon-box-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>

        <?php if($settings['box_style'] == 'style-1') : ?>
        <div data-aos="fade-up" data-aos-duration="<?php echo $settings['duration_time']; ?>00">
            <?php if ( !empty($settings['box_img']['url']) ) : ?>
                <span class="icon-box-icon tw-w-72px tw-h-72-px border-base-two-600 d-flex align-items-center justify-content-center rounded-3 tw-mb-6">
                    <span class="w-15 h-15 bg-base-two-10 rounded-3 d-flex align-items-center justify-content-center">
                        <img src="<?php echo $settings['box_img']['url']; ?>" alt="Image">
                    </span>
                </span>
            <?php endif; ?>
            <?php if($settings['box_icon_class']) : ?>
                <span class="icon-box-icon tw-w-72px tw-h-72-px border-base-two-600 d-flex align-items-center justify-content-center rounded-3 tw-mb-6">
                    <span class="w-15 h-15 bg-base-two-10 rounded-3 d-flex align-items-center justify-content-center">
                        <i class="<?php echo $settings['box_icon_class']; ?>"></i>
                    </span>
                </span>
            <?php endif; ?>
            <?php if($settings['box_title']) : ?>
                <h5 class="fw-normal text-dark-600 tw-mb-2 cursor-big icon-box-title"><?php echo $settings['box_title']; ?></h5>
            <?php endif; ?>
            <?php if($settings['box_content']) : ?>
                <p class="fw-normal tw-text-md text-dark-500"><?php echo $settings['box_content']; ?></p>
            <?php endif; ?>
        </div>
        <?php elseif($settings['box_style'] == 'style-2') : ?>
            <div class="group" data-aos="fade-up" data-aos-duration="<?php echo $settings['duration_time']; ?>00">
                <div class="how-it-work-two-item-one group-hover-bg-white tw-transition-04-secend tw-px-10 tw-py-10 rounded-4 position-relative">
                    <?php if ( !empty($settings['box_img']['url']) ) : ?>
                        <span class="tw-w-84px tw-h-84-px bg-base-two-10 rounded-circle d-flex align-items-center justify-content-center tw-mb-12">
                            <span class="tw-w-72px tw-h-72-px bg-base-two-600 rounded-circle tw-text-8 text-white d-flex align-items-center justify-content-center">
                                <img src="<?php echo $settings['box_img']['url']; ?>" alt="Image">
                            </span>
                        </span>
                    <?php endif; ?>
                    <?php if($settings['box_icon_class']) : ?>
                        <span class="tw-w-84px tw-h-84-px bg-base-two-10 rounded-circle d-flex align-items-center justify-content-center tw-mb-12">
                            <span class="tw-w-72px tw-h-72-px bg-base-two-600 rounded-circle tw-text-8 text-white d-flex align-items-center justify-content-center">
                                <i class="<?php echo $settings['box_icon_class']; ?>"></i>
                            </span>
                        </span>
                    <?php endif; ?>
                    <?php if($settings['box_title']) : ?>
                        <h4 class="fw-normal text-dark-600 tw-mb-3"><?php echo $settings['box_title']; ?></h4>
                    <?php endif; ?>
                    <?php if($settings['box_content']) : ?>
                        <p class="fw-normal tw-text-lg text-dark-500"><?php echo $settings['box_content']; ?></p>
                    <?php endif; ?>
                    <?php if($settings['box_number']) : ?>
                        <h2 class="fw-normal h1 gradient-text tw-text-140-px position-absolute tw-end-0 top-0 tw-me-10 tw-mt-15 cursor-big">
                            <?php echo $settings['box_number']; ?>
                        </h2>
                    <?php endif; ?>
                </div>
            </div>
        <?php elseif($settings['box_style'] == 'style-3') : ?>
            <div class="feature-card d-flex align-items-center tw-gap-7 flex-wrap" data-aos="fade-up" data-aos-duration="<?php echo $settings['duration_time']; ?>00">
                <?php if ( !empty($settings['box_img']['url']) ) : ?>
                    <span class="tw-w-82px tw-h-82-px border-dashed-white rounded-circle flex-shrink-0 d-flex align-items-center justify-content-center flex-shrink-0">
                        <img src="<?php echo $settings['box_img']['url']; ?>" alt="Image">
                    </span>
                <?php endif; ?>
                <?php if($settings['box_icon_class']) : ?>
                    <span class="tw-w-82px tw-h-82-px border-dashed-white rounded-circle flex-shrink-0 d-flex align-items-center justify-content-center flex-shrink-0">
                        <i class="<?php echo $settings['box_icon_class']; ?>"></i>
                    </span>
                <?php endif; ?>
                <div class="our-peature__item max-w-310">
                    <?php if($settings['box_title']) : ?>
                        <h5 class="fw-normal text-white"><?php echo $settings['box_title']; ?></h5>
                    <?php endif; ?>
                    <?php if($settings['box_content']) : ?>
                        <p class="fw-medium tw-text-md mb-0 text-white"><?php echo $settings['box_content']; ?></p>
                    <?php endif; ?>
                </div>
            </div>
        <?php elseif($settings['box_style'] == 'style-4') : ?>
            <div class="group group-item tw-mb-10" data-aos="fade-up" data-aos-duration="<?php echo $settings['duration_time']; ?>00">
                <div class="tw-px-6 tw-py-6 rounded-3 border-bottom-black-2px group-hover-bg-base-two-600 tw-duration-400">
                    <?php if ( !empty($settings['box_img']['url']) ) : ?>
                        <span class="tw-w-72px tw-h-72-px bg-base-two-600 rounded-circle d-flex align-items-center justify-content-center tw-mb-10 group-hover-bg-main-600 tw-duration-400">
                            <img src="<?php echo $settings['box_img']['url']; ?>" alt="Image" class="group-hover-item-text-invert-black tw-duration-400">
                        </span>
                    <?php endif; ?>
                    <?php if($settings['box_icon_class']) : ?>
                        <span class="tw-w-72px tw-h-72-px bg-base-two-600 rounded-circle d-flex align-items-center justify-content-center tw-mb-10 group-hover-bg-main-600 tw-duration-400">
                            <i class="<?php echo $settings['box_icon_class']; ?>"></i>
                        </span>
                    <?php endif; ?>
                    <?php if($settings['box_title']) : ?>
                        <h5 class="fw-normal text-dark-600 tw-mb-2 group-hover-text-white tw-duration-400"><?php echo $settings['box_title']; ?></h5>
                    <?php endif; ?>
                    <?php if($settings['box_content']) : ?>
                        <p class="fw-normal tw-text-md text-dark-500 group-hover-text-white tw-duration-400"><?php echo $settings['box_content']; ?></p>
                    <?php endif; ?>
                </div>
            </div>
        <?php elseif($settings['box_style'] == 'style-5') : ?>
            <h2>style-5</h2>
        <?php endif; ?>
        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Payone_Icon_Box_Widget());