<?php
/**
 * Elementor Widget
 * @package Payone
 * @since 1.0.0
 */

namespace Elementor;
class Payone_Section_Title_One_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'payone-theme-section-title-one-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Heading Title: 01', 'payone-core');
    }

    public function get_keywords()
    {
        return ['Section', 'Heading', 'Title', "HugeBinary", 'Payone'];
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-heading';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['payone_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'payone-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'subtitle_img',
            [
                'label' => esc_html__('Sub Title Image', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
                'description' => esc_html__('Sub Title Image', 'payone-core'),
            ]
        );
        $this->add_control(
            'subtitle',
            [
                'label' => esc_html__('Sub Title', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Safe Transportation & Logistics', 'payone-core'),
                'description' => esc_html__('enter title. use {c} color text {/c} for color text', 'payone-core'),
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Fastest & Secured Logistics Solution & services', 'payone-core'),
            ]
        );
        $this->add_control(
            'content',
            [
                'label' => esc_html__('content', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );
        $this->add_control(
            'btn_text',
            [
                'label' => esc_html__('Button text', 'payone-core'),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $this->add_control(
            'btn_url',
            [
                'label' => esc_html__('Button Url', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('#', 'payone-core'),
            ]
        );
        $this->add_responsive_control(
            'text_align',
            [
                'label' => esc_html__('Alignment', 'payone-core'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'payone-core'),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'payone-core'),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'payone-core'),
                        'icon' => 'fa fa-align-right',
                    ],
                ],
                'default' => 'center',
                'toggle' => true,
                'selectors' => [
                    "{{WRAPPER}} .section-heading" => "text-align: {{VALUE}}"
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'styling_section',
            [
                'label' => esc_html__('Styling Settings', 'payone-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control('subtitle_bg_color', [
            'label' => esc_html__('Sub Title BG Color', 'payone-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .section-heading__subtitle" => "background: {{VALUE}} !important"
            ]
        ]);
        $this->add_control('subtitle_color', [
            'label' => esc_html__('Sub Title Color', 'payone-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .section-heading__subtitle .sub_title" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('subtitle Typography', 'payone-core'),
            'name' => 'subtitle_typography',
            'description' => esc_html__('subtitle typography', 'payone-core'),
            'selector' => "{{WRAPPER}} .section-heading__subtitle"
        ]);
        $this->add_control('title_color', [
            'label' => esc_html__('Title Color', 'payone-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .section-heading h2" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('title Typography', 'payone-core'),
            'name' => 'title_typography',
            'description' => esc_html__('title typography', 'payone-core'),
            'selector' => "{{WRAPPER}} .section-heading h2"
        ]);
        $this->add_control('content_color', [
            'label' => esc_html__('content Color', 'payone-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .section-heading p" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('content Typography', 'payone-core'),
            'name' => 'content_typography',
            'description' => esc_html__('content typography', 'payone-core'),
            'selector' => "{{WRAPPER}} .section-heading p"
        ]);
        $this->add_responsive_control(
            'content_margin',
            [
                'label' => __('Content Margin', 'docshipper-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .section-heading p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>
        <div class="section-heading">
            <?php if (!empty($settings['subtitle'])) : ?>
                <div class="section-heading__subtitle d-inline-flex align-items-center tw-gap-1 tw-mb-3">
                    <?php if($settings['subtitle_img']['url']) : ?>
                        <img src="<?php echo $settings['subtitle_img']['url']; ?>" alt="Image">
                    <?php endif; ?>
                    <h5 class="sub_title text-primary-600 fw-normal">
                        <?php echo $settings['subtitle']; ?>
                    </h5>
                </div>
            <?php endif; ?>
            <h2 class="fw-normal text-dark-600 h1 cursor-big aos-init aos-animate">
                <?php
                    $title = str_replace(['{c}', '{/c}'], ['<span>', '</span>'], $settings['title']);
                    print wp_kses($title, payone_core()->kses_allowed_html('all'));
                ?>
            </h2>
            <?php
                if(!empty($settings['content'])){ ?>
                    <p class="sec-text section-heading__desc"><?php echo $settings['content']; ?></p>
                <?php }
            ?>
        </div>
        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Payone_Section_Title_One_Widget());