<?php
/**
 * Elementor Widget
 * @package Payone
 * @since 1.0.0
 */

namespace Elementor;
class Payone_Contact_Box_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
    */
    public function get_name()
    {
        return 'payone-contact-box-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Contact Box', 'payone-core');
    }

    public function get_keywords()
    {
        return ['Section', 'Box', 'Contact', 'Payone'];
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-lightbox';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['payone_widgets'];
    }

    
    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'contact_box_section',
            [
                'label' => esc_html__('Contact Box Left', 'payone-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'icon_class',
            [
                'label' => esc_html__('icon class', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('ph ph-phone-call', 'payone-core'),
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Call US 24/7', 'payone-core'),
            ]
        );
        $this->add_control(
            'content',
            [
                'label' => esc_html__('Button Text', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('(205) 555-0100', 'payone-core'),
            ]
        );
        $this->add_control(
            'animation_duration_time',
            [
                'label' => esc_html__('animation duration', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('6', 'payone-core'),
            ]
        );
        $this->end_controls_section();
    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>

        <div class="group" data-aos="fade-up" data-aos-duration="<?php echo $settings['animation_duration_time']; ?>00">
            <div class="bg-white tw-py-10 tw-rounded-xl group-hover-bg-base-two-600 tw-duration-500">
                <?php if($settings['icon_class']) : ?>
                    <span class="tw-w-72-px tw-h-72-px bg-base-two-600 tw-text-8 text-white d-flex align-items-center justify-content-center tw-mb-6 rounded-circle mx-auto group-hover-bg-white tw-duration-500 group-hover-text-base-two-600">
                        <i class="<?php echo $settings['icon_class']; ?>"></i>
                    </span>
                <?php endif; ?>
                <div class="text-center">
                    <?php if($settings['title']) : ?>
                        <h4 class="fw-normal text-dark-600 tw-mb-2 tw-duration-500 group-hover-text-white"><?php echo $settings['title']; ?></h4>
                    <?php endif; ?>
                    <?php if($settings['content']) : ?>
                        <span class="fw-normal tw-text-md text-dark-500 tw-duration-500 group-hover-text-white "><?php echo $settings['content']; ?></span>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Payone_Contact_Box_Widget());