<?php
/**
 * Elementor Widget
 * @package payone
 * @since 1.0.0
 */

namespace Elementor;

class Payone_Blog_List_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'payone-blog-list-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Blog List', 'payone-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-slider-3d';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['payone_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'blog_settings_section',
            [
                'label' => esc_html__('Blog Settings', 'payone-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control('blog_style', [
            'label' => esc_html__('Blog style', 'payone-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'style-1' => esc_html__('Style 1', 'payone-core'),
                'style-2' => esc_html__('style 2', 'payone-core'),
                'style-3' => esc_html__('style 3', 'payone-core'),
                'style-4' => esc_html__('style 4', 'payone-core'),
            ),
            'default' => 'style-1',
            'description' => esc_html__('Select Blog Style', 'payone-core')
        ]);

        $this->add_control('blog_grid', [
            'label' => esc_html__('Blog Grid', 'payone-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'col-lg-3' => esc_html__('col-lg-2', 'payone-core'),
                'col-lg-3' => esc_html__('col-lg-3', 'payone-core'),
                'col-lg-4' => esc_html__('col-lg-4', 'payone-core'),
                'col-lg-6' => esc_html__('col-lg-6', 'payone-core'),
                'col-lg-12' => esc_html__('col-lg-12', 'payone-core'),
            ),
            'default' => 'col-lg-6',
            'description' => esc_html__('Select Blog Grid', 'payone-core')
        ]);
        $this->add_control('blog_grid_2', [
            'label' => esc_html__('Blog Grid md', 'payone-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'col-md-3' => esc_html__('col-md-2', 'payone-core'),
                'col-md-3' => esc_html__('col-md-3', 'payone-core'),
                'col-md-4' => esc_html__('col-md-4', 'payone-core'),
                'col-md-6' => esc_html__('col-md-6', 'payone-core'),
                'col-md-12' => esc_html__('col-md-12', 'payone-core'),
            ),
            'default' => 'col-md-6',
            'description' => esc_html__('Select Blog Grid', 'payone-core')
        ]);
        $this->add_control('read-btn', [
            'label' => esc_html__('Read More', 'payone-core'),
            'type' => Controls_Manager::TEXT,
            'description' => esc_html__('enter read button text', 'payone-core'),
            'default' => esc_html__('Read More', 'payone-core'),
        ]);
        $this->add_control('total', [
            'label' => esc_html__('Total Posts', 'payone-core'),
            'type' => Controls_Manager::TEXT,
            'default' => '-1',
            'description' => esc_html__('enter how many course you want in masonry , enter -1 for unlimited course.')
        ]);
        $this->add_control('category', [
            'label' => esc_html__('Category', 'payone-core'),
            'type' => Controls_Manager::SELECT2,
            'multiple' => true,
            'options' => payone()->get_terms_names('service-cat', 'id'),
            'description' => esc_html__('select category as you want, leave it blank for all category', 'payone-core'),
        ]);
        $this->add_control('order', [
            'label' => esc_html__('Order', 'payone-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'ASC' => esc_html__('Ascending', 'payone-core'),
                'DESC' => esc_html__('Descending', 'payone-core'),
            ),
            'default' => 'ASC',
            'description' => esc_html__('select order', 'payone-core')
        ]);
        $this->add_control('orderby', [
            'label' => esc_html__('OrderBy', 'payone-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'ID' => esc_html__('ID', 'payone-core'),
                'title' => esc_html__('Title', 'payone-core'),
                'date' => esc_html__('Date', 'payone-core'),
                'rand' => esc_html__('Random', 'payone-core'),
                'comment_count' => esc_html__('Most Comments', 'payone-core'),
            ),
            'default' => 'ID',
            'description' => esc_html__('select order', 'payone-core')
        ]);
        $this->end_controls_section();

        $this->start_controls_section(
            'blog_styling_settings_section',
            [
                'label' => esc_html__('Styling Settings', 'payone-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'image_height',
            [
                'label' => esc_html__('Image Height', 'sastek-core'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .blog-card-inner .articles-img' => 'height: {{SIZE}}{{UNIT}} !important;',
                ],
            ]
        );
        $this->end_controls_section();

    }


    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        
        //query settings
        $total_posts = $settings['total'];
        $category = $settings['category'];
        $order = $settings['order'];
        $orderby = $settings['orderby'];
        //setup query
        $args = array(
            'post_type' => 'post',
            'posts_per_page' => $total_posts,
            'order' => $order,
            'orderby' => $orderby,
            'post_status' => 'publish'
        );

        if (!empty($category)) {
            $args['tax_query'] = array(
                array(
                    'taxonomy' => 'category',
                    'field' => 'term_id',
                    'terms' => $category
                )
            );
        }
        $post_data = new \WP_Query($args);
        ?>
            
            <?php if($settings['blog_style'] == 'style-1') : ?>
                <div class="blog-area">
                    <div class="row">
                        <?php
                        while ($post_data->have_posts()) : $post_data->the_post();
                            //image condition here
                            $img_id = get_post_thumbnail_id(get_the_ID()) ? get_post_thumbnail_id(get_the_ID()) : false;
                            $img_url_val = $img_id ? wp_get_attachment_image_src($img_id, 'fixturbo_grid_blog_12', false) : '';
                            $img_url = is_array($img_url_val) && !empty($img_url_val) ? $img_url_val[0] : '';
                            $img_alt = get_post_meta($img_id, '_wp_attachment_image_alt', true);

                            $comments_count = get_comments_number(get_the_ID());
                            $comment_text = ($comments_count > 1) ? 'Comments (' . $comments_count . ')' : 'Comment (' . $comments_count . ')';
                            ?> 
                            
                            <div class="<?php echo esc_attr($settings['blog_grid']); ?> <?php echo esc_attr($settings['blog_grid_2']); ?>">
                                <div class="blog-card-inner tw-px-6 tw-py-6 bg-neutral-10 rounded-3" data-aos="fade-up" data-aos-duration="900">
                                    <?php if(!empty($img_url)) : ?>
                                        <span class="tw-mb-4 w-100 h-100">
                                            <img src="<?php echo esc_url($img_url); ?>" alt="Image" class="articles-img w-100 rounded-3 object-fit-cover">
                                        </span>
                                    <?php endif; ?>
                                    <div class="px-md-4 tw-pb-2">
                                        <div class="d-flex align-items-center tw-gap-4 flex-wrap justify-content-between tw-mb-6">
                                            <span class="d-flex align-items-center tw-gap-2">
                                                <span class="tw-text-6 text-dark-600">
                                                    <i class="ph ph-user"></i>
                                                </span>
                                                <span class="fw-normal tw-text-md text-dark-800 tt-capetalize"><?php payone()->posted_by(); ?></span>
                                            </span>
                                            <span class="d-flex align-items-center tw-gap-2">
                                                <span class="tw-text-6 text-dark-600">
                                                    <i class="ph ph-chat-text"></i>
                                                </span>
                                                <span class="fw-normal tw-text-md text-dark-800"><?php payone()->comment_count(); ?></span>
                                            </span>
                                        </div>
                                        <h3 class="fw-normal tw-mb-3 text-dark-600 cursor-big"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                                        <p class="fw-normal tw-text-lg text-dark-500 tw-mb-8">
                                            <?php echo wp_trim_words(get_the_content(), 15); ?>
                                        </p>
                                        <div class="position-relative z-1 max-w-160-px w-100">
                                            <a href="<?php the_permalink(); ?>" class="articles-view-link w-100 text-center tw-py-205 bg-main-600 rounded-3 text-dark-600 fw-semibold tw-text-lg hover-text-dark-600">
                                                <?php echo $settings['read-btn']; ?>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endwhile; ?>
                    </div>
                </div>
            <?php elseif($settings['blog_style'] == 'style-2') : ?>
                <div class="blog-area">
                    <div class="row">
                        <?php
                        while ($post_data->have_posts()) : $post_data->the_post();
                            //image condition here
                            $img_id = get_post_thumbnail_id(get_the_ID()) ? get_post_thumbnail_id(get_the_ID()) : false;
                            $img_url_val = $img_id ? wp_get_attachment_image_src($img_id, 'fixturbo_grid_blog_12', false) : '';
                            $img_url = is_array($img_url_val) && !empty($img_url_val) ? $img_url_val[0] : '';
                            $img_alt = get_post_meta($img_id, '_wp_attachment_image_alt', true);

                            $comments_count = get_comments_number(get_the_ID());
                            $comment_text = ($comments_count > 1) ? 'Comments (' . $comments_count . ')' : 'Comment (' . $comments_count . ')';
                            ?> 
                            <div class="<?php echo esc_attr($settings['blog_grid']); ?> <?php echo esc_attr($settings['blog_grid_2']); ?>">
                                <div class="blog-card-inner mb-4 blog-list-style-2 tw-px-3 tw-py-3 bg-neutral-10 rounded-3 d-flex align-items-center tw-gap-6 flex-wrap" data-aos="fade-up" data-aos-duration="1000">
                                    <?php if(!empty($img_url)) : ?>
                                        <img src="<?php echo esc_url($img_url); ?>" alt="Image" class="articles-img mb-md-0 mb-4 max-w-256 bg-img rounded-3 object-fit-cover">
                                    <?php endif; ?>
                                    <div class="articles-text max-w-320 tw-px-3 tw-py-5">
                                        <div class="d-flex align-items-center tw-gap-4 flex-wrap justify-content-between tw-mb-6">
                                            <span class="d-flex align-items-center tw-gap-2">
                                                <span class="tw-text-6 text-dark-600">
                                                    <i class="ph ph-user"></i>
                                                </span>
                                                <span class="fw-normal tw-text-md text-dark-800 tt-capetalize"><?php payone()->posted_by(); ?></span>
                                            </span>
                                            <span class="d-flex align-items-center tw-gap-2">
                                                <span class="tw-text-6 text-dark-600">
                                                    <i class="ph ph-chat-text"></i>
                                                </span>
                                                <span class="fw-normal tw-text-md text-dark-800"><?php payone()->comment_count(); ?></span>
                                            </span>
                                        </div>
                                        <h4 class="fw-normal tw-mb-3 text-dark-600 cursor-big line-clamp-2"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                                        <p class="fw-normal tw-text-lg text-dark-500 tw-mb-8">
                                            <?php echo wp_trim_words(get_the_content(), 10); ?>
                                        </p>
                                        <div class="position-relative z-1 max-w-160-px w-100">
                                            <a href="<?php the_permalink(); ?>" class="articles-view-link w-100 text-center tw-py-205 bg-main-600 rounded-3 text-dark-600 fw-semibold tw-text-lg hover-text-dark-600">
                                                <?php echo $settings['read-btn']; ?>
                                            </a>
                                        </div>
                                    </div>
                                </div> 
                            </div>
                        <?php endwhile; ?>
                    </div>
                </div>
            <?php elseif($settings['blog_style'] == 'style-3') : ?>
                <div class="blog-area">
                    <div class="row">
                        <?php
                        while ($post_data->have_posts()) : $post_data->the_post();
                            //image condition here
                            $img_id = get_post_thumbnail_id(get_the_ID()) ? get_post_thumbnail_id(get_the_ID()) : false;
                            $img_url_val = $img_id ? wp_get_attachment_image_src($img_id, 'fixturbo_grid_blog_12', false) : '';
                            $img_url = is_array($img_url_val) && !empty($img_url_val) ? $img_url_val[0] : '';
                            $img_alt = get_post_meta($img_id, '_wp_attachment_image_alt', true);

                            $comments_count = get_comments_number(get_the_ID());
                            $comment_text = ($comments_count > 1) ? 'Comments (' . $comments_count . ')' : 'Comment (' . $comments_count . ')';
                            ?>
                            <div class="<?php echo esc_attr($settings['blog_grid']); ?> <?php echo esc_attr($settings['blog_grid_2']); ?>">
                                <div class="blog-card-inner position-relative z-1 mb-5" data-aos="fade-up" data-aos-duration="800">
                                    <?php if(!empty($img_url)) : ?>
                                        <img src="<?php echo esc_url($img_url); ?>" alt="Image" class="articles-img rounded-3 w-100 h-100 object-fit-cover">
                                    <?php endif; ?>
                                    <?php
                                    $categories = get_the_category();
                                    if ( ! empty( $categories ) ) { ?>
                                        <span class="tw-px-3 tw-py-2 bg-main-600 tw-rounded-md fw-normal tw-text-4 text-dark-600 position-absolute inset-inline-start-24px inset-block-start-24px">
                                            <?php
                                                $first_category = $categories[0];
                                                echo $first_category->name;
                                            ?>
                                        </span>
                                    <?php } ?>
                                    <div class="position-relative z-1 margin-block-start--87px">
                                        <div class="articles-bank-card tw-px-6 tw-py-6 bg-white tw-rounded-xl text-center justify-content-center max-w-368 border-bottom-base-two-600 mx-auto">
                                            <h4 class="fw-normal text-dark-600 tw-mb-6 line-clamp-2"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                                            <a href="<?php the_permalink(); ?>" class="bg-neutral-10 tw-px-6 tw-py-205 fw-bold tw-text-4 text-dark-600 w-100 d-flex align-items-center justify-content-center hover-text-white hover-bg-base-two-600 tw-transition-04-secend tw-rounded-xl">
                                                <?php echo $settings['read-btn']; ?>
                                            </a>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        <?php endwhile; ?>
                    </div>
                </div>
            <?php elseif($settings['blog_style'] == 'style-4') : ?>
                <h2>style 4</h2>
            <?php endif; ?>
            
        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Payone_Blog_List_Widget());