<?php
/**
 * Elementor Widget
 * @package payone
 * @since 1.0.0
 */

namespace Elementor;

class Payone_Banner_Two_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'payone-banner-two';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Banner 02', 'payone-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-slides';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['payone_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content Settings', 'payone-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'banner_subtitle_img', [
                'label' => esc_html__('subtitle Image', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
                'description' => esc_html__('subtitle Image', 'payone-core'),
            ]
        );
        $this->add_control(
            'banner_subtitle', [
                'label' => esc_html__('Subtitle', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Trusted by over 3M customers', 'payone-core'),
            ]
        );
        $this->add_control(
            'banner_title',
            [
                'label' => esc_html__('Title', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Send Money Anytime, Anywhere', 'payone-core'),
            ]
        );
        $this->add_control(
            'banner_title_img', [
                'label' => esc_html__('title Image', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
                'description' => esc_html__('title Image', 'payone-core'),
            ]
        );
        $this->add_control(
            'banner_description',
            [
                'label' => esc_html__('Description', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Effortlessly send, receive, and request money online with paynone. Get a tailored solution for your business needs.', 'payone-core'),
            ]
        );
        $this->add_control(
            'btn_text', [
                'label' => esc_html__('btn text', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('OPEN A FREE ACCOUNT', 'payone-core'),
            ]
        );
        $this->add_control(
            'btn_url',
            [
                'label' => esc_html__('btn url', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('#', 'payone-core'),
            ]
        );
        $this->add_control(
            'btn2_text', [
                'label' => esc_html__('btn Two text', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('HOW IT WORKS', 'payone-core'),
            ]
        );
        $this->add_control(
            'btn2_url',
            [
                'label' => esc_html__('btn Two url', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('#', 'payone-core'),
            ]
        );
        $this->add_control(
            'banner_shortcode',
            [
                'label' => esc_html__('banner shortcode', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'animation_section',
            [
                'label' => esc_html__('Animation Settings', 'payone-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'animate_img1', [
                'label' => esc_html__('animate img 1', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
                'description' => esc_html__('animate img 1', 'payone-core'),
            ]
        );
        $this->add_control(
            'animate_img2', [
                'label' => esc_html__('animate img 2', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
                'description' => esc_html__('animate img 2', 'payone-core'),
            ]
        );
        $this->add_control(
            'animate_img3', [
                'label' => esc_html__('animate img 3', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
                'description' => esc_html__('animate img 3', 'payone-core'),
            ]
        );
        $this->add_control(
            'animate_img4', [
                'label' => esc_html__('animate img 4', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
                'description' => esc_html__('animate img 4', 'payone-core'),
            ]
        );
        $this->add_control(
            'animate_img5', [
                'label' => esc_html__('animate img 5', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
                'description' => esc_html__('animate img 5', 'payone-core'),
            ]
        );
        $this->add_control(
            'animate_img6', [
                'label' => esc_html__('animate img 6', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
                'description' => esc_html__('animate img 6', 'payone-core'),
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'banner_styling_settings_section',
            [
                'label' => esc_html__('Styling Settings', 'payone-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->end_controls_section();

    }


    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display(); ?>

        <div class="bg-base-two-600 py-120 position-relative z-1 overflow-hidden">
            <?php if($settings['animate_img1']['url']) : ?>
                <img src="<?php echo $settings['animate_img1']['url']; ?>" alt="Image" class="position-absolute z-n1 inset-block-start-100px inset-inline-start-157px d-lg-block d-none animation-Updowm__two">
            <?php endif; ?>
            <?php if($settings['animate_img2']['url']) : ?>
                <img src="<?php echo $settings['animate_img2']['url']; ?>" alt="Image" class="banner-two-shape-three position-absolute z-n1 inset-inline-start-42-persent inset-block-start-162px rotate--22deg d-lg-block d-none animate-wobble__two">
            <?php endif; ?>
            <?php if($settings['animate_img3']['url']) : ?>
                <img src="<?php echo $settings['animate_img3']['url']; ?>" alt="Image" class="position-absolute z-n1 inset-inline-end-64px inset-block-start-164px  d-lg-block d-none animation-roatation-two__two">
            <?php endif; ?>
            <?php if($settings['animate_img4']['url']) : ?>
                <img src="<?php echo $settings['animate_img4']['url']; ?>" alt="Image" class="position-absolute z-n1 inset-block-end-99px inset-inline-start-87px  d-lg-block d-none animation-Updowm__two">
            <?php endif; ?>
            <?php if($settings['animate_img6']['url']) : ?>
                <img src="<?php echo $settings['animate_img6']['url']; ?>" alt="Image" class="position-absolute z-n1 inset-block-end-103px inset-inline-end-103px  d-lg-block d-none animation-rotation__two">
            <?php endif; ?>
            
            <div class="container">
                <div class="row gy-4 align-items-center">

                    <div class="col-lg-7">
                        <div class="position-relative z-1">
                            <div>
                                <?php if($settings['banner_subtitle']) : ?>
                                    <div class="d-flex align-items-center tw-gap-1 tw-mb-3" data-aos="fade-up" data-aos-duration="600">
                                        <?php if($settings['banner_subtitle_img']['url']) : ?>
                                            <img src="<?php echo $settings['banner_subtitle_img']['url']; ?>" alt="star">
                                        <?php endif; ?>
                                        <h5 class="fw-normal text-white"><?php echo $settings['banner_subtitle']; ?></h5>
                                    </div>
                                <?php endif; ?>
                                <?php if($settings['banner_title']) : ?>
                                    <div class="position-relative" data-aos="fade-up" data-aos-duration="800">
                                        <h2 class="banner-two-title tw-text-70-px text-white fw-normal tw-mb-3 cursor-big">
                                            <?php echo $settings['banner_title']; ?>
                                            <?php if($settings['banner_title_img']['url']) : ?>
                                                <img src="<?php echo $settings['banner_title_img']['url']; ?>" alt="Image" class="banner-two-shape-one position-absolute z-n1 inset-block-start-82px inset-inline-end-26px d-lg-block d-none">
                                            <?php endif; ?>
                                        </h2>
                                    </div>
                                <?php endif; ?>
                                <?php if($settings['banner_description']) : ?>
                                    <p class="fw-normal tw-text-lg text-neutral-10 max-w-570 tw-mb-10" data-aos="fade-up" data-aos-duration="1000"><?php echo $settings['banner_description']; ?></p>
                                <?php endif; ?>
                                <div class="d-flex align-items-center tw-gap-805 flex-wrap" data-aos="fade-up" data-aos-duration="1200">
                                    <?php if($settings['btn_text']) : ?>
                                        <div class="position-relative z-1">
                                            <a href="<?php echo $settings['btn_url']; ?>" class="banner-two-link bg-main-600 fw-semibold tw-text-lg text-dark-600 tw-px-8 tw-py-3 rounded-3 border-two-px-solid hover-text-dark-600">
                                                <?php echo $settings['btn_text']; ?>
                                            </a>
                                        </div>
                                    <?php endif; ?>
                                    <?php if($settings['btn2_text']) : ?>
                                        <a href="<?php echo $settings['btn2_url']; ?>" class="fw-semibold tw-text-lg text-white hover-text-main-600">
                                            <?php echo $settings['btn2_text']; ?>
                                        </a>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <?php if($settings['animate_img5']['url']) : ?>
                                <img src="<?php echo $settings['animate_img5']['url']; ?>" alt="Image" class="position-absolute z-n1 inset-block-end-103px inset-inline-end-103px  d-lg-block d-none animation-rotation__two">
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php if(!empty($settings['banner_shortcode'])) : ?>
                        <div class="col-lg-5 mt-lg-0 mt-5">
                            <?php echo do_shortcode($settings['banner_shortcode']); ?>  
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <?php
    }
}
Plugin::instance()->widgets_manager->register_widget_type(new Payone_Banner_Two_Widget());