<?php
/**
 * Elementor Widget
 * @package payone
 * @since 1.0.0
 */

namespace Elementor;

class Payone_Banner_Three_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'payone-banner-three';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Banner 03', 'payone-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-slides';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['payone_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content Settings', 'payone-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'banner_subtitle_img', [
                'label' => esc_html__('subtitle Image', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
                'description' => esc_html__('subtitle Image', 'payone-core'),
            ]
        );
        $this->add_control(
            'banner_subtitle', [
                'label' => esc_html__('Subtitle', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Banking Platform', 'payone-core'),
            ]
        );
        $this->add_control(
            'banner_title',
            [
                'label' => esc_html__('Title', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Revolutionize Your Banking with Next-Gen Digital Solutions', 'payone-core'),
            ]
        );
        $this->add_control(
            'banner_title_img', [
                'label' => esc_html__('title Image', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
                'description' => esc_html__('title Image', 'payone-core'),
            ]
        );
        $this->add_control(
            'banner_description',
            [
                'label' => esc_html__('Description', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Transform your banking experience with our innovative, next-generation digital solutions that empower secure, smart financial transactions.', 'payone-core'),
            ]
        );
        $this->add_control(
            'btn_text', [
                'label' => esc_html__('btn text', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('GET STARTED', 'payone-core'),
            ]
        );
        $this->add_control(
            'btn_url',
            [
                'label' => esc_html__('btn url', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('#', 'payone-core'),
            ]
        );
        $this->add_control(
            'btn2_text', [
                'label' => esc_html__('btn 2 text', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('ABOUT US', 'payone-core'),
            ]
        );
        $this->add_control(
            'btn2_url',
            [
                'label' => esc_html__('btn 2 url', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('#', 'payone-core'),
            ]
        );
        $this->add_control(
            'main_img', [
                'label' => esc_html__('Banner Main Image', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
                'description' => esc_html__('Banner Main Image', 'payone-core'),
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'animation_section',
            [
                'label' => esc_html__('Animation Settings', 'payone-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'animate_img1', [
                'label' => esc_html__('animate img 1', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
                'description' => esc_html__('animate img 1', 'payone-core'),
            ]
        );
        $this->add_control(
            'animate_img2', [
                'label' => esc_html__('animate img 2', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
                'description' => esc_html__('animate img 2', 'payone-core'),
            ]
        );
        $this->add_control(
            'animate_img3', [
                'label' => esc_html__('animate img 3', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
                'description' => esc_html__('animate img 3', 'payone-core'),
            ]
        );
        $this->add_control(
            'scroll_down', [
                'label' => esc_html__('scroll down', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
                'description' => esc_html__('scroll down', 'payone-core'),
            ]
        );

        $this->add_control(
            'award_img', [
                'label' => esc_html__('award img', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
                'description' => esc_html__('award Image', 'payone-core'),
            ]
        );
        $this->add_control(
            'award_subtitle', [
                'label' => esc_html__('award_subtitle', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Payment Received', 'payone-core'),
            ]
        );
        $this->add_control(
            'award_count', [
                'label' => esc_html__('award_count', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('+35,890.00', 'payone-core'),
            ]
        );
        $this->add_control(
            'award_title', [
                'label' => esc_html__('award_title', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('1st Jan, 2025 3.09%', 'payone-core'),
            ]
        );

        $this->add_control(
            'user_img', [
                'label' => esc_html__('user img', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
                'description' => esc_html__('user img', 'payone-core'),
            ]
        );
        $this->add_control(
            'user_title', [
                'label' => esc_html__('user_title', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('25k+', 'payone-core'),
            ]
        );
        $this->add_control(
            'user_h_title', [
                'label' => esc_html__('user hilight title', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Active users', 'payone-core'),
            ]
        );

        $this->add_control(
            'counter_number1', [
                'label' => esc_html__('counter number1', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('7m', 'payone-core'),
            ]
        );
        $this->add_control(
            'counter_title1', [
                'label' => esc_html__('user title 1', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Active users around the world', 'payone-core'),
            ]
        );
        $this->add_control(
            'counter_number2', [
                'label' => esc_html__('counter number2', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('33+', 'payone-core'),
            ]
        );
        $this->add_control(
            'counter_title2', [
                'label' => esc_html__('user title 2', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Total dolly transections', 'payone-core'),
            ]
        );
        $this->add_control(
            'video_url', [
                'label' => esc_html__('Vide Url', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('#', 'payone-core'),
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'banner_styling_settings_section',
            [
                'label' => esc_html__('Styling Settings', 'payone-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->end_controls_section();

    }


    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        echo '
            <script>
                jQuery(document).ready(function($) {
                    var swiper = new Swiper(".banner-brand-swiper", {
                        slidesPerView: 7,
                        loop: true,
                        autoplay: {
                            delay: 4000,
                            disableOnInteraction: false,
                        },
                        breakpoints: {
                            320: {
                            slidesPerView: 3,
                            },
                            524: {
                            slidesPerView: 3,
                            },
                            640: {
                            slidesPerView: 4,
                            },
                            768: {
                            slidesPerView: 5,
                            },
                            1024: {
                            slidesPerView: 6,
                            },
                            1199: {
                            slidesPerView: 7,
                            },
                        },
                    });
                });
            </script>';
        ?>

        <div class="pt-120 z-1 position-relative overflow-hidden">
            <div class="tw-mb-96px">
                <?php if($settings['scroll_down']['url']) : ?>
                    <img src="<?php echo $settings['scroll_down']['url']; ?>" alt="Image" class="position-absolute tw-end-0 bottom-0 tw-me-15 tw-mb-182-px z-n1 d-xl-block d-none animation-Updowm__two">
                <?php endif; ?>
                <?php if($settings['animate_img2']['url']) : ?>
                    <img src="<?php echo $settings['animate_img2']['url']; ?>" alt="Image" class="position-absolute z-n1 tw-end-23 tw-block-start-200-px  d-xl-block d-none animation-rotation__two">
                <?php endif; ?>
                <?php if($settings['video_url']) : ?>
                    <div class="d-xl-block d-none">
                        <a href="<?php echo $settings['video_url']; ?>" class="play-button tw-w-140px tw-h-140-px border-neutral-35-6px bg-neutral-40 rounded-circle d-flex align-items-center justify-content-center zn-9 position-absolute tw-end-0 bottom-0 tw-mb-214-px tw-me-290-px ">
                            <span class="tw-w-80-px tw-h-80-px bg-base-two-600 rounded-circle tw-text-6 text-white d-flex align-items-center justify-content-center">
                                <i class="ph-fill ph-play"></i>
                            </span>
                        </a>
                    </div>
                <?php endif; ?>
            
                <div class="container max-w-1640">
                    <div class="position-relative">
                        <div class="row flex-wrap gy-4">
                            <div class="col-xl-6">
                                <div class="max-w-667">
                                    <div class="tw-mb-120-px position-relative">
                                        <div>
                                            <div class="tw-mb-10">
                                                <?php if($settings['banner_subtitle']) : ?>
                                                    <div class="d-flex align-items-center gap-1 tw-mb-3" data-aos="fade-up" data-aos-duration="800">
                                                        <?php if($settings['banner_subtitle_img']['url']) : ?>
                                                            <img src="<?php echo $settings['banner_subtitle_img']['url']; ?>" alt="star">
                                                        <?php endif; ?>
                                                        <h5 class="fw-normal text-base-two-600 cursor-big"><?php echo $settings['banner_subtitle']; ?></h5>
                                                    </div>
                                                <?php endif; ?>
                                                <?php if($settings['banner_title']) : ?>
                                                    <div class="position-relative" data-aos="fade-up" data-aos-duration="800">
                                                        <h2 class="banner-item-title h1 text-dark-600 fw-normal tw-mb-3 tw-text-15 cursor-big">
                                                            <?php echo $settings['banner_title']; ?>
                                                            <?php if($settings['banner_title_img']['url']) : ?>
                                                                <img src="<?php echo $settings['banner_title_img']['url']; ?>" alt="Image" class="banner-shape-three-one position-absolute z-n1 tw-block-start-130-px tw-start-58 d-lg-block d-none">
                                                            <?php endif; ?>
                                                        </h2>
                                                    </div>
                                                <?php endif; ?>
                                                <?php if($settings['banner_description']) : ?>
                                                    <p class="banner-item-text text-dark-500 fw-normal tw-text-xl line-clamp-2"  data-aos="fade-up" data-aos-duration="1100"><?php echo $settings['banner_description']; ?></p>
                                                <?php endif; ?>
                                            </div>
                                            <div class="d-flex align-items-center tw-gap-6 flex-wrap" data-aos="fade-up" data-aos-duration="1200">
                                                <?php if($settings['btn_text']) : ?>
                                                    <div class="position-relative">
                                                        <a href="<?php echo $settings['btn_url']; ?>" class="banner-three-item-link bg-main-600 text-dark-600 fw-semibold tw-text-lg tw-px-5 tw-py-3 border-two-px-solid rounded-3 hover-text-dark-600">
                                                            <?php echo $settings['btn_text']; ?>
                                                        </a>
                                                    </div>
                                                <?php endif; ?>
                                                <?php if($settings['btn2_text']) : ?>
                                                    <div class="position-relative">
                                                        <a href="<?php echo $settings['btn2_url']; ?>" class="banner-three-item-2-link bg-warning-500 text-dark-600 fw-semibold tw-text-lg tw-px-5 tw-py-3 border-two-px-solid rounded-3 hover-text-dark-600">
                                                            <?php echo $settings['btn2_text']; ?>
                                                        </a>
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                        <?php if($settings['animate_img3']['url']) : ?>
                                            <img src="<?php echo $settings['animate_img3']['url']; ?>" alt="Image" class="position-absolute bottom-0 tw-end-100-px tw-mb--30px z-n1 d-xl-block d-none animation-rotation__two">
                                        <?php endif; ?>
                                        <?php if($settings['animate_img1']['url']) : ?>
                                            <img src="<?php echo $settings['animate_img1']['url']; ?>" alt="img" class="position-absolute z-n1 tw-end--110-px tw-block-start--9 tw-rotate--7deg d-xl-block d-none animate-wobble__two">
                                        <?php endif; ?>
                                    </div>
            
                                    <div class="d-flex align-items-center tw-gap-12 tw-mb-15 flex-wrap">
                                        <div class="d-flex align-items-center tw-gap-5 flex-wrap" data-aos="fade-up" data-aos-duration="1300">
                                            <?php if($settings['award_img']['url']) : ?>
                                                <img src="<?php echo $settings['award_img']['url']; ?>" alt="star">
                                            <?php endif; ?>
                                            <div class="">
                                                <span class="fw-normal tw-text-lg text-dark-500 tw-mb-205 d-block">Award Winning Bank</span>
                                                <span class="fw-normal tw-text-lg text-dark-500 d-flex align-items-center">
                                                    <span class="fw-bold tw-text-2xl text-base-two-600">14M+</span>
                                                    Active Clients
                                                </span>
                                            </div>
                                        </div>
                                        <div data-aos="fade-up" data-aos-duration="1400">
                                            <?php if($settings['user_img']['url']) : ?>
                                                <div class="d-flex align-items-center tw-mb-2">
                                                    <img src="<?php echo $settings['user_img']['url']; ?>" alt="Image" class="tw-hover-z-2 tw-duration-400">
                                                </div>
                                            <?php endif; ?>
                                            <span class="fw-normal tw-text-lg text-dark-500">
                                                OVER 20.8k+
                                                <span class="fw-semibold border-bottom-dark-500">
                                                    Reviews
                                                </span>
                                            </span>
                                        </div>
                                    </div>
            
                                </div>
                            </div>
                            
                            <?php if($settings['main_img']['url']) : ?>
                                <div class="col-xl-3 col-lg-6">
                                    <div class="d-xl-block d-none text-end">
                                        <img src="<?php echo $settings['main_img']['url']; ?>" alt="img" class="margin-top--40px" data-aos="zoom-in" data-aos-duration="1500">
                                    </div>
                                </div>
                            <?php endif; ?>
            
                            <div class="col-xl-3 col-lg-6">
                                <div class="banner-three-item margin-left-200px d-xl-block d-none">
                                    <div class="max-w-185 tw-mb-12">
                                        <h2 class="fw-normal h1 cursor-big tw-mb-1 counter">5K+</h2>
                                        <span class="fw-normal tw-text-lg text-dark-500">Active business accounts </span>
                                    </div>
                                    <div class="max-w-185">
                                        <h2 class="fw-normal h1 cursor-big tw-mb-1 counter">1.8M+</h2>
                                        <span class="fw-normal tw-text-lg text-dark-500">International transfers</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <?php
    }
}
Plugin::instance()->widgets_manager->register_widget_type(new Payone_Banner_Three_Widget());