<?php
/**
 * Elementor Widget
 * @package payone
 * @since 1.0.0
 */

namespace Elementor;

class Payone_Banner_Slider_One_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'payone-banner-slider-one';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Banner Slider 01', 'payone-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-slides';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['payone_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'slider_settings_section',
            [
                'label' => esc_html__('Slider Settings', 'payone-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'bg_image', [
                'label' => esc_html__('Banner Backgrount Image', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('Banner Backgrount Image', 'payone-core'),
            ]
        );
        $repeater->add_control(
            'subtitle', [
                'label' => esc_html__('Subtitle', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Safe Transportation & Logistics', 'payone-core'),
            ]
        );
        $repeater->add_control(
            'banner_title',
            [
                'label' => esc_html__('Title', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Flexible logistics Fast Delivery & secure package', 'payone-core'),
            ]
        );
        $repeater->add_control(
            'banner_description',
            [
                'label' => esc_html__('Description', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Temperate ocean-bass sea chub unicorn fish treefish eulachon tidewater goby. Flier, bighe carp Devario shortnose sucker platy small eye', 'payone-core'),
            ]
        );
        $repeater->add_control(
            'show_button1',
            [
                'label' => __( 'Show / Hide Button One', 'payone-core' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'payone-core' ),
                'label_off' => __( 'Hide', 'payone-core' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $repeater->add_control(
            'button_text',
            [
                'label' => __( 'Button Text', 'payone-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => __( 'Read More', 'payone-core' ),
                'label_block' => true,
                'default' => __( 'View services', 'payone-core' ),
            ]
        );
        $repeater->add_control(
            'button_url',
            [
                'label' => __( 'Button Link', 'payone-core' ),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __( 'Enter Your Link Here', 'payone-core' ),
            ]
        );
        $repeater->add_control(
            'show_button2',
            [
                'label' => __( 'Show / Hide Button Two', 'payone-core' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'payone-core' ),
                'label_off' => __( 'Hide', 'payone-core' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $repeater->add_control(
            'button_text2',
            [
                'label' => __( 'Button2 Text', 'payone-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => __( 'Read More', 'payone-core' ),
                'label_block' => true,
                'default' => __( 'Who we are', 'payone-core' ),
            ]
        );
        $repeater->add_control(
            'button_url2',
            [
                'label' => __( 'Button Link', 'payone-core' ),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __( 'Enter Your Link Here', 'payone-core' ),
            ]
        );
        $this->add_control('banner_items', [
            'label' => esc_html__('Banner Slider Item', 'payone-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'image' => array(
                        'url' => Utils::get_placeholder_image_src()
                    )
                ]
            ],
        ]);
        $this->add_control(
            'shape_img1', [
                'label' => esc_html__('Airplane', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => true,
            ]
        );
        $this->add_control(
            'shape_img2', [
                'label' => esc_html__('Triangle', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => true,
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'slider_control_section',
            [
                'label' => esc_html__('Slider Settings', 'payone-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control('nav_position', [
            'label' => esc_html__('Nav Position', 'payone-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'style-1' => esc_html__('default', 'payone-core'),
                'slider-control-right-top' => esc_html__('Top Right', 'payone-core'),
            ),
            'default' => 'style-1',
            'description' => esc_html__('Select price style', 'payone-core')
        ]);
        $this->add_control(
            'items',
            [
                'label' => esc_html__('slidesToShow', 'payone-core'),
                'type' => Controls_Manager::NUMBER,
                'description' => esc_html__('you can set how many item show in slider', 'payone-core'),
                'default' => '1',
            ]
        );
        $this->add_control(
            'loop',
            [
                'label' => esc_html__('Loop', 'payone-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'payone-core'),
            ]
        );
        $this->add_control(
            'autoplay',
            [
                'label' => esc_html__('Autoplay', 'payone-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'payone-core'),
            ]
        );
        $this->add_control(
            'nav',
            [
                'label' => esc_html__('Nav', 'payone-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'payone-core'),
                'default' => 'yes'
            ]
        );
        $this->add_control(
            'nav_left_arrow',
            [
                'label' => esc_html__('Nav Left Icon', 'payone-core'),
                'type' => Controls_Manager::ICONS,
                'description' => esc_html__('you can set yes/no to enable/disable', 'payone-core'),
                'default' => [
                    'value' => 'fas fa-angle-left',
                    'library' => 'solid',
                ],
                'condition' => ['nav' => 'yes']
            ]
        );
        $this->add_control(
            'nav_right_arrow',
            [
                'label' => esc_html__('Nav Right Icon', 'payone-core'),
                'type' => Controls_Manager::ICONS,
                'description' => esc_html__('you can set yes/no to enable/disable', 'payone-core'),
                'default' => [
                    'value' => 'fas fa-angle-right',
                    'library' => 'solid',
                ],
                'condition' => ['nav' => 'yes']
            ]
        );
        $this->add_control(
            'center',
            [
                'label' => esc_html__('Center', 'payone-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'payone-core'),

            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'banner_styling_settings_section',
            [
                'label' => esc_html__('Styling Settings', 'payone-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control('subtitle_color', [
            'label' => esc_html__('Subtitle Color', 'payone-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .banner-content h5.text-yellow-600" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Subtitle Typography', 'payone-core'),
            'name' => 'subtitle_typography',
            'description' => esc_html__('Subtitle Typography', 'payone-core'),
            'selector' => "{{WRAPPER}} .banner-content h5.text-yellow-600"
        ]);
        $this->add_control('title_color', [
            'label' => esc_html__('Title Color', 'payone-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .banner-content h1.text-white" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Title Typography', 'payone-core'),
            'name' => 'title_typography',
            'description' => esc_html__('Title Typography', 'payone-core'),
            'selector' => "{{WRAPPER}} .banner-content h1.mb-24.text-white"
        ]);
        $this->add_control('brand_color', [
            'label' => esc_html__('Title Brant Color', 'payone-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .banner-content h1 span.text-yellow-600" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_control('description_color', [
            'label' => esc_html__('Description Color', 'payone-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .banner-content p.text-white" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Description Typography', 'payone-core'),
            'name' => 'description_typography',
            'description' => esc_html__('Description Typography', 'payone-core'),
            'selector' => "{{WRAPPER}} .banner-content p"
        ]);

        $this->end_controls_section();

    }


    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $all_banner_items = $settings['banner_items'];

        $rand_numb = rand(333, 999999999);
        //slider settings
        $slider_settings = [
            "loop" => esc_attr($settings['loop']),
            "items" => esc_attr($settings['items'] ?? 1),
            "center" => esc_attr($settings['center']),
            "autoplay" => esc_attr($settings['autoplay']),
            "nav" => esc_attr($settings['nav']),
            "navleft" => payone_core()->render_elementor_icons($settings['nav_left_arrow']),
            "navright" => payone_core()->render_elementor_icons($settings['nav_right_arrow'])
        ];
        
        ?>
        
       
            <div class="banner position-relative overflow-hidden">
                <?php if($settings['shape_img1']['url']) : ?>
                    <img src="<?php echo $settings['shape_img1']['url']; ?>" alt="img" class="planeSmall cursor-big position-absolute top-0 tw-start-0 tw-mt-134-px z-index-1 d-xxl-block d-none">
                <?php endif; ?>
                <?php if($settings['shape_img2']['url']) : ?>
                    <img src="<?php echo $settings['shape_img2']['url']; ?>" alt="img" class="position-absolute bottom-0 tw-start-0 z-index-1 d-lg-block d-none">
                <?php endif; ?>

                <div class="banner-slider-one">
                    <div class="banner-slider">
                        <div class="swiper-wrapper">
                        <?php foreach ($all_banner_items as $banner_item): ?>
                            <div class="swiper-slide">
                                <img src="<?php echo $banner_item['bg_image']['url']; ?>" alt="" class="scale-bg position-absolute top-0 tw-start-0 z-n1 w-100 h-100 object-fit-cover">
                                <div class="banner-item z-2 position-relative">
                                    <div class="tw-container-1540-px mx-auto tw-px-4">
                                        <div class="position-relative">
                                            <div class="container">
                                                <div class="row">
                                                    <div class="col-lg-7">
                                                        <?php if($banner_item['subtitle']) : ?>
                                                            <span class="splitTextStyleTwo cursor-small text-main-600 fw-bold fst-italic tw-text-lg text-decoration-underline tw-mb-5"><?php echo $banner_item['subtitle']; ?></span>
                                                        <?php endif; ?>
                                                        <?php if($banner_item['banner_title']) : ?>
                                                            <h1 class="splitTextStyleOne cursor-big text-white tw-text-80-px"><?php echo $banner_item['banner_title']; ?></h1>
                                                        <?php endif; ?>
                                                        <div class="d-flex tw-gap-11 tw-mt-13 flex-wrap">
                                                            <?php if( 'yes'===$banner_item['show_button1'] ){ ?>
                                                                <a href="<?php echo esc_url($banner_item['button_url']['url']); ?>" class="cursor-small btn btn-main hover-style-two button--stroke tw-py-405 d-inline-flex align-items-center justify-content-center tw-gap-5 group active--translate-y-2" data-block="button">
                                                                    <span class="button__flair"></span>
                                                                    <span class="button__label"><?php echo $banner_item['button_text']; ?></span>
                                                                    <span class="tw-w-7 tw-h-7 bg-white text-main-600 tw-text-sm tw-rounded d-flex justify-content-center align-items-center position-relative group-hover-bg-main-600 group-hover-text-white tw-duration-500">
                                                                        <i class="ph-bold ph-check"></i>
                                                                    </span>
                                                                </a>
                                                            <?php } ?>
                                                            <?php if( 'yes'===$banner_item['show_button2'] ){ ?>
                                                                <a href="<?php echo esc_url($banner_item['button_url2']['url']); ?>" class="cursor-small d-inline-flex align-items-center tw-gap-2 text-white fw-semibold hover-text-main-600 group active--translate-y-2" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="400">
                                                                    <?php echo $banner_item['button_text2']; ?>
                                                                    <span class="text-main-600 d-flex group-hover-text-white tw-duration-200 tw-text-base">
                                                                        <i class="ph-fill ph-caret-circle-right"></i>
                                                                    </span>
                                                                </a>
                                                            <?php } ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <?php if($banner_item['banner_description']) : ?>
                                                <div class="cursor-big bg-blur-one tw-rounded-lg max-w-520-px px-xxl-5 px-lg-4 px-3 py-lg-5 py-4 tw-ms-auto tw-mt-3">
                                                    <span class="triangle-shape tw-w-10 tw-h-10 bg-main-600 position-absolute tw-start-0 bottom-0"></span>
                                                    <p class="text-white tw-text-lg line-clamp-3"><?php echo $banner_item['banner_description']; ?></p>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>  
                            </div>
                            <?php endforeach; ?>
                        </div>
                    </div> nm 
                </div>
            </div>
        <?php
    }
}
Plugin::instance()->widgets_manager->register_widget_type(new Payone_Banner_Slider_One_Widget());