<?php
/**
 * Elementor Widget
 * @package payone
 * @since 1.0.0
 */

namespace Elementor;

class Payone_Banner_One_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'payone-banner-one';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Banner 01', 'payone-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-slides';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['payone_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content Settings', 'payone-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'banner_subtitle_img', [
                'label' => esc_html__('subtitle Image', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
                'description' => esc_html__('subtitle Image', 'payone-core'),
            ]
        );
        $this->add_control(
            'banner_subtitle', [
                'label' => esc_html__('Subtitle', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('EASY PAYMENT', 'payone-core'),
            ]
        );
        $this->add_control(
            'banner_title',
            [
                'label' => esc_html__('Title', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Fast, Secure, & Easy Transactions.', 'payone-core'),
            ]
        );
        $this->add_control(
            'banner_title_img', [
                'label' => esc_html__('title Image', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
                'description' => esc_html__('title Image', 'payone-core'),
            ]
        );
        $this->add_control(
            'banner_description',
            [
                'label' => esc_html__('Description', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Effortlessly send, receive, and request money online with paynone. Get a tailored solution for your business needs.', 'payone-core'),
            ]
        );
        $this->add_control(
            'btn_text', [
                'label' => esc_html__('btn text', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('MAKE AN APPOINTMENT', 'payone-core'),
            ]
        );
        $this->add_control(
            'btn_url',
            [
                'label' => esc_html__('btn url', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('#', 'payone-core'),
            ]
        );
        $this->add_control(
            'btn2_text', [
                'label' => esc_html__('btn Video text', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('WATCH VIDEO', 'payone-core'),
            ]
        );
        $this->add_control(
            'btn2_url',
            [
                'label' => esc_html__('btn Video url', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('https://www.youtube.com/watch?v=MFLVmAE4cqg', 'payone-core'),
            ]
        );
        $this->add_control(
            'main_img', [
                'label' => esc_html__('Banner Main Image', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
                'description' => esc_html__('Banner Main Image', 'payone-core'),
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'animation_section',
            [
                'label' => esc_html__('Animation Settings', 'payone-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'scroll_down', [
                'label' => esc_html__('scroll down', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
                'description' => esc_html__('scroll down', 'payone-core'),
            ]
        );
        $this->add_control(
            'animate_img1', [
                'label' => esc_html__('animate img 1', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
                'description' => esc_html__('animate img 1', 'payone-core'),
            ]
        );
        $this->add_control(
            'animate_img2', [
                'label' => esc_html__('animate img 2', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
                'description' => esc_html__('animate img 2', 'payone-core'),
            ]
        );
        $this->add_control(
            'animate_img3', [
                'label' => esc_html__('animate img 3', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
                'description' => esc_html__('animate img 3', 'payone-core'),
            ]
        );
        $this->add_control(
            'animate_img4', [
                'label' => esc_html__('animate img 4', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
                'description' => esc_html__('animate img 4', 'payone-core'),
            ]
        );

        $this->add_control(
            'payment_subtitle', [
                'label' => esc_html__('payment_subtitle', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Payment Received', 'payone-core'),
            ]
        );
        $this->add_control(
            'payment_title', [
                'label' => esc_html__('payment_title', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('+35,890.00', 'payone-core'),
            ]
        );
        $this->add_control(
            'payment_date', [
                'label' => esc_html__('payment_date', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('1st Jan, 2025 3.09%', 'payone-core'),
            ]
        );

        $this->add_control(
            'user_img', [
                'label' => esc_html__('user img', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
                'description' => esc_html__('user img', 'payone-core'),
            ]
        );
        $this->add_control(
            'user_title', [
                'label' => esc_html__('user_title', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('25k+', 'payone-core'),
            ]
        );
        $this->add_control(
            'user_subtitle', [
                'label' => esc_html__('user_subtitle', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Active users', 'payone-core'),
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'client_section',
            [
                'label' => esc_html__('client Settings', 'payone-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'client_title', [
                'label' => esc_html__('client title', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Join 10,245+', 'payone-core'),
            ]
        );
        $this->add_control(
            'client_subtitle', [
                'label' => esc_html__('client subtitle', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('companies who’ve reached', 'payone-core'),
            ]
        );

        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'client_img', [
                'label' => esc_html__('client_img', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
                'description' => esc_html__('client_img', 'payone-core'),
            ]
        );
        $this->add_control('client_items', [
            'label' => esc_html__('client Item', 'payone-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'image' => array(
                        'url' => Utils::get_placeholder_image_src()
                    )
                ]
            ],
        ]);
        $this->end_controls_section();

        $this->start_controls_section(
            'banner_styling_settings_section',
            [
                'label' => esc_html__('Styling Settings', 'payone-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->end_controls_section();

    }


    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        echo '
            <script>
                jQuery(document).ready(function($) {
                    var swiper = new Swiper(".banner-brand-swiper", {
                        slidesPerView: 7,
                        loop: true,
                        autoplay: {
                            delay: 4000,
                            disableOnInteraction: false,
                        },
                        breakpoints: {
                            320: {
                            slidesPerView: 3,
                            },
                            524: {
                            slidesPerView: 3,
                            },
                            640: {
                            slidesPerView: 4,
                            },
                            768: {
                            slidesPerView: 5,
                            },
                            1024: {
                            slidesPerView: 6,
                            },
                            1199: {
                            slidesPerView: 7,
                            },
                        },
                    });
                });
            </script>';
        ?>

        <div class="pt-120 bg-base-two-600 z-1 position-relative overflow-hidden">
            <?php if($settings['scroll_down']['url']) : ?>
                <img src="<?php echo $settings['scroll_down']['url']; ?>" alt="img" class="position-absolute inset-block-end-80px inset-inline-start-7-persent d-lg-block d-none animation-moveTopBottom__two">
            <?php endif; ?>
            <?php if($settings['animate_img1']['url']) : ?>
                <img src="<?php echo $settings['animate_img1']['url']; ?>" alt="img" class="position-absolute inset-block-start-79px inset-inline-start-7-persent d-lg-block d-none animation-rotation__two">
            <?php endif; ?>
            <div class="container">
                <div class="position-relative">
                    <div class="row flex-wrap gy-4">
                        <div class="col-lg-6">
                            <div class="max-w-571-px">
                                <div class="tw-mb-10 position-relative">
                                    <?php if($settings['banner_subtitle']) : ?>
                                        <div class="d-flex align-items-center gap-1 tw-mb-3" data-aos="fade-up" data-aos-duration="800">
                                            <?php if($settings['banner_subtitle_img']['url']) : ?>
                                                <img src="<?php echo $settings['banner_subtitle_img']['url']; ?>" alt="star">
                                            <?php endif; ?>
                                            <span class="fw-normal tw-text-xl text-neutral-10 cursor-big"><?php echo $settings['banner_subtitle']; ?></span>
                                        </div>
                                    <?php endif; ?>
                                    <?php if($settings['banner_title']) : ?>
                                        <div class="position-relative" data-aos="fade-up" data-aos-duration="1000">
                                            <h2 class="banner-item-title text-neutral-10 fw-normal tw-mb-3 tw-text-15 cursor-big h1">
                                                <?php echo $settings['banner_title']; ?>
                                                <?php if($settings['banner_title_img']['url']) : ?>
                                                    <img src="<?php echo $settings['banner_title_img']['url']; ?>" alt="Image" class="banner-shape-one position-absolute max-w-411-px z-n1 inset-block-start-62px inset-inline-end--30px d-lg-block d-none">
                                                <?php endif; ?>
                                            </h2>
                                        </div>
                                    <?php endif; ?>
                                    <?php if($settings['banner_description']) : ?>
                                        <p class="banner-item-text text-neutral-10 fw-normal tw-text-lg line-clamp-2"  data-aos="fade-up" data-aos-duration="1100"><?php echo $settings['banner_description']; ?></p>
                                    <?php endif; ?>
                                </div>
                                <div class="d-flex align-items-center tw-gap-7 flex-wrap position-relative"  data-aos="fade-up" data-aos-duration="1200">
                                    <?php if($settings['btn_text']) : ?>
                                        <div class="position-relative">
                                            <a href="<?php echo $settings['btn_url']; ?>" class="px-4 banner-item-link bg-main-600 text-dark-600 fw-semibold w-100 tw-py-3 text-center tw-text-lg border-two-px-solid rounded-3 hover-text-dark-600 tw-duration-500"><?php echo $settings['btn_text']; ?></a>
                                        </div>
                                    <?php endif; ?>
                                    <?php if($settings['btn2_text']) : ?>
                                        <div class="d-flex align-items-center tw-gap-10 flex-wrap">
                                            <span class="text-neutral-10 fw-semibold tw-text-lg"><?php echo $settings['btn2_text']; ?></span>
                                            <div class="position-relative">
                                                <a href="<?php echo $settings['btn2_url']; ?>" class="play-button bg-light-animation tw-w-13 tw-h-13 d-inline-flex justify-content-center align-items-center bg-white text-base-two-600 hover-text-base-two-600 rounded-circle tw-text-xl position-absolute tw-start-50 tw--translate-middle top-50 z-1">
                                                    <i class="ph-fill ph-play"></i>
                                                </a>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <?php if($settings['main_img']['url']) : ?>
                            <div class="col-lg-6">
                                <div class="d-lg-block d-none text-end banner-1-main-image" data-aos="fade-up" data-aos-duration="1500">
                                    <img src="<?php echo $settings['main_img']['url']; ?>" alt="img" class="margin-top--40px">
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="banner-item">
                        <div class="bg-white tw-py-5 tw-px-5 rounded-3 d-inline-flex align-items-center tw-gap-3 position-absolute inset-block-start-70-persent inset-inline-start-42-persent z-1 max-w-263 animation-Updowm__two">
                            <?php if($settings['user_img']['url']) : ?>
                                <div class="d-flex align-items-center ">
                                    <img src="<?php echo $settings['user_img']['url']; ?>" alt="img">
                                </div>
                            <?php endif; ?>
                            <div>
                                <h4 class="fw-normal tw-text-6 counter lh-1">25k+</h4>
                                <span class="fw-normal tw-text-lg text-dark-500">Active users </span>
                            </div>
                        </div>
                    </div>
                    <?php if($settings['animate_img3']['url']) : ?>
                        <img src="<?php echo $settings['animate_img3']['url']; ?>" alt="igm" class="position-absolute inset-block-start-44-persent inset-inline-start-50-persent z-n1 d-lg-block d-none animation-pulse__two">
                    <?php endif; ?>
                    <?php if($settings['animate_img2']['url']) : ?>
                        <img src="<?php echo $settings['animate_img2']['url']; ?>" alt="img" class="arrow-shape-one position-absolute inset-inline-start-44-persent inset-block-start--10-persent z-n1 d-lg-block d-none animate-wobble__two">
                    <?php endif; ?>
                    <?php if($settings['animate_img4']['url']) : ?>
                        <img src="<?php echo $settings['animate_img4']['url']; ?>" alt="img" class="banner-shape-two position-absolute inset-inline-end--120px inset-block-end-120px z-n1 d-lg-block d-none animation-rotation__two">
                    <?php endif; ?>
                    <div class="banner-shape-five bg-white tw-py-5 tw-px-6 rounded-3 max-w-261 position-absolute inset-block-start-50px inset-inline-end--120px d-lg-block d-none z-1 animation-Updowm__two">
                        <span class="tw-text-lg fw-semibold text-dark-600 tw-mb-3">Payment Received</span>
                        <h4 class="fw-normal tw-mb-3 counter">+35,890.00</h4>
                        <div class="d-flex align-items-center tw-gap-2 justify-content-between">
                            <span class="tw-text-lg fw-semibold text-dark-600">1st Jan, 2025</span>
                            <div class="d-flex align-items-center tw-gap-2">
                                <span class="tw-text-lg fw-semibold text-primary-600">3.09%</span>
                                <span class="tw-text-xl fw-medium text-primary-600">
                                    <i class="ph-bold ph-trend-up"></i>
                                </span>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="banner-brand-item mt-lg-0 mt-4 bg-main-600 tw-pt-15 tw-ps-15 tw-pb-8 tw-pe-7  tw-w-1662-px tw-w-100vw banner-slider-bg-clip-path banner-clip__path-rtl border-top-left-80-px margin-top--94px">
                    <h3 class=" fw-normal cursor-big tw-mb-2" data-aos="fade-up" data-aos-duration="800">Join 10,245+ </h3>
                    <h5 class="fw-normal tw-mb-8" data-aos="fade-up" data-aos-duration="1000">companies who’ve reached</h5>
                    <div class="swiper banner-brand-swiper overflow-hidden z-1">
                        <div class="swiper-wrapper d-flex align-items-center w-100">
                            <?php foreach($settings['client_items'] as $client_item) : ?>
                                <div class="swiper-slide">
                                    <img src="<?php echo $client_item['client_img']['url'] ?>" alt="Image">
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>

            </div>
        </div>

        <?php
    }
}
Plugin::instance()->widgets_manager->register_widget_type(new Payone_Banner_One_Widget());