<?php
/**
 * Elementor Widget
 * @package payone
 * @since 1.0.0
 */

namespace Elementor;
class Payone_Accordion_One extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'payone-accordion-one';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Accordion 01', 'payone-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-editor-list-ul';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['payone_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {
        $this->start_controls_section(
            'accordion_section',
            [
                'label' => esc_html__('accordion Content', 'payone-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control('accordion_style', [
            'label' => esc_html__('accordion style', 'payone-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'style-1' => esc_html__('Style 1', 'payone-core'),
                'style-2' => esc_html__('style 2', 'payone-core'),
            ),
            'default' => 'style-1',
            'description' => esc_html__('Select accordion Style', 'payone-core')
        ]);

        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'title', [
                'label' => esc_html__('Title', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'description' => esc_html__('enter title.', 'payone-core'),
                'default' => esc_html__('What services do you offer?', 'payone-core')
            ]
        );
        $repeater->add_control(
            'content', [
                'label' => esc_html__('Content Title', 'payone-core'),
                'type' => Controls_Manager::TEXTAREA,
                'description' => esc_html__('enter title.', 'payone-core'),
                'default' => esc_html__('To access online and mobile banking, simply log in using your registered email or phone number along with your secure password. You can use our website via any browser or download our mobile app from the App Store or Google Play.', 'payone-core')
            ]
        );
        $this->add_control('accordion_items', [
            'label' => esc_html__('Accordion Item', 'payone-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
        ]);

        $this->add_control(
            'accordion_name', [
                'label' => esc_html__('accordion name', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('accordionExample', 'payone-core')
            ]
        );
        $this->add_control(
            'accordion_number', [
                'label' => esc_html__('accordion number', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('0', 'payone-core')
            ]
        );
        $this->end_controls_section();


        
        $this->start_controls_section(
            'styling_settings_section',
            [
                'label' => esc_html__('Styling Settings', 'payone-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control('subtitle_color', [
            'label' => esc_html__('Subtitle Color', 'payone-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .text-main-600" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_control('bg_color', [
            'label' => esc_html__('bg Color', 'payone-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .accordion .bg-white" => "background-color: {{VALUE}} !important"
            ]
        ]);
        $this->end_controls_section();

    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $accordion_items = $settings['accordion_items'];
        ?>
            <?php if($settings['accordion_style'] == 'style-1'): ?>
            <div class="accordion" id="<?php echo $settings['accordion_name']; ?>">
                <?php 
                    $i = $settings['accordion_number'];
                    foreach($accordion_items as $accordion_item) : 
                    $i++;
                    if($i < 2) {
                        $show = 'show';
                    }else {
                        $show = '';
                    }
                ?>
                        <div class="accordion-item tw-mb-6 rounded-3 bg-white border-neutral-1px-solid" data-aos="fade-up" data-aos-duration="700">
                            <h2 class="accordion-header cursor-big">
                                <button class="accordion-button bg-white rounded-3 tw-text-xl" type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo $i; ?>" aria-expanded="true" aria-controls="collapse<?php echo $i; ?>">
                                    <?php echo $accordion_item['title']; ?>
                                </button>
                            </h2>
                            <div id="collapse<?php echo $i; ?>" class="accordion-collapse collapse <?php echo $show; ?>" data-bs-parent="#<?php echo $settings['accordion_name']; ?>">
                                <div class="accordion-body">
                                    <p class="fw-normal tw-text-lg text-dark-600"><?php echo $accordion_item['content']; ?></p>
                                </div>
                            </div>
                        </div>
                <?php endforeach; ?>
            </div>
            <?php elseif($settings['accordion_style'] == 'style-2'): ?>
                <div class="accordion" id="accordionExampleTwo">
                    <?php 
                        $bg_color = array('bg-main-600', 'bg-base-two-600', 'bg-warning-500', 'bg-main-600');
                        $i = 0;
                        $j = -1;
                        foreach($accordion_items as $accordion_item) : 
                        $i++;
                        $j++;
                        if($i < 2) {
                            $show = 'show';
                        }else {
                            $show = '';
                        }

                        if($j == 1){
                            $text_color = 'text-white';
                        }else {
                            $text_color = '';
                        }
                    ?>
                    <div class="accordion-item tw-mb-6 rounded-3 <?php echo $bg_color[$j]; ?>">
                        <h2 class="accordion-header cursor-big position-relative">
                            <button class="accordion-button-three <?php echo $bg_color[$j]; ?> rounded-3 tw-text-xl <?php echo $text_color; ?> text-dark-700 w-100 tw-px-6 tw-py-6 text-start" type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo $i; ?>" aria-expanded="true" aria-controls="collapse<?php echo $i; ?>">
                                <?php echo $accordion_item['title']; ?>
                            </button>
                        </h2>
                        <div id="collapse<?php echo $i; ?>" class="accordion-collapse collapse <?php echo $show; ?>" data-bs-parent="#accordionExampleTwo">
                            <div class="accordion-body">
                                <p class="fw-normal tw-text-md text-dark-700 <?php echo $text_color; ?>">
                                    <?php echo $accordion_item['content']; ?>
                                </p>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        <?php 
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Payone_Accordion_One());