<?php
/**
 * Elementor Widget
 * @package Payone
 * @since 1.0.0
 */

namespace Elementor;
class Payone_About_Img_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
    */
    public function get_name()
    {
        return 'payone-about-img-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('About Img', 'payone-core');
    }

    public function get_keywords()
    {
        return ['Section', 'About', 'Title', 'payone-core'];
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-heading';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['payone_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'payone-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'about_img', [
                'label' => esc_html__('About img 1', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
                'description' => esc_html__('About Img 1', 'payone-core'),
                'default' => array(
                    'url' => Utils::get_placeholder_image_src()
                )
            ]
        );

        $this->add_control(
            'rate_img', [
                'label' => esc_html__('rate img', 'payone-core'),
                'type' => Controls_Manager::MEDIA,
                'description' => esc_html__('rate Img', 'payone-core')
            ]
        );
        $this->add_control(
            'rate_count', [
                'label' => esc_html__('rate count', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('45', 'payone-core')
            ]
        );
        $this->add_control(
            'rate_title', [
                'label' => esc_html__('rate title', 'payone-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Success rate', 'payone-core')
            ]
        );
        $this->end_controls_section();

        /*  tab styling tabs start */
        $this->start_controls_section(
            'tab_settings_section',
            [
                'label' => esc_html__('Tab Settings', 'payone-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->end_controls_section();
    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>

        <div class="position-relative">
            <?php if($settings['about_img']['url']) : ?>
                <div>
                    <img src="<?php echo $settings['about_img']['url']; ?>" alt="Image"  data-aos="zoom-in" data-aos-duration="1200">
                </div>
            <?php endif; ?>
            
            <div class="our-feature__card-one bg-white tw-w-232-px tw-h-116-px position-absolute top-0 tw-start-0 border-bottom-right-24-px" data-aos="fade-right" data-aos-duration="1000">
                <div class="our-feature-card-three max-w-219 bg-warning-500 rounded-3 tw-px-6 tw-py-5 d-flex align-items-center tw-gap-4 position-absolute inset-inline-start-0 inset-block-start-0">
                    <?php if($settings['rate_img']['url']) : ?>    
                        <img src="<?php echo $settings['rate_img']['url']; ?>" alt="Image" data-aos-duration="800">
                    <?php endif; ?>
                    <div>
                        <h3 class="fw-normal text-dark-600 mb-0 cursor-big counter">45%</h3>
                        <span class="fw-normal tw-text-md text-dark-500">Success rate</span>
                    </div>
                </div>
            </div>

            <div class="our-feature__card-two tw-w-200-px tw-h-150-px position-absolute bottom-0 tw-end-0 bg-white border-top-left-24-px" data-aos="fade-left" data-aos-duration="1000">
                <div class="our-feature-card-four max-w-176 bg-main-600 rounded-3 tw-px-6 tw-py-5 position-absolute inset-block-end-0 inset-inline-end-0">
                    <div>
                        <h3 class="fw-normal text-dark-600 mb-1 cursor-big counter">11.5k</h3>
                        <span class="fw-normal tw-text-lg text-dark-500">Banking Card available</span>
                    </div>
                </div>
            </div>
        </div>
        
        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Payone_About_Img_Widget());