<?php
/**
 * Widget: Instagram (Gutenberg support)
 *
 * @package WordPress
 * @subpackage ThemeREX Addons
 * @since v1.6.47
 */

// Don't load directly
if ( ! defined( 'TRX_ADDONS_VERSION' ) ) {
	die( '-1' );
}


// Gutenberg Block
//------------------------------------------------------

// Add scripts and styles for the editor
if ( ! function_exists( 'trx_addons_gutenberg_sc_instagram_editor_assets' ) ) {
	add_action( 'enqueue_block_editor_assets', 'trx_addons_gutenberg_sc_instagram_editor_assets' );
	function trx_addons_gutenberg_sc_instagram_editor_assets() {
		if ( trx_addons_exists_gutenberg() && trx_addons_get_setting( 'allow_gutenberg_blocks' ) ) {
			// Scripts
			wp_enqueue_script(
				'trx-addons-gutenberg-editor-block-instagram',
				trx_addons_get_file_url( TRX_ADDONS_PLUGIN_WIDGETS . 'instagram/gutenberg/instagram.gutenberg-editor.js' ),
				trx_addons_block_editor_dependencis(),
				filemtime( trx_addons_get_file_dir( TRX_ADDONS_PLUGIN_WIDGETS . 'instagram/gutenberg/instagram.gutenberg-editor.js' ) ),
				true
			);
		}
	}
}

// Block register
if ( ! function_exists( 'trx_addons_sc_instagram_add_in_gutenberg' ) ) {
	add_action( 'init', 'trx_addons_sc_instagram_add_in_gutenberg' );
	function trx_addons_sc_instagram_add_in_gutenberg() {
		if ( trx_addons_exists_gutenberg() && trx_addons_get_setting( 'allow_gutenberg_blocks' ) ) {
			register_block_type(
				'trx-addons/instagram', array(
					'attributes'      => array_merge(
						array(
							'title'       => array(
								'type'    => 'string',
								'default' => esc_html__( 'Instagram feed', 'trx_addons' ),
							),
							'count'       => array(
								'type'    => 'number',
								'default' => 8,
							),
							'columns'     => array(
								'type'    => 'number',
								'default' => 4,
							),
							'columns_gap' => array(
								'type'    => 'number',
								'default' => 0,
							),
							'hashtag'     => array(
								'type'    => 'string',
								'default' => '',
							),
							'links'       => array(
								'type'    => 'string',
								'default' => 'instagram',
							),
							'follow'      => array(
								'type'    => 'boolean',
								'default' => 0,
							),
						),
						trx_addons_gutenberg_get_param_id()
					),
					'render_callback' => 'trx_addons_gutenberg_sc_instagram_render_block',
				)
			);
		}
	}
}

// Block render
if ( ! function_exists( 'trx_addons_gutenberg_sc_instagram_render_block' ) ) {
	function trx_addons_gutenberg_sc_instagram_render_block( $attributes = array() ) {
		return trx_addons_sc_widget_instagram( $attributes );
	}
}


// Add shortcode's specific lists to the JS storage
if ( ! function_exists( 'trx_addons_sc_instagram_gutenberg_sc_params' ) ) {
	add_filter( 'trx_addons_filter_gutenberg_sc_params', 'trx_addons_sc_instagram_gutenberg_sc_params' );
	function trx_addons_sc_instagram_gutenberg_sc_params( $vars = array() ) {

		// If editor is active now
		$is_edit_mode = trx_addons_is_post_edit();
		
		// Return list of the instagram redirects
		$vars['sc_instagram_redirects'] = !$is_edit_mode ? array() : trx_addons_get_list_sc_instagram_redirects();

		return $vars;
	}
}
