<?php
/**
 * @package copygen Addons
 * @subpackage Brochure
 * @since 1.0.0
 */
add_action( 'widgets_init', function(){
	register_widget( 'copygen_about' );
});
class copygen_about extends \WP_Widget {

	public function __construct() {
		$widget_ops = array(
			'classname'                   => 'widget_about_copygen',
			'description'                 => __( 'copygen About Content Widget' ),
			'customize_selective_refresh' => true,
		);

		parent::__construct( 'copygen-about-van', __( 'copygen - About Us' ), $widget_ops );
		$this->alt_option_name = 'widget_about_copygen';
	}

	public function widget( $args, $instance ) {
	
		extract( $args );
		echo wp_kses_post($before_widget); ?>

        <div class="avout_us_widgets widget_box">
                <?php if(! empty($instance['imagetwo'])) : ?> 
		            <img src="<?php echo wp_kses_post($instance['imagetwo']); ?>" alt="image" class="bg_images"/>
		        <?php endif; ?>
            <div class="widget_content">
                <div class="cont">
                    <?php if(!empty($instance['title'])) : ?>
                        <div class="title_no_a_26"><?php echo wp_kses_post($instance['title']); ?></div>
                    <?php endif; ?>
                    <?php if(! empty($instance['linktext'])) : ?> 
                        <a class="theme_btn" href="<?php if(! empty($instance['linktext'])): echo esc_url($instance['link']); endif; ?>">
                        <?php echo wp_kses_post($instance['linktext']); ?>
                        <svg width="12" height="12" viewBox="0 0 12 12" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M1 11L11 1M11 1H3.5M11 1V8.5" stroke="white" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>
                    </a>
                    <?php endif; ?>
                </div>
                <?php if(! empty($instance['image'])) : ?> 
		            <img src="<?php echo wp_kses_post($instance['image']); ?>" alt="image"/>
		        <?php endif; ?>
             
            </div>
        </div>
 
	<?php echo wp_kses_post($after_widget);

}

	public function update( $new_instance, $old_instance ) {
		$instance              = $old_instance;

		$instance['title']     = $new_instance['title'] ;
		$instance['linktext']     = $new_instance['linktext'] ;
		$instance['link']     = strip_tags( $new_instance['link'] );
        $instance['image']     = $new_instance['image'] ;
        $instance['imagetwo']     = $new_instance['imagetwo'] ;
		return $instance;
	}

	public function form( $instance ) {
	
		$title     = ( $instance ) ? esc_attr( $instance['title'] ) : '';
		$image =  ( $instance ) ? esc_attr( $instance['image'] ) : '';
        $imagetwo =  ( $instance ) ? esc_attr( $instance['imagetwo'] ) : '';
		$linktext     =  ($instance ) ? esc_attr( $instance['linktext'] ) : '';
        $link     = ( $instance ) ? esc_attr( $instance['link'] ) : ''; 
		?>


    <p>
        <label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php esc_html_e( 'Title:' ); ?></label>
        <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
    </p>
 
	<p>
		<label for="<?php echo esc_attr($this->get_field_id( 'linktext' )); ?>"><?php esc_html_e( 'Link Text:' ); ?></label>
		<input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'linktext' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'linktext' )); ?>" type="text" value="<?php echo esc_attr($linktext); ?>" />
	</p>

	<p>
		<label for="<?php echo esc_attr($this->get_field_id( 'link' )); ?>"><?php esc_html_e( 'Link:' ); ?></label>
		<input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'link' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'link' )); ?>" type="text" value="<?php echo esc_attr($link); ?>" />
	</p>

    <p>
		<label for="<?php echo esc_attr($this->get_field_id( 'image' )); ?>"><?php esc_html_e( 'Image:' ); ?></label>
		<input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'image' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'image' )); ?>" type="text" value="<?php echo esc_attr($image); ?>" />
	</p>


    <p>
		<label for="<?php echo esc_attr($this->get_field_id( 'imagetwo' )); ?>"><?php esc_html_e( 'Background Image:' ); ?></label>
		<input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'imagetwo' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'imagetwo' )); ?>" type="text" value="<?php echo esc_attr($imagetwo); ?>" />
	</p>



 
<?php
}
}





