<?php

namespace  Copygenaddons\Core\Widgets\Post;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Service_carousel_v1 extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'copygen-service-carousel-v1';
    }

    public function get_title()
    {
        return __('Service Post Carousel  V1', 'copygen-addons');
    }

    public function get_icon()
    {
        return 'icon-steel';
    }

    public function get_categories()
    {
        return ['102'];
    }

    protected function register_controls(){
 
        // style one start
        $this->start_controls_section('service_settings',
        [ 
            'label' => __('Service Content', 'copygen-addons'),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
        );


        $this->add_control(
            'service_style',
            [
                'label' => __('Service style', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'style_one'   => esc_html__( 'Style One', 'copygen-addons' ),
                    'style_two'   => esc_html__( 'Style Two', 'copygen-addons' ),
                ],
                'default' => 'style_one',
            ]
        );
       
  
        $this->add_control(
            'desktop',
            [
                'label' => __('Carousel Items to Display Desktop', 'copygen-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'min'     => 0,
                'max'     => 10,
                'step'    => 1,
                'default' => '3',
            ]
        );
        $this->add_control(
            'tablet',
            [
                'label' => __('Carousel Items to Display Tablet', 'copygen-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'min'     => 0,
                'max'     => 10,
                'step'    => 1,
                'default' => '3',
            ]
        );
        $this->add_control(
            'mobile',
            [
                'label' => __('Carousel Items to Display Mobile', 'copygen-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'min'     => 2,
                'max'     => 10,
                'step'    => 1,
                'default' => '2',
            ]
        );
    
        $this->add_control(
            'post_count',
            [
                'label' => __('Service Count', 'copygen-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
				'default' => 10,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
            ]
        );
        $this->add_control(
            'text_limits',
            [
                'label'   => esc_html__( 'Text Limit', 'copygen-addons' ),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'default' => 12,
                'min'     => 1,
                'max'     => 100,
                'step'    => 1,
            ]
        );
       
        $this->add_control(
			'query_orderby',
			[
				'label'   => esc_html__( 'Order By', 'copygen-addons' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => 'date',
				'options' => array(
					'date'       => esc_html__( 'Date', 'copygen-addons' ),
					'title'      => esc_html__( 'Title', 'copygen-addons' ),
					'menu_order' => esc_html__( 'Menu Order', 'copygen-addons' ),
					'rand'       => esc_html__( 'Random', 'copygen-addons' ),
				),
			]
		);
		$this->add_control(
			'query_order',
			[
				'label'   => esc_html__( 'Order', 'copygen-addons' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => array(
					'DESc' => esc_html__( 'DESC', 'copygen-addons' ),
					'ASC'  => esc_html__( 'ASC', 'copygen-addons' ),
				),
			]
        );
      
        $this->add_control(
            'query_category', 
			[
            'type' => \Elementor\Controls_Manager::SELECT,
			'label' => esc_html__('Category', 'copygen-addons'),
			'options' => copygen_get_service_categories(),
			]
        );

         

    $this->end_controls_section();
    $this->start_controls_section('owl_nav_style',
    [ 
        'label' => __('Custom Css', 'copygen-addons'),
        'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
    ]
    );
    $this->add_control(
        'nav_display',
        [
        'label' => __('Naigation Enable / Disabel', 'copygen-addons'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
            'nav_true' => __( 'Block', 'copygen-addons' ),
            'nav_false' => __( 'none', 'copygen-addons' ),
        ],
        'default' => __('nav_true' , 'copygen-addons'),
       
        ]
    );

    $this->add_control(
        'dots_display',
        [
        'label' => __('Dots Enable / Disabel', 'copygen-addons'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
            'dot_true' => __( 'Block', 'copygen-addons' ),
            'dot_false' => __( 'none', 'copygen-addons' ),
        ],
        'default' => __('dot_true' , 'copygen-addons'),
       
        ]
    );

 
    $this->add_control(
        'nav_style_options',
        [
        'label' => __('Nav Move Position', 'copygen-addons'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
            'position_one' => __( 'Position One', 'copygen-addons' ),
            'position_two' => __( 'Position Two', 'copygen-addons' ),
            'position_three' => __( 'Position Three', 'copygen-addons' ),
            'position_four' => __( 'Position Four', 'copygen-addons' ),
        ],
        'default' => __('position_one' , 'copygen-addons'),
        ]
    );
    $this->add_responsive_control(
        'nav_move_count',
        [
            'label' => __('Nav Move Top', 'copygen-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'min'     => -100,
            'max'     => 1,
            'step'    => 1,
            'default'    => 0,
            'condition' => [
                'nav_style_options' => ['position_two' , 'position_three'],
            ],
            'selectors' => [
                '{{WRAPPER}}  .position_two .owl-carousel .owl-nav , {{WRAPPER}}  .position_three .owl-carousel .owl-nav ' => 'top: {{VALUE}}px!important;',
            ],
        ]
    );
   
    $this->add_responsive_control(
        'nav_move_prev_left',
        [
            'label' => __('Prev Move Left', 'copygen-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'min'     => -1000,
            'max'     => 1000,
            'step'    => 1,
            'default'    => 0,
            'condition' => [
                'nav_style_options' => 'position_four',
            ],
            'selectors' => [
                '{{WRAPPER}}  .position_four .owl-carousel .owl-nav .owl-prev   ' => 'left: {{VALUE}}px!important;',
            ],
        ]
    );
    $this->add_responsive_control(
        'nav_move_nest_right',
        [
            'label' => __('Prev Move Right', 'copygen-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'min'     => -1000,
            'max'     => 1000,
            'step'    => 1,
            'default'    => 0,
            'condition' => [
                'nav_style_options' => 'position_four',
            ],
            'selectors' => [
                '{{WRAPPER}}  .position_four .owl-carousel .owl-nav .owl-next   ' => 'right: {{VALUE}}px!important;',
            ],
        ]
    );


    $this->add_control(
        'owl_nav_color',
         [
            'label' => __('Owl Nav Arrow Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .sec_category_carousels  .owl-nav i ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
     
    $this->add_control(
        'owl_nav_bg_color',
         [
            'label' => __('Owl Nav Arrow Bg Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .sec_category_carousels .owl-carousel .owl-nav .owl-prev, .sec_category_carousels .owl-carousel .owl-nav .owl-next ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );

    
    $this->add_control(
        'owl_nav_hover_color',
         [
            'label' => __('Owl Nav Hover Arrow Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .sec_category_carousels  .owl-nav .owl-prev:hover i , {{WRAPPER}} .sec_category_carousels  .owl-nav .owl-next:hover i ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
     
    $this->add_control(
        'owl_nav_hover_bg_color',
         [
            'label' => __('Owl Nav Hover Arrow Bg Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .sec_category_carousels .owl-carousel .owl-nav .owl-prev:hover , {{WRAPPER}} .sec_category_carousels .owl-carousel .owl-nav .owl-next:hover ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );

    $this->add_control(
        'dot_color',
         [
            'label' => __('Dot One Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .owl-carousel .owl-dots .owl-dot span ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );
 
    $this->add_control(
        'dot_ac_color',
         [
            'label' => __('Dot One Active / Hover Color', 'copygen-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .owl-carousel .owl-dots .owl-dot.active , {{WRAPPER}} .owl-carousel .owl-dots .owl-dot:hover ' => 'border-color: {{VALUE}}!important;',
                '{{WRAPPER}} .owl-carousel .owl-dots .owl-dot:hover span , {{WRAPPER}} .owl-carousel .owl-dots .owl-dot.active span ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );

 

    $this->end_controls_section();

    }
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');

    ?>
     <section class="service_post <?php echo esc_attr($settings['service_style']); ?> position-relative <?php echo esc_attr($settings['nav_style_options']); ?> <?php echo esc_attr($settings['nav_display']); ?> <?php echo esc_attr($settings['dots_display']); ?>"   data-scroll>
     <div class="theme_carousel owl-theme owl-carousel" data-options='{"loop": true , "margin": 30, "autoheight":true, "lazyload":true, "nav": true, "dots": true, "autoplay": false, "autoplayTimeout": 6000,  "smartSpeed": 300, "responsive":{ "0" :{ "items": "1" }, "320" :{ "items" : "1" }, "500" :{ "items" : "1" }, "768" :{ "items" : "<?php echo esc_attr($settings['mobile']); ?>" } , "992":{ "items" : "<?php echo esc_attr($settings['tablet']); ?>" }, "1200":{ "items" : "<?php echo esc_attr($settings['desktop']); ?>" }}}'>
                <?php  $paged = ( get_query_var('paged') ) ? get_query_var('paged') : 1;
                  $query_args = array(
                        'post_type' => 'service',
                        'ignore_sticky_posts' => true,
                        'orderby' => 'date',
                        'paged'  => $paged,
                        'posts_per_page' => $settings['post_count'],
                        'orderby'        => $settings['query_orderby'],
                        'order'          =>  $settings['query_order'],
                    );
                    if($settings['query_category'] ) $query_args['service_category'] = $settings['query_category'];
                     
                        $service_query = new \WP_Query( $query_args );
                    ?>
                    <?php if($service_query->have_posts()):
                            while($service_query->have_posts()) : $service_query->the_post();
                            global $post;
                            $featured_img_url = get_the_post_thumbnail_url($post->ID, 'full'); 
                            $service_icon_type = get_post_meta(get_the_ID() , 'service_icon_type', true);
                            $ser_icon = get_post_meta(get_the_ID() , 'ser_icon', true);
                            $ser_icon_img = get_post_meta(get_the_ID() , 'ser_icon_img', true);
                            $serv_steps = get_post_meta(get_the_ID() , 'serv_steps', true);
                    // while loop start ?>
                    <?php // servie style ?>
						<?php if($settings['service_style'] == 'style_one'): ?>
                    <?php // servie style ?>    
                      
                            <div class="service_box type_one">
                                <?php if(has_post_thumbnail()): ?>
                                    <a href="<?php echo esc_url(get_permalink()); ?>">
                                        <div class="image"> 
                                            <img class="img-fluid" src="<?php echo esc_url($featured_img_url); ?>" alt="<?php the_title(); ?>" />
                                        </div>
                                    </a>
                                <?php endif; ?>
                                <div class="content_box"> 
                                    <div class="content_inner trans">
                                    <?php if($service_icon_type == 'image'): ?>
                                        <?php if(!empty($ser_icon_img['url'])): ?>
                                        <div class="icon trans">
                                            <img class="img-fluid" src="<?php echo esc_url($ser_icon_img['url']); ?>" alt="icon" />
                                        </div>
                                        <?php endif; ?>
                                    <?php elseif($service_icon_type == 'icon'): ?>
                                        <div class="icon trans">
                                            <i class="<?php echo esc_attr($ser_icon); ?> trans"></i>
                                        </div>
                                    <?php endif; ?>
                                    <?php if(!empty($serv_steps)): ?>
                                        <div class="steps trans"><?php echo esc_attr($serv_steps); ?></div>
                                    <?php endif; ?>
                                    <h4 class="title_24 trans" data-splitting>
                                        <?php the_title('<a href="' .  esc_url(get_permalink()) . '">', '</a>'); ?>
                                    </h4>
                                    <?php $excerpt = '';
                                    if (has_excerpt()): ?>
                                    <p class="trans">
                                        <?php 
                                            $excerpt = wp_strip_all_tags(wp_trim_words(get_the_excerpt() , $settings['text_limits']));
                                            echo esc_attr($excerpt);
                                        ?>
                                    </p> 
                                    <?php endif; ?>
                                    <a class="link trans" href="<?php echo esc_url(get_permalink()); ?>">
                                        <svg width="13" height="13" viewBox="0 0 13 13" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M1 12.25L12.25 1M12.25 1H3.8125M12.25 1V9.4375" stroke="#2D947A" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                        </svg>
                                    </a>
                                </div>
                            </div>
                        </div>
                        <?php // servie style ?>
						<?php elseif($settings['service_style'] == 'style_two'): ?>
                    <?php // servie style ?>    
                      
                        <div class="process_box  type_two hover_1_get">
                                    <?php if(has_post_thumbnail()): ?>
                                    <div class="image_box hover_1">
                                        <img src="<?php echo esc_url($featured_img_url); ?>" alt="<?php the_title(); ?>"  />
                                        <div class="oh ho_1"></div>
                                        <div class="oh ho_2"></div>
                                        <div class="oh ho_3"></div>
                                        <div class="oh ho_4"></div>
                                        <?php if($service_icon_type == 'image'): ?>
                                            <?php if(!empty($ser_icon_img['url'])): ?>
                                            <div class="icon trans">
                                                <img class="img-fluid" src="<?php echo esc_url($ser_icon_img['url']); ?>" alt="icon" />
                                            </div>
                                            <?php endif; ?>
                                            <?php elseif($service_icon_type == 'icon'): ?>
                                                <div class="icon trans">
                                                    <i class="<?php echo esc_attr($ser_icon); ?> trans"></i>
                                                </div>
                                            <?php endif; ?>
                                    </div>
                                <?php endif; ?>
                            
                                <div class="content">
                                 
                                        <a class="rd_more trans" href="<?php echo esc_url(get_permalink()); ?>">
                                            <svg width="21" height="21" viewBox="0 0 21 21" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path fill-rule="evenodd" clip-rule="evenodd" d="M5.60161 0H19.6641C19.9128 0 20.1512 0.0987719 20.327 0.274587C20.5028 0.450403 20.6016 0.68886 20.6016 0.9375V15C20.6016 15.2486 20.5028 15.4871 20.327 15.6629C20.1512 15.8387 19.9128 15.9375 19.6641 15.9375C19.4155 15.9375 19.177 15.8387 19.0012 15.6629C18.8254 15.4871 18.7266 15.2486 18.7266 15V3.2L1.57661 20.35C1.3989 20.5156 1.16384 20.6058 0.920961 20.6015C0.678085 20.5972 0.446354 20.4988 0.274588 20.327C0.102821 20.1553 0.00443133 19.9235 0.000146059 19.6807C-0.00413921 19.4378 0.0860148 19.2027 0.251615 19.025L17.4016 1.875H5.60161C5.35297 1.875 5.11452 1.77623 4.9387 1.60041C4.76289 1.4246 4.66411 1.18614 4.66411 0.9375C4.66411 0.68886 4.76289 0.450403 4.9387 0.274587C5.11452 0.0987719 5.35297 0 5.60161 0Z" fill="white"/>
                                            </svg>
                                        </a> 
                                  
                                   
                                        <div class="title_22" data-splitting>
                                        <?php the_title('<a href="' .  esc_url(get_permalink()) . '">', '</a>'); ?>
                                        </div>
                               
                           
                                        <?php $excerpt = '';
                                    if (has_excerpt()): ?>
                                    <p class="trans">
                                        <?php 
                                            $excerpt = wp_strip_all_tags(wp_trim_words(get_the_excerpt() , $settings['text_limits']));
                                            echo esc_attr($excerpt);
                                        ?>
                                    </p> 
                                    <?php endif; ?>
                             
                                    
                                </div>
                            </div>
                            <?php // servie style ?>              
                                <?php endif; ?>
                            <?php // servie style ?>                        
	
                    <?php endwhile; // while loop end ?>
                <?php wp_reset_postdata(); ?>
            <?php endif; // Post Endif after loop end  ?>
        </div>
   
   
</section>
 
        <?php
    }
}

         