<?php

namespace  Copygenaddons\Core\Widgets\Header;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Menu_v1 extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'copygen-menu-v1';
    }

    public function get_title()
    {
        return __('Menu V1', 'copygen-addons');
    }

    public function get_icon()
    {
        return 'icon-steel';
    }

    public function get_categories()
    {
        return ['100'];
    }

    protected function register_controls(){
        $this->start_controls_section('menu_settings',
        [ 
            'label' => __('Menu Settings', 'copygen-addons'),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
        ); 
        $this->add_control(
            'navigations',
            [
                'label' => __('Select Navigation', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'options' => copygen_navmenu(),
            ]
        );
        $this->add_control(
            'hr_1',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_responsive_control(
            'text_align',
            [
                'label' => esc_html__( 'Alignment', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'start' => [
                        'title' => esc_html__( 'Left', 'copygen-addons' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'copygen-addons' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'end' => [
                        'title' => esc_html__( 'Right', 'copygen-addons' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'center',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .navbar_content  ' => 'justify-content: {{VALUE}}!important;',
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section('menu_css',
        [ 
            'label' => __('Menu Css', 'copygen-addons'),
            'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
        ]);
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__( 'Menu Typography', 'copygen-addons' ),
                'name' => 'menu_typo',
                'selector' => '{{WRAPPER}} .navbar_nav .menu-item > a.nav_link ',
            ]
        );
        $this->add_control(
            'shr_1',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_control(
            'menu_item_padding',
            [
                'label' => esc_html__( 'Menu Item Padding', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .navbar_nav > .menu-item ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
                ],
            ]
        );
        $this->add_control(
            'shr_2',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_control(
            'menu_item_color',
            [
                'label' => __('Menu Color', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .navbar_nav > .menu-item > a.nav_link ' => 'color: {{VALUE}}!important;',
                ],
            ]
        ); 
        $this->add_control(
            'shr_3',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_control(
            'menu_item_active_color',
            [
                'label' => __('Menu Active / Hover Color', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .navbar_nav > .menu-item.active > a.nav_link , {{WRAPPER}} .navbar_nav > .menu-item > a.nav_link:hover ' => 'color: {{VALUE}}!important;',
                ],
            ]
        );
    
        $this->add_control(
            'shr_4',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_control(
            'menu_item_arrow_color',
            [
                'label' => __('Arrow Color', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .navbar_nav li .dropdown-btn .fa-angle-down  ' => 'color: {{VALUE}}!important;',
                ],
            ]
        );  
        $this->add_control(
            'shr_41',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_control(
            'badge_color',
            [
                'label' => __('Badge Color', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .navbar_nav > li > a .text-link .hot-badges  ' => 'color: {{VALUE}}!important;',
                ],
            ]
        ); 
        $this->add_control(
            'shr_42',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_control(
            'badgebg_color',
            [
                'label' => __('Badge Background Color', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .navbar_nav > li > a .text-link .hot-badges  ' => 'background: {{VALUE}}!important;',
                ],
            ]
        ); 
        $this->end_controls_section();
        $this->start_controls_section('dropdown_menu_css',
        [ 
            'label' => __('Dropdown Css', 'copygen-addons'),
            'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
        ]); 
        $this->add_control(
            'drop_down_bg_color',
            [
                'label' => __('Dropdown Bg Color', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [  
                    '{{WRAPPER}} .navbar_nav .menu-item > .sub-menu  ' => 'background: {{VALUE}}!important;',
                ],
            ]
        ); 
        $this->add_control(
            'shr_5',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_control(
            'drop_down_menu_color',
            [
                'label' => __('Dropdown Menu Color', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .navbar_nav .menu-item .sub-menu li a ' => 'color: {{VALUE}}!important;',
                ],
            ]
        ); 
        $this->add_control(
            'shr_51',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_control(
            'dbadge_color',
            [
                'label' => __('Badge Color', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .navbar_nav .menu-item .sub-menu .text-link .hot-badges  ' => 'color: {{VALUE}}!important;',
                ],
            ]
        ); 
        $this->add_control(
            'dshr_52',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_control(
            'dbadgebg_color',
            [
                'label' => __('Badge Background Color', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .navbar_nav .menu-item .sub-menu .text-link .hot-badges  ' => 'background: {{VALUE}}!important;',
                ],
            ]
        ); 
        $this->add_control(
            'shr_53',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_control(
            'dmenu_item_active_color',
            [
                'label' => __('Dropdown Menu Hover Color', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .navbar_nav .menu-item .sub-menu li a:hover ' => 'color: {{VALUE}}!important;',
                ],
            ]
        );
        $this->add_control(
            'shr_54',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_control(
            'dmenu_itembgactive_color',
            [
                'label' => __('Dropdown Menu Hover Background Color', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .navbar_nav .menu-item .sub-menu li a:hover ' => 'background: {{VALUE}}!important;',
                ],
            ]
        );
        $this->end_controls_section(); 
       
        $this->start_controls_section('mobile_nav',
        [ 
            'label' => __('Mobile Navigation Css', 'copygen-addons'),
            'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
        ]); 
       
        $this->add_control(
            'navigation_btn_color',
            [
                'label' => __('Navigation Button Color', 'copygen-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .menu_boxed .m_bx .navbar_togglers  .line' => 'background: {{VALUE}}!important;',
                ],
            ]
        ); 
        $this->add_control(
            'shr_9',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_responsive_control(
            'move_top',
            [
                'label' => __( 'Navigation Button Move Top ( For Mobile)', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 300,
                'step' => 1,
                'selectors' => [
                    '{{WRAPPER}} .menu_boxed .m_bx  ' => 'top: {{VALUE}}px',
                ],
            ]
        );
        $this->add_control(
            'shr_10',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_responsive_control(
            'mover_left',
            [
                'label' => __( 'Navigation Button Move Right ( For Mobile)', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => -3000,
                'max' => 3000,
                'step' => 1,
                'selectors' => [
                    '{{WRAPPER}} .menu_boxed .m_bx  ' => 'right: {{VALUE}}%',
                ],
            ]
        );
        $this->add_control(
            'shr_11',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );
        $this->add_responsive_control(
            'navvigtion_button_alignment',
            [
                'label' => esc_html__( 'Menu Button Alignment ( For Mobile)', 'copygen-addons' ),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'start' => [
                        'title' => esc_html__( 'Left', 'copygen-addons' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'copygen-addons' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'end' => [
                        'title' => esc_html__( 'Right', 'copygen-addons' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'end',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .menu_boxed .m_bx  ' => 'justify-content: {{VALUE}}!important;',
                ],
            ]
        );
    $this->end_controls_section(); 
} 
protected function render(){
$settings = $this->get_settings_for_display();
$allowed_tags = wp_kses_allowed_html('post');
?>
<div class="menu_boxed">
    <div class="m_bx">
        <div class="navbar_togglers hamburger_menu">
            <span class="line"></span>
            <span class="line"></span>
            <span class="line"></span>
        </div>
    </div>
    <div class="navbar_content d-flex align-items-center">
    <?php if(!empty($settings['navigations'])):
         wp_nav_menu(array(
            'menu' => $settings['navigations'],
            'container' => false,
            'menu_class' => 'navbar_nav',
            'fallback_cb'    => 'copygen_navwalker::fallback',
            'walker' => new \copygen_navwalker()
        )); 
    endif; ?>                   
    </div>
</div>
<?php
    }
}